/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.blockentity;

import com.aetherteam.aether.block.utility.SkyrootBedBlock;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.blockentity.SkyrootBedBlockEntity;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SkyrootBedRenderer
implements BlockEntityRenderer<SkyrootBedBlockEntity> {
    private final ModelPart headRoot;
    private final ModelPart footRoot;

    public SkyrootBedRenderer(BlockEntityRendererProvider.Context context) {
        this.headRoot = context.m_173582_(AetherModelLayers.SKYROOT_BED_HEAD);
        this.footRoot = context.m_173582_(AetherModelLayers.SKYROOT_BED_FOOT);
    }

    public void render(SkyrootBedBlockEntity bed, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level = bed.m_58904_();
        if (level != null) {
            BlockState blockstate = bed.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult combineResult = DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)AetherBlockEntityTypes.SKYROOT_BED.get()), BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)bed.m_58899_(), (p_112202_, p_112203_) -> false);
            int i = ((Int2IntFunction)combineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(combinedLight);
            this.renderPiece(poseStack, buffer, blockstate.m_61143_((Property)SkyrootBedBlock.f_49440_) == BedPart.HEAD ? this.headRoot : this.footRoot, (Direction)blockstate.m_61143_((Property)SkyrootBedBlock.f_54117_), i, combinedOverlay, false);
        } else {
            this.renderPiece(poseStack, buffer, this.headRoot, Direction.SOUTH, combinedLight, combinedOverlay, false);
            this.renderPiece(poseStack, buffer, this.footRoot, Direction.SOUTH, combinedLight, combinedOverlay, true);
        }
    }

    private void renderPiece(PoseStack poseStack, MultiBufferSource buffer, ModelPart model, Direction direction, int packedLight, int packedOverlay, boolean foot) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, foot ? -1.0 : 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + direction.m_122435_()));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)new ResourceLocation("aether", "textures/entity/tiles/bed/skyroot_bed.png")));
        model.m_104301_(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

