/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.client.gui.component.LorePageButton;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LoreBookScreen
extends AbstractContainerScreen<LoreBookMenu> {
    private static final ResourceLocation TEXTURE_LORE_BACKING = new ResourceLocation("aether", "textures/gui/menu/lore_backing.png");
    private static final ResourceLocation TEXTURE_LORE_BOOK = new ResourceLocation("aether", "textures/gui/menu/lore_book.png");
    private final Map<Integer, List<FormattedCharSequence>> pages = new HashMap<Integer, List<FormattedCharSequence>>();
    private LorePageButton previousButton;
    private LorePageButton nextButton;
    private int currentPageNumber;
    private ItemStack lastStack;

    public LoreBookScreen(LoreBookMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97726_ = 256;
        this.f_97727_ = 199;
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.previousButton = (LorePageButton)this.m_142416_((GuiEventListener)new LorePageButton(i + 14, j + 169, 20, 20, (Component)Component.m_237113_((String)"<"), p_214201_1_ -> {
            if (this.currentPageNumber > 0) {
                --this.currentPageNumber;
            }
        }));
        this.nextButton = (LorePageButton)this.m_142416_((GuiEventListener)new LorePageButton(i + 221, j + 169, 20, 20, (Component)Component.m_237113_((String)">"), p_214201_1_ -> {
            if (this.currentPageNumber < this.pages.size() - 1) {
                ++this.currentPageNumber;
            }
        }));
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        String entryKey;
        MutableComponent previous = Component.m_237115_((String)"gui.aether.book_of_lore.previous");
        MutableComponent next = Component.m_237115_((String)"gui.aether.book_of_lore.next");
        this.drawBookText(matrixStack, this.f_96547_, (Component)previous, 13, 158);
        this.drawBookText(matrixStack, this.f_96547_, (Component)next, 221, 158);
        MutableComponent book = Component.m_237115_((String)"gui.aether.book_of_lore.book");
        MutableComponent ofLore = Component.m_237115_((String)"gui.aether.book_of_lore.of_lore");
        this.drawCenteredBookText(matrixStack, this.f_96547_, (Component)book, 75, 20);
        this.drawCenteredBookText(matrixStack, this.f_96547_, (Component)ofLore, 75, 30);
        MutableComponent item = Component.m_237115_((String)"gui.aether.book_of_lore.item");
        this.drawRightBookText(matrixStack, this.f_96547_, (Component)item, 78, 67);
        ItemStack itemStack = ((Slot)((LoreBookMenu)this.f_97732_).f_38839_.get(0)).m_7993_();
        if (!itemStack.m_41619_() && I18n.m_118936_((String)(entryKey = ((LoreBookMenu)this.f_97732_).getLoreEntryKey(itemStack)))) {
            MutableComponent entry = Component.m_237115_((String)entryKey);
            this.createPages((Component)entry);
            if (this.currentPageNumber == 0) {
                Component title = itemStack.m_41786_();
                this.createText(matrixStack, this.f_96547_.m_92923_((FormattedText)title, 98), 136, 10);
                this.createText(matrixStack, this.pages.get(0), 136, 32);
            } else {
                this.createText(matrixStack, this.pages.get(this.currentPageNumber), 136, 10);
            }
        }
        if (itemStack.m_41619_() || !itemStack.m_150930_(this.lastStack.m_41720_())) {
            this.pages.clear();
            this.currentPageNumber = 0;
        }
        this.previousButton.setIsActive(this.currentPageNumber > 0);
        this.nextButton.setIsActive(this.currentPageNumber < this.pages.size() - 1);
        this.lastStack = itemStack;
    }

    private void createText(PoseStack matrixStack, List<FormattedCharSequence> reorderingProcessors, int x, int y) {
        int length = 0;
        for (FormattedCharSequence line : reorderingProcessors) {
            this.drawBookText(matrixStack, this.f_96547_, line, x, y + length * 10);
            ++length;
        }
    }

    private void createPages(Component entry) {
        ArrayList formattedText = new ArrayList(this.f_96547_.m_92923_((FormattedText)entry, 98));
        if (formattedText.size() < 6) {
            List firstPage = formattedText.subList(0, formattedText.size());
            this.pages.put(0, firstPage);
        } else {
            List firstPage = formattedText.subList(0, 6);
            this.pages.put(0, firstPage);
            List remainingPages = formattedText.subList(6, formattedText.size());
            List list = Lists.partition(remainingPages, (int)8);
            for (int i = 1; i < list.size() + 1; ++i) {
                this.pages.put(i, (List)list.get(i - 1));
            }
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LORE_BACKING);
        LoreBookScreen.m_93133_((PoseStack)matrixStack, (int)i, (int)(j - 4), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)(this.f_97727_ + 56), (int)256, (int)256);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LORE_BOOK);
        LoreBookScreen.m_93133_((PoseStack)matrixStack, (int)(i + 12), (int)(j + 2), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)(this.f_97727_ + 56), (int)256, (int)256);
    }

    private void drawBookText(PoseStack matrixStack, Font fontRenderer, FormattedCharSequence font, int x, int y) {
        fontRenderer.m_92877_(matrixStack, font, (float)x, (float)y, 0x404040);
    }

    private void drawBookText(PoseStack matrixStack, Font fontRenderer, Component font, int x, int y) {
        FormattedCharSequence text = font.m_7532_();
        fontRenderer.m_92877_(matrixStack, text, (float)x, (float)y, 0x404040);
    }

    private void drawRightBookText(PoseStack matrixStack, Font fontRenderer, Component font, int x, int y) {
        FormattedCharSequence text = font.m_7532_();
        fontRenderer.m_92877_(matrixStack, text, (float)(x - fontRenderer.m_92724_(text)), (float)y, 0x404040);
    }

    private void drawCenteredBookText(PoseStack matrixStack, Font fontRenderer, Component font, int x, int y) {
        FormattedCharSequence text = font.m_7532_();
        fontRenderer.m_92877_(matrixStack, text, (float)(x - fontRenderer.m_92724_(text) / 2), (float)y, 0x404040);
    }
}

