/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen;

import com.aetherteam.aether.client.gui.component.NpcDialogueComponent;
import com.aetherteam.aether.client.gui.component.PlayerDialogueButton;
import com.aetherteam.aether.entity.monster.dungeon.boss.ValkyrieQueen;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.server.NpcPlayerInteractPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class ValkyrieQueenDialogueScreen
extends Screen {
    private final ValkyrieQueen queen;
    protected NpcDialogueComponent dialogue;

    public ValkyrieQueenDialogueScreen(ValkyrieQueen queen) {
        super(queen.getBossName());
        this.dialogue = new NpcDialogueComponent((Component)ValkyrieQueenDialogueScreen.setupQueenName(queen.getBossName()));
        this.queen = queen;
    }

    protected void m_7856_() {
        this.addDialogueOptions(new PlayerDialogueButton(ValkyrieQueenDialogueScreen.buildPlayerDialogue("question"), pButton -> this.finishChat((byte)0)), new PlayerDialogueButton(ValkyrieQueenDialogueScreen.buildPlayerDialogue("challenge"), pButton -> {
            this.setDialogue((Component)Component.m_237115_((String)"gui.aether.queen.dialog.challenge"));
            int count = this.f_96541_.f_91074_.m_150109_().m_18947_((Item)AetherItems.VICTORY_MEDAL.get());
            PlayerDialogueButton option = count >= 10 ? new PlayerDialogueButton(ValkyrieQueenDialogueScreen.buildPlayerDialogue("have_medals"), button -> this.finishChat((byte)1)) : new PlayerDialogueButton(ValkyrieQueenDialogueScreen.buildPlayerDialogue("no_medals").m_130946_(" (" + count + "/10)"), button -> this.finishChat((byte)1));
            this.addDialogueOptions(option, new PlayerDialogueButton(ValkyrieQueenDialogueScreen.buildPlayerDialogue("deny_fight"), button -> this.finishChat((byte)2)));
        }), new PlayerDialogueButton(ValkyrieQueenDialogueScreen.buildPlayerDialogue("leave"), pButton -> this.finishChat((byte)3)));
        this.positionDialogueOptions();
    }

    private void finishChat(byte interactionID) {
        AetherPacketHandler.sendToServer(new NpcPlayerInteractPacket(this.queen.m_19879_(), interactionID));
        super.m_7379_();
    }

    public void m_7379_() {
        this.finishChat((byte)3);
    }

    public void m_6574_(@Nonnull Minecraft pMinecraft, int pWidth, int pHeight) {
        this.f_96543_ = pWidth;
        this.f_96544_ = pHeight;
        this.positionDialogueOptions();
    }

    public void addDialogueOptions(PlayerDialogueButton ... options) {
        this.m_169413_();
        for (PlayerDialogueButton option : options) {
            this.m_142416_((GuiEventListener)option);
        }
        this.positionDialogueOptions();
    }

    private void positionDialogueOptions() {
        this.dialogue.reposition(this.f_96543_, this.f_96544_);
        int lineNumber = this.dialogue.height / 12 + 1;
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof PlayerDialogueButton)) continue;
            PlayerDialogueButton option = (PlayerDialogueButton)renderable;
            option.m_252865_(this.f_96543_ / 2 - option.m_5711_() / 2);
            option.m_253211_(this.f_96544_ / 2 + 12 * lineNumber);
            ++lineNumber;
        }
    }

    public void m_86412_(@Nonnull PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        this.dialogue.render(pPoseStack);
        super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public void m_7333_(@Nonnull PoseStack poseStack) {
        if (this.f_96541_.f_91073_ != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, poseStack));
        } else {
            this.m_264065_(poseStack);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void setDialogue(Component component) {
        this.dialogue.updateDialogue((Component)ValkyrieQueenDialogueScreen.setupQueenName(this.queen.getBossName()).m_130946_(": ").m_7220_(component));
    }

    public static MutableComponent setupQueenName(Component component) {
        return Component.m_237113_((String)"[").m_7220_((Component)component.m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_("]");
    }

    public static MutableComponent buildPlayerDialogue(String id) {
        return Component.m_237115_((String)("gui.aether.player.dialog." + id));
    }
}

