/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.gui.component.AccessoryButton;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.client.gui.screen.menu.AetherTitleScreen;
import com.aetherteam.aether.client.gui.screen.menu.VanillaLeftTitleScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiListener {
    public static final Set<UUID> BOSS_EVENTS = new HashSet<UUID>();

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Opening event) {
        AetherTitleScreen aetherMainMenuScreen;
        Screen screen = event.getScreen();
        GuiHooks.drawSentryBackground(screen);
        GuiHooks.setupWorldPreview(screen);
        VanillaLeftTitleScreen vanillaLeftTitleScreen = GuiHooks.openLeftDefaultMenu(screen);
        if (vanillaLeftTitleScreen != null) {
            event.setNewScreen((Screen)vanillaLeftTitleScreen);
        }
        if ((aetherMainMenuScreen = GuiHooks.openAetherMenu(screen)) != null) {
            event.setNewScreen((Screen)aetherMainMenuScreen);
        }
        GuiHooks.setupSplash(screen);
    }

    @SubscribeEvent
    public static void onGuiInitialize(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            Button quickLoadButton;
            Button menuSwitchButton;
            TitleScreen titleScreen = (TitleScreen)screen;
            GuiHooks.setSplashText(titleScreen);
            Button toggleWorldButton = GuiHooks.setupToggleWorldButton(screen);
            if (toggleWorldButton != null) {
                event.addListener((GuiEventListener)toggleWorldButton);
            }
            if ((menuSwitchButton = GuiHooks.setupMenuSwitchButton(screen)) != null) {
                event.addListener((GuiEventListener)menuSwitchButton);
            }
            if ((quickLoadButton = GuiHooks.setupQuickLoadButton(screen)) != null) {
                event.addListener((GuiEventListener)quickLoadButton);
            }
            GuiHooks.setMenuAlignment();
        } else if (!((Boolean)AetherConfig.CLIENT.disable_accessory_button.get()).booleanValue()) {
            AccessoryButton accessoryMenuAccessoryButton;
            Tuple<Integer, Integer> offsets = AccessoriesScreen.getButtonOffset(screen);
            AccessoryButton inventoryAccessoryButton = GuiHooks.setupAccessoryButtonWithinInventories(screen, offsets);
            if (inventoryAccessoryButton != null) {
                event.addListener((GuiEventListener)inventoryAccessoryButton);
            }
            if ((accessoryMenuAccessoryButton = GuiHooks.setupAccessoryButtonWithinAccessoryMenu(screen, offsets)) != null) {
                event.addListener((GuiEventListener)accessoryMenuAccessoryButton);
            }
        }
    }

    @SubscribeEvent
    public static void onGuiDraw(ScreenEvent.Render event) {
        Screen screen = event.getScreen();
        PoseStack poseStack = event.getPoseStack();
        Minecraft minecraft = Minecraft.m_91087_();
        GuiHooks.drawTrivia(screen, poseStack);
        GuiHooks.drawAetherTravelMessage(screen, poseStack);
        GuiHooks.changeMenuAlignment(screen, minecraft);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            GuiHooks.tickMenuWhenPaused(minecraft);
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        GuiHooks.openAccessoryMenu();
        GuiHooks.closeContainerMenu(event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public static void onRenderBoss(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        if (BOSS_EVENTS.contains(bossEvent.m_18860_())) {
            GuiHooks.drawBossHealthBar(event.getPoseStack(), event.getX(), event.getY(), bossEvent);
            event.setIncrement(event.getIncrement() + 13);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (GuiHooks.hideOverlays()) {
            event.setCanceled(true);
        }
    }
}

