/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.WorldDisplayHelper;
import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class LevelClientHooks {
    private static Float prevRotation = null;
    private static final TextureAtlasSprite LOCK = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("aether", "block/dungeon/lock"));
    private static final TextureAtlasSprite EXCLAMATION = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("aether", "block/dungeon/exclamation"));
    private static final TextureAtlasSprite DOOR = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("aether", "block/dungeon/door"));
    private static final TextureAtlasSprite TREASURE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("aether", "block/dungeon/treasure"));
    private static final HashMap<Integer, List<BlockPos>> positionsForTypes = new HashMap();

    public static void renderMenuWithWorld(RenderLevelStageEvent.Stage stage, Minecraft minecraft) {
        if (stage == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            if (((Boolean)AetherConfig.CLIENT.enable_world_preview.get()).booleanValue()) {
                if (WorldDisplayHelper.loadedSummary != null && (minecraft.f_91080_ == null || minecraft.f_91080_ instanceof PauseScreen)) {
                    LevelClientHooks.setupMenu(minecraft);
                }
            } else {
                WorldDisplayHelper.loadedLevel = null;
                WorldDisplayHelper.loadedSummary = null;
            }
        }
    }

    public static void setupMenu(Minecraft minecraft) {
        WorldDisplayHelper.setupLevelForDisplay();
        minecraft.m_91346_((Screen)GuiHooks.getMenu());
    }

    public static Float angleCamera(float prevYaw) {
        if (((Boolean)AetherConfig.CLIENT.enable_world_preview.get()).booleanValue() && WorldDisplayHelper.loadedLevel != null && WorldDisplayHelper.loadedSummary != null && Minecraft.m_91087_().f_91074_ != null) {
            if (prevRotation == null) {
                prevRotation = Float.valueOf(prevYaw);
            }
            float newYaw = prevRotation.floatValue() + 0.01f;
            prevRotation = Float.valueOf(newYaw);
            return Float.valueOf(newYaw);
        }
        prevRotation = null;
        return null;
    }

    public static void renderDungeonBlockOverlays(RenderLevelStageEvent.Stage stage, PoseStack poseStack, Camera camera, Frustum frustum, Minecraft minecraft) {
        if (stage == RenderLevelStageEvent.Stage.AFTER_PARTICLES && minecraft.f_91073_ != null) {
            LocalPlayer player = minecraft.f_91074_;
            ClientLevel level = minecraft.f_91073_;
            RenderBuffers renderBuffers = minecraft.m_91269_();
            int range = 32;
            if (player != null && player.m_7500_()) {
                BlockPos playerPos = player.m_20183_();
                ItemStack stack = player.m_21205_();
                int type = LevelClientHooks.idForItem(stack);
                if (type != -1) {
                    LevelClientHooks.updatePositions(playerPos, level, stack, range, type, false);
                }
                for (int i = 0; i < positionsForTypes.size(); ++i) {
                    LevelClientHooks.renderOverlays(level, poseStack, renderBuffers, camera, frustum, i);
                    LevelClientHooks.updatePositions(playerPos, level, stack, range, i, true);
                }
            }
        }
    }

    private static void updatePositions(BlockPos playerPos, ClientLevel level, ItemStack stack, int range, int type, boolean depopulate) {
        positionsForTypes.putIfAbsent(0, new ArrayList());
        positionsForTypes.putIfAbsent(1, new ArrayList());
        positionsForTypes.putIfAbsent(2, new ArrayList());
        positionsForTypes.putIfAbsent(3, new ArrayList());
        for (int c = 0; c < 667; ++c) {
            BlockPos pos;
            int x = playerPos.m_123341_() + level.f_46441_.m_188503_(range) - level.f_46441_.m_188503_(range);
            int y = playerPos.m_123342_() + level.f_46441_.m_188503_(range) - level.f_46441_.m_188503_(range);
            int z = playerPos.m_123343_() + level.f_46441_.m_188503_(range) - level.f_46441_.m_188503_(range);
            if (!depopulate) {
                BlockPos pos2 = new BlockPos(x, y, z);
                if (!stack.m_150930_(level.m_8055_(pos2).m_60734_().m_5456_()) || positionsForTypes.get(type).contains(pos2)) continue;
                positionsForTypes.get(type).add(pos2);
                continue;
            }
            List<BlockPos> positions = positionsForTypes.get(type);
            if (positions.size() <= 0 || level.f_46441_.m_188503_(100) != 0 || stack.m_150930_(level.m_8055_(pos = positions.get(level.f_46441_.m_188503_(positions.size()))).m_60734_().m_5456_())) continue;
            positions.remove(pos);
            positionsForTypes.put(type, positions);
        }
    }

    private static void renderOverlays(ClientLevel level, PoseStack poseStack, RenderBuffers renderBuffers, Camera camera, Frustum frustum, int type) {
        for (BlockPos blockPos : positionsForTypes.get(type)) {
            if (!frustum.m_113029_(new AABB(blockPos)) || level.m_8055_(blockPos).m_60799_() == RenderShape.INVISIBLE) continue;
            LevelClientHooks.drawSurfaces((MultiBufferSource)renderBuffers.m_110104_(), poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252943_(), blockPos, camera, (float)((double)blockPos.m_123341_() - camera.m_90583_().m_7096_()) - 0.001f, (float)((double)blockPos.m_123343_() - camera.m_90583_().m_7094_()) - 0.001f, (float)((double)blockPos.m_123341_() - camera.m_90583_().m_7096_()) + 1.001f, (float)((double)blockPos.m_123343_() - camera.m_90583_().m_7094_()) + 1.001f, (float)((double)blockPos.m_123342_() - camera.m_90583_().m_7098_()) - 0.001f, (float)((double)blockPos.m_123342_() - camera.m_90583_().m_7098_()) + 1.001f, type);
        }
        renderBuffers.m_110104_().m_109911_();
    }

    private static void drawSurfaces(MultiBufferSource buffer, Matrix4f matrix, Matrix3f normal, BlockPos blockPos, Camera camera, float startX, float startZ, float endX, float endZ, float botY, float topY, int type) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        TextureAtlasSprite sprite = LevelClientHooks.spriteForId(type);
        if (sprite != null) {
            float minU = sprite.m_118410_();
            float maxU = sprite.m_118409_();
            float minV = sprite.m_118412_();
            float maxV = sprite.m_118411_();
            if (camera.m_90583_().m_7098_() < (double)((float)blockPos.m_123342_() + botY)) {
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, botY, startZ, minU, minV, 0.0f, -1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, botY, startZ, maxU, minV, 0.0f, -1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, botY, endZ, maxU, maxV, 0.0f, -1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, botY, endZ, minU, maxV, 0.0f, -1.0f, 0.0f);
            }
            if (camera.m_90583_().m_7098_() > (double)((float)blockPos.m_123342_() + topY)) {
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, topY, startZ, minU, minV, 0.0f, 1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, topY, startZ, maxU, minV, 0.0f, 1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, topY, endZ, maxU, maxV, 0.0f, 1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, topY, endZ, minU, maxV, 0.0f, 1.0f, 0.0f);
            }
            if (camera.m_90583_().m_7094_() < (double)((float)blockPos.m_123343_() + startZ)) {
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, botY, startZ, minU, minV, 0.0f, 0.0f, -1.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, topY, startZ, minU, maxV, 0.0f, 0.0f, -1.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, topY, startZ, maxU, maxV, 0.0f, 0.0f, -1.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, botY, startZ, maxU, minV, 0.0f, 0.0f, -1.0f);
            }
            if (camera.m_90583_().m_7094_() > (double)((float)blockPos.m_123343_() + endZ)) {
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, botY, endZ, minU, minV, 0.0f, 0.0f, 1.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, topY, endZ, minU, maxV, 0.0f, 0.0f, 1.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, topY, endZ, maxU, maxV, 0.0f, 0.0f, 1.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, botY, endZ, maxU, minV, 0.0f, 0.0f, 1.0f);
            }
            if (camera.m_90583_().m_7096_() < (double)((float)blockPos.m_123341_() + startX)) {
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, botY, endZ, minU, minV, -1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, topY, endZ, minU, maxV, -1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, topY, startZ, maxU, maxV, -1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, startX, botY, startZ, maxU, minV, -1.0f, 0.0f, 0.0f);
            }
            if (camera.m_90583_().m_7096_() > (double)((float)blockPos.m_123341_() + endX)) {
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, botY, startZ, minU, minV, 1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, topY, startZ, minU, maxV, 1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, topY, endZ, maxU, maxV, 1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, matrix, normal, endX, botY, endZ, maxU, minV, 1.0f, 0.0f, 0.0f);
            }
        }
    }

    private static void buildVertex(VertexConsumer builder, Matrix4f matrix, Matrix3f normal, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ) {
        builder.m_252986_(matrix, x, y, z).m_6122_(255, 255, 255, 170).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normal, normalX, normalY, normalZ).m_5752_();
    }

    private static TextureAtlasSprite spriteForId(int id) {
        switch (id) {
            case 0: {
                return LOCK;
            }
            case 1: {
                return EXCLAMATION;
            }
            case 2: {
                return DOOR;
            }
            case 3: {
                return TREASURE;
            }
        }
        return null;
    }

    private static int idForItem(ItemStack stack) {
        if (stack.m_204117_(AetherTags.Items.LOCKED_DUNGEON_BLOCKS)) {
            return 0;
        }
        if (stack.m_204117_(AetherTags.Items.TRAPPED_DUNGEON_BLOCKS)) {
            return 1;
        }
        if (stack.m_204117_(AetherTags.Items.BOSS_DOORWAY_DUNGEON_BLOCKS)) {
            return 2;
        }
        if (stack.m_204117_(AetherTags.Items.TREASURE_DOORWAY_DUNGEON_BLOCKS)) {
            return 3;
        }
        return -1;
    }
}

