/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.api.WorldDisplayHelper;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.client.AetherMusicManager;
import com.aetherteam.aether.client.gui.component.AccessoryButton;
import com.aetherteam.aether.client.gui.component.DynamicMenuButton;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.client.gui.screen.menu.AetherTitleScreen;
import com.aetherteam.aether.client.gui.screen.menu.VanillaLeftTitleScreen;
import com.aetherteam.aether.event.hooks.DimensionHooks;
import com.aetherteam.aether.mixin.mixins.client.accessor.CreateWorldScreenAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.GuiComponentAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.RealmsPlayerScreenAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.TabButtonAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.server.OpenAccessoriesPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import net.minecraft.world.BossEvent;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.client.gui.CuriosScreen;

public class GuiHooks {
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("aether", "textures/gui/options_background.png");
    public static ResourceLocation OLD_BACKGROUND_LOCATION;
    public static ResourceLocation OLD_OPTIONS_BACKGROUND;
    public static final ResourceLocation LIGHT_DIRT_BACKGROUND;
    public static ResourceLocation OLD_LIGHT_DIRT_BACKGROUND;
    public static final ResourceLocation HEADER_SEPERATOR;
    public static ResourceLocation OLD_HEADER_SEPERATOR;
    public static final ResourceLocation FOOTER_SEPERATOR;
    public static ResourceLocation OLD_FOOTER_SEPERATOR;
    public static final ResourceLocation TEXTURE_LOCATION;
    public static ResourceLocation OLD_TEXTURE_LOCATION;
    public static AetherTitleScreen aether_menu;
    public static TitleScreen default_menu;
    public static VanillaLeftTitleScreen default_left_menu;
    private static final ResourceLocation AETHER_BARS_LOCATION;
    private static boolean shouldAddButton;
    private static boolean generateTrivia;
    private static Screen lastScreen;
    private static boolean alignMenuLeft;

    public static void drawSentryBackground(Screen screen) {
        if (screen instanceof TitleScreen) {
            if (OLD_BACKGROUND_LOCATION == null) {
                OLD_BACKGROUND_LOCATION = GuiComponent.f_93096_;
            }
            if (OLD_OPTIONS_BACKGROUND == null) {
                OLD_OPTIONS_BACKGROUND = RealmsPlayerScreenAccessor.aether$getOptionsBackground();
            }
            if (OLD_LIGHT_DIRT_BACKGROUND == null) {
                OLD_LIGHT_DIRT_BACKGROUND = GuiComponent.f_273856_;
            }
            if (OLD_HEADER_SEPERATOR == null) {
                OLD_HEADER_SEPERATOR = CreateWorldScreen.f_273823_;
            }
            if (OLD_FOOTER_SEPERATOR == null) {
                OLD_FOOTER_SEPERATOR = CreateWorldScreen.f_273875_;
            }
            if (OLD_TEXTURE_LOCATION == null) {
                OLD_TEXTURE_LOCATION = TabButtonAccessor.getTextureLocation();
            }
            GuiComponentAccessor.aether$setBackgroundLocation((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? BACKGROUND_LOCATION : OLD_BACKGROUND_LOCATION);
            RealmsPlayerScreenAccessor.aether$setOptionsBackground((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? BACKGROUND_LOCATION : OLD_OPTIONS_BACKGROUND);
            GuiComponentAccessor.aether$setLightDirtBackground((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? LIGHT_DIRT_BACKGROUND : OLD_LIGHT_DIRT_BACKGROUND);
            CreateWorldScreenAccessor.setHeaderSeparator((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? HEADER_SEPERATOR : OLD_HEADER_SEPERATOR);
            CreateWorldScreenAccessor.setFooterSeparator((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? FOOTER_SEPERATOR : OLD_FOOTER_SEPERATOR);
            TabButtonAccessor.setTextureLocation((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? TEXTURE_LOCATION : OLD_TEXTURE_LOCATION);
        }
    }

    public static void setupMenus(TitleScreen screen) {
        if (aether_menu == null) {
            aether_menu = new AetherTitleScreen();
        }
        if (default_left_menu == null) {
            default_left_menu = new VanillaLeftTitleScreen();
        }
        if (default_menu == null) {
            default_menu = screen;
        }
    }

    public static void setupWorldPreview(Screen screen) {
        if (screen instanceof TitleScreen && ((Boolean)AetherConfig.CLIENT.enable_world_preview.get()).booleanValue()) {
            WorldDisplayHelper.enableWorldPreview();
        }
    }

    public static VanillaLeftTitleScreen openLeftDefaultMenu(Screen screen) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            GuiHooks.setupMenus(titleScreen);
            if (GuiHooks.displayAlignedLeftVanillaMenu()) {
                return default_left_menu;
            }
        }
        return null;
    }

    public static AetherTitleScreen openAetherMenu(Screen screen) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            GuiHooks.setupMenus(titleScreen);
            if (((Boolean)AetherConfig.CLIENT.enable_aether_menu.get()).booleanValue()) {
                return aether_menu;
            }
        }
        return null;
    }

    public static void setupSplash(Screen screen) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)titleScreen;
            TitleScreenAccessor defaultMenuAccessor = (TitleScreenAccessor)default_menu;
            if (defaultMenuAccessor.aether$getSplash() != null) {
                titleScreenAccessor.aether$setSplash(defaultMenuAccessor.aether$getSplash());
            } else {
                defaultMenuAccessor.aether$setSplash(titleScreenAccessor.aether$getSplash());
            }
        }
    }

    public static Button setupToggleWorldButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(screen.f_96543_ - 24, 4, 20, 20, (Component)Component.m_237115_((String)"gui.aether.menu.button.world_preview"), pressed -> {
                AetherConfig.CLIENT.enable_world_preview.set((Object)((Boolean)AetherConfig.CLIENT.enable_world_preview.get() == false ? 1 : 0));
                AetherConfig.CLIENT.enable_world_preview.save();
                WorldDisplayHelper.toggleWorldPreview((Boolean)AetherConfig.CLIENT.enable_world_preview.get());
            });
            dynamicMenuButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.aether.menu.preview")));
            dynamicMenuButton.setDisplayConfigs(AetherConfig.CLIENT.enable_world_preview_button);
            return dynamicMenuButton;
        }
        return null;
    }

    public static Button setupMenuSwitchButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(screen.f_96543_ - 24, 4, 20, 20, (Component)Component.m_237115_((String)"gui.aether.menu.button.theme"), pressed -> {
                AetherConfig.CLIENT.enable_aether_menu.set((Object)((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() == false ? 1 : 0));
                AetherConfig.CLIENT.enable_aether_menu.save();
                Minecraft.m_91087_().m_91152_((Screen)GuiHooks.getMenu());
                Minecraft.m_91087_().m_91397_().m_120186_();
                AetherMusicManager.stopPlaying();
            });
            dynamicMenuButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)((Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? "gui.aether.menu.minecraft" : "gui.aether.menu.aether"))));
            dynamicMenuButton.setOffsetConfigs(AetherConfig.CLIENT.enable_world_preview_button);
            dynamicMenuButton.setDisplayConfigs(AetherConfig.CLIENT.enable_aether_menu_button);
            return dynamicMenuButton;
        }
        return null;
    }

    public static Button setupQuickLoadButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(screen.f_96543_ - 24, 4, 20, 20, (Component)Component.m_237115_((String)"gui.aether.menu.button.quick_load"), pressed -> {
                WorldDisplayHelper.quickLoad();
                Minecraft.m_91087_().m_91397_().m_120186_();
                AetherMusicManager.stopPlaying();
            });
            dynamicMenuButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.aether.menu.load")));
            dynamicMenuButton.setOffsetConfigs(AetherConfig.CLIENT.enable_world_preview_button, AetherConfig.CLIENT.enable_aether_menu_button);
            dynamicMenuButton.setDisplayConfigs(AetherConfig.CLIENT.enable_world_preview, AetherConfig.CLIENT.enable_quick_load_button);
            return dynamicMenuButton;
        }
        return null;
    }

    public static void setSplashText(TitleScreen screen) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 7 && calendar.get(5) == 22) {
            TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)screen;
            titleScreenAccessor.aether$setSplash("Happy anniversary to the Aether!");
        }
    }

    public static TitleScreen getMenu() {
        if (((Boolean)AetherConfig.CLIENT.enable_aether_menu.get()).booleanValue()) {
            GuiHooks.aether_menu.f_96714_ = true;
            GuiHooks.aether_menu.f_96715_ = 0L;
            return aether_menu;
        }
        if (GuiHooks.displayAlignedLeftVanillaMenu()) {
            GuiHooks.default_left_menu.f_96714_ = true;
            GuiHooks.default_left_menu.f_96715_ = 0L;
            return default_left_menu;
        }
        TitleScreenAccessor defaultMenuAccessor = (TitleScreenAccessor)default_menu;
        defaultMenuAccessor.aether$setFading(true);
        defaultMenuAccessor.aether$setFadeInStart(0L);
        return default_menu;
    }

    public static boolean displayAlignedLeftVanillaMenu() {
        return (Boolean)AetherConfig.CLIENT.menu_type_toggles_alignment.get() != false && (Boolean)AetherConfig.CLIENT.enable_world_preview.get() != false || (Boolean)AetherConfig.CLIENT.align_vanilla_menu_elements_left.get() != false;
    }

    public static AccessoryButton setupAccessoryButtonWithinInventories(Screen screen, Tuple<Integer, Integer> offsets) {
        if (screen instanceof InventoryScreen || screen instanceof CuriosScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen inventoryScreen = (AbstractContainerScreen)screen;
            return new AccessoryButton(inventoryScreen, inventoryScreen.getGuiLeft() + (Integer)offsets.m_14418_(), inventoryScreen.getGuiTop() + (Integer)offsets.m_14419_(), AccessoriesScreen.ACCESSORIES_BUTTON);
        }
        return null;
    }

    public static AccessoryButton setupAccessoryButtonWithinAccessoryMenu(Screen screen, Tuple<Integer, Integer> offsets) {
        if (screen instanceof AccessoriesScreen) {
            AccessoriesScreen accessoriesScreen = (AccessoriesScreen)screen;
            if (shouldAddButton) {
                return new AccessoryButton((AbstractContainerScreen<?>)accessoriesScreen, accessoriesScreen.getGuiLeft() + (Integer)offsets.m_14418_(), accessoriesScreen.getGuiTop() + (Integer)offsets.m_14419_(), AccessoriesScreen.ACCESSORIES_BUTTON);
            }
            shouldAddButton = true;
        }
        return null;
    }

    public static void setMenuAlignment() {
        alignMenuLeft = GuiHooks.displayAlignedLeftVanillaMenu();
    }

    public static void drawTrivia(Screen screen, PoseStack poseStack) {
        if (screen instanceof TitleScreen) {
            if (generateTrivia && Aether.TRIVIA_READER.getTrivia().isEmpty()) {
                Aether.TRIVIA_READER.generateTriviaList();
                generateTrivia = false;
            }
        } else if (screen instanceof LevelLoadingScreen && generateTrivia && Aether.TRIVIA_READER.getTrivia().isEmpty()) {
            Aether.TRIVIA_READER.generateTriviaList();
            generateTrivia = false;
        }
        if (screen instanceof GenericDirtMessageScreen || screen instanceof LevelLoadingScreen || screen instanceof ReceivingLevelScreen) {
            Component triviaLine = Aether.TRIVIA_READER.getTriviaLine();
            if (triviaLine != null && ((Boolean)AetherConfig.CLIENT.enable_trivia.get()).booleanValue()) {
                Font font = Minecraft.m_91087_().f_91062_;
                int y = screen.f_96544_ - 7 - font.m_239133_((FormattedText)triviaLine, screen.f_96543_);
                for (FormattedCharSequence sequence : font.m_92923_((FormattedText)triviaLine, screen.f_96543_)) {
                    Screen.m_168749_((PoseStack)poseStack, (Font)font, (FormattedCharSequence)sequence, (int)(screen.f_96543_ / 2), (int)y, (int)0xFFFF99);
                    y += 9;
                }
            }
            if (screen != lastScreen && !Aether.TRIVIA_READER.getTrivia().isEmpty()) {
                Aether.TRIVIA_READER.randomizeTriviaIndex();
            }
        }
        lastScreen = screen;
    }

    public static void drawAetherTravelMessage(Screen screen, PoseStack poseStack) {
        if (screen instanceof ReceivingLevelScreen || screen instanceof ProgressScreen) {
            if (Minecraft.m_91087_().f_91074_ != null && DimensionHooks.displayAetherTravel) {
                if (DimensionHooks.playerLeavingAether) {
                    Screen.m_93215_((PoseStack)poseStack, (Font)screen.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"gui.aether.descending"), (int)(screen.f_96543_ / 2), (int)50, (int)0xFFFFFF);
                } else {
                    Screen.m_93215_((PoseStack)poseStack, (Font)screen.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"gui.aether.ascending"), (int)(screen.f_96543_ / 2), (int)50, (int)0xFFFFFF);
                }
            }
        } else {
            DimensionHooks.displayAetherTravel = false;
        }
    }

    public static void changeMenuAlignment(Screen screen, Minecraft minecraft) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            if (alignMenuLeft != GuiHooks.displayAlignedLeftVanillaMenu()) {
                alignMenuLeft = GuiHooks.displayAlignedLeftVanillaMenu();
                if (alignMenuLeft) {
                    if (titleScreen != default_left_menu) {
                        minecraft.m_91346_((Screen)default_left_menu);
                    }
                } else {
                    AetherTitleScreen defaultMenu;
                    AetherTitleScreen aetherTitleScreen = defaultMenu = (Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false ? aether_menu : default_menu;
                    if (titleScreen != defaultMenu) {
                        minecraft.m_91346_((Screen)defaultMenu);
                    }
                }
            }
        }
    }

    public static void closeContainerMenu(int key, int action) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
            if (!(abstractContainerScreen.f_96546_ || AetherKeys.OPEN_ACCESSORY_INVENTORY.getKey().m_84873_() != key || action != 1 && action != 2)) {
                abstractContainerScreen.m_7379_();
            }
        }
    }

    public static void openAccessoryMenu() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.m_91265_() == null && (minecraft.f_91080_ == null || minecraft.f_91080_.f_96546_) && AetherKeys.OPEN_ACCESSORY_INVENTORY.m_90859_()) {
            AetherPacketHandler.sendToServer(new OpenAccessoriesPacket(ItemStack.f_41583_));
            shouldAddButton = false;
        }
    }

    public static void tickMenuWhenPaused(Minecraft minecraft) {
        if (minecraft != null && minecraft.f_91073_ != null && minecraft.f_91074_ != null && WorldDisplayHelper.loadedLevel != null && WorldDisplayHelper.loadedSummary != null && minecraft.m_91104_()) {
            minecraft.f_91063_.m_109148_();
            minecraft.f_91060_.m_109823_();
            AetherMusicManager.tick();
            minecraft.m_91397_().m_120183_();
            minecraft.m_91106_().m_120389_(false);
            minecraft.f_91073_.m_104784_(minecraft.f_91074_.m_146903_(), minecraft.f_91074_.m_146904_(), minecraft.f_91074_.m_146907_());
            Minecraft.m_91087_().f_91061_.m_107388_();
        }
    }

    public static void drawBossHealthBar(PoseStack poseStack, int x, int y, LerpingBossEvent bossEvent) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AETHER_BARS_LOCATION);
        GuiHooks.drawBar(poseStack, x + 2, y + 2, (BossEvent)bossEvent);
        Component component = bossEvent.m_18861_();
        int nameLength = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
        int nameX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - nameLength / 2;
        int nameY = y - 9;
        Minecraft.m_91087_().f_91062_.m_92763_(poseStack, component, (float)nameX, (float)nameY, 0xFFFFFF);
    }

    public static void drawBar(PoseStack pPoseStack, int pX, int pY, BossEvent pBossEvent) {
        GuiComponent.m_93143_((PoseStack)pPoseStack, (int)(pX -= 37), (int)pY, (int)-90, (float)0.0f, (float)16.0f, (int)256, (int)16, (int)256, (int)256);
        int health = (int)(pBossEvent.m_142717_() * 256.0f);
        if (health > 0) {
            GuiComponent.m_93143_((PoseStack)pPoseStack, (int)pX, (int)pY, (int)-90, (float)0.0f, (float)0.0f, (int)health, (int)16, (int)256, (int)256);
        }
    }

    public static boolean hideOverlays() {
        return (Boolean)AetherConfig.CLIENT.enable_world_preview.get() != false && WorldDisplayHelper.loadedLevel != null && WorldDisplayHelper.loadedSummary != null;
    }

    static {
        LIGHT_DIRT_BACKGROUND = new ResourceLocation("aether", "textures/gui/light_dirt_background.png");
        HEADER_SEPERATOR = new ResourceLocation("aether", "textures/gui/header_separator.png");
        FOOTER_SEPERATOR = new ResourceLocation("aether", "textures/gui/footer_separator.png");
        TEXTURE_LOCATION = new ResourceLocation("aether", "textures/gui/tab_button.png");
        aether_menu = null;
        default_menu = null;
        default_left_menu = null;
        AETHER_BARS_LOCATION = new ResourceLocation("aether", "textures/gui/boss_bar.png");
        shouldAddButton = true;
        generateTrivia = true;
        lastScreen = null;
        alignMenuLeft = false;
    }
}

