/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.client.renderer.level.AetherSkyRenderEffects;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor;
import com.aetherteam.aether.util.EquipmentUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class DimensionClientHooks {
    public static Float renderNearFog(Camera camera, FogRenderer.FogMode mode, float far) {
        ClientLevel clientLevel;
        Level level = camera.m_90592_().f_19853_;
        if (level instanceof ClientLevel && (clientLevel = (ClientLevel)level).m_104583_() instanceof AetherSkyRenderEffects) {
            FogType fluidState = camera.m_167685_();
            if (mode == FogRenderer.FogMode.FOG_TERRAIN && fluidState == FogType.NONE) {
                return Float.valueOf(far / 2.0f);
            }
        }
        return null;
    }

    public static Float reduceLavaFog(Camera camera, float nearDistance) {
        FogType fluidState;
        LivingEntity livingEntity;
        Entity entity;
        if (camera.m_90592_().f_19853_ instanceof ClientLevel && (entity = camera.m_90592_()) instanceof LivingEntity && EquipmentUtil.hasFullPhoenixSet(livingEntity = (LivingEntity)entity) && (fluidState = camera.m_167685_()) == FogType.LAVA) {
            return Float.valueOf(nearDistance * 5.0f);
        }
        return null;
    }

    public static Triple<Float, Float, Float> renderFogColors(Camera camera, float red, float green, float blue) {
        ClientLevel clientLevel;
        Level level = camera.m_90592_().f_19853_;
        if (level instanceof ClientLevel && (clientLevel = (ClientLevel)level).m_104583_() instanceof AetherSkyRenderEffects) {
            ClientLevel.ClientLevelData worldInfo = clientLevel.m_6106_();
            double d0 = (camera.m_90583_().f_82480_ - (double)clientLevel.m_141937_()) * (double)worldInfo.m_205519_();
            FogType fluidState = camera.m_167685_();
            if (d0 < 1.0 && fluidState != FogType.LAVA) {
                if (d0 < 0.0) {
                    d0 = 0.0;
                }
                if ((d0 *= d0) != 0.0) {
                    return Triple.of((Object)Float.valueOf((float)((double)red / d0)), (Object)Float.valueOf((float)((double)green / d0)), (Object)Float.valueOf((float)((double)blue / d0)));
                }
            }
        }
        return Triple.of(null, null, null);
    }

    public static Triple<Float, Float, Float> adjustWeatherFogColors(Camera camera, float red, float green, float blue) {
        FogType fluidState;
        ClientLevel clientLevel;
        Level level = camera.m_90592_().f_19853_;
        if (level instanceof ClientLevel && (clientLevel = (ClientLevel)level).m_104583_() instanceof AetherSkyRenderEffects && (fluidState = camera.m_167685_()) == FogType.NONE) {
            Vec3 defaultSky = Vec3.m_82501_((int)((Biome)clientLevel.m_204166_(camera.m_90588_()).get()).getModifiedSpecialEffects().m_47967_());
            if ((double)clientLevel.f_46438_ > 0.0) {
                float f14 = 1.0f + clientLevel.f_46438_ * 0.8f;
                float f17 = 1.0f + clientLevel.f_46438_ * 0.56f;
                red *= f14;
                green *= f14;
                blue *= f17;
            }
            if ((double)clientLevel.f_46440_ > 0.0) {
                float f18 = 1.0f + clientLevel.f_46440_ * 0.66f;
                float f19 = 1.0f + clientLevel.f_46440_ * 0.76f;
                red *= f18;
                green *= f18;
                blue *= f19;
            }
            red = (float)Math.min((double)red, defaultSky.f_82479_);
            green = (float)Math.min((double)green, defaultSky.f_82480_);
            blue = (float)Math.min((double)blue, defaultSky.f_82481_);
            return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
        }
        return Triple.of(null, null, null);
    }

    public static void tickTime() {
        LevelAccessor levelAccessor;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && !Minecraft.m_91087_().m_91104_() && level.m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_()) && (levelAccessor = (LevelAccessor)level).aether$getLevelData().m_5470_().m_46207_(GameRules.f_46140_)) {
            AetherTime.get((Level)level).ifPresent(cap -> level.m_104746_(cap.tickTime((Level)level) - 1L));
        }
    }
}

