/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.WorldDisplayHelper;
import com.aetherteam.aether.client.gui.screen.menu.AetherTitleScreen;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class AetherMusicManager {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final MusicManager musicManager = Minecraft.m_91087_().m_91397_();
    @Nullable
    private static SoundInstance currentMusic;
    private static int nextSongDelay;

    public static void tick() {
        Music music = AetherMusicManager.getSituationalMusic();
        if (music != null) {
            if (currentMusic != null) {
                if (!((SoundEvent)music.m_263193_().get()).m_11660_().equals((Object)currentMusic.m_7904_()) && music.m_11642_()) {
                    minecraft.m_91106_().m_120399_(currentMusic);
                    nextSongDelay = Mth.m_216271_((RandomSource)random, (int)0, (int)(music.m_11636_() / 2));
                }
                if (!minecraft.m_91106_().m_120403_(currentMusic)) {
                    currentMusic = null;
                    nextSongDelay = Math.min(nextSongDelay, Mth.m_216271_((RandomSource)random, (int)music.m_11636_(), (int)music.m_11639_()));
                }
            }
            nextSongDelay = Math.min(nextSongDelay, music.m_11639_());
            if (currentMusic == null && nextSongDelay-- <= 0) {
                AetherMusicManager.startPlaying(music);
            }
        } else {
            currentMusic = null;
            if (nextSongDelay-- <= 0) {
                nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.m_216271_((RandomSource)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get())));
            }
        }
    }

    public static void startPlaying(Music pSelector) {
        musicManager.m_120186_();
        currentMusic = SimpleSoundInstance.m_119745_((SoundEvent)((SoundEvent)pSelector.m_263193_().get()));
        if (currentMusic.m_5891_() != SoundManager.f_120344_) {
            minecraft.m_91106_().m_120367_(currentMusic);
        }
        nextSongDelay = Integer.MAX_VALUE;
    }

    public static void stopPlaying() {
        if (currentMusic != null) {
            minecraft.m_91106_().m_120399_(currentMusic);
            currentMusic = null;
        }
        nextSongDelay += 100;
    }

    @Nullable
    public static SoundInstance getCurrentMusic() {
        return currentMusic;
    }

    public static Music getSituationalMusic() {
        if (!(AetherMusicManager.minecraft.f_91080_ instanceof WinScreen)) {
            if (AetherMusicManager.isAetherWorldPreviewEnabled()) {
                return AetherTitleScreen.MENU;
            }
            if (AetherMusicManager.isVanillaWorldPreviewEnabled()) {
                return Musics.f_11645_;
            }
            if (AetherMusicManager.minecraft.f_91074_ != null) {
                Holder holder = AetherMusicManager.minecraft.f_91074_.f_19853_.m_204166_(AetherMusicManager.minecraft.f_91074_.m_20183_());
                if (AetherMusicManager.isCreative((Holder<Biome>)holder, (Player)AetherMusicManager.minecraft.f_91074_)) {
                    return ((Biome)holder.m_203334_()).m_47566_().orElse(Musics.f_11651_);
                }
            } else if (AetherMusicManager.isAetherMenuEnabled()) {
                return AetherTitleScreen.MENU;
            }
        }
        return null;
    }

    public static boolean isAetherMenuEnabled() {
        return (Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false && (Boolean)AetherConfig.CLIENT.disable_aether_menu_music.get() == false;
    }

    public static boolean isAetherWorldPreviewEnabled() {
        return (Boolean)AetherConfig.CLIENT.enable_aether_menu.get() != false && AetherMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_aether_world_preview_menu_music.get() == false;
    }

    public static boolean isVanillaWorldPreviewEnabled() {
        return AetherMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_vanilla_world_preview_menu_music.get() == false;
    }

    public static boolean isWorldPreviewEnabled() {
        return AetherMusicManager.minecraft.f_91074_ != null && (Boolean)AetherConfig.CLIENT.enable_world_preview.get() != false && WorldDisplayHelper.loadedLevel != null && WorldDisplayHelper.loadedSummary != null;
    }

    public static boolean isCreative(Holder<Biome> holder, Player player) {
        return player.f_19853_.m_46472_() != Level.f_46430_ && player.f_19853_.m_46472_() != Level.f_46429_ && holder.m_203656_(AetherTags.Biomes.AETHER_MUSIC) && !musicManager.m_120187_(Musics.f_11650_) && (!player.m_5842_() || !holder.m_203656_(BiomeTags.f_215801_)) && player.m_150110_().f_35937_ && player.m_150110_().f_35936_;
    }

    static {
        nextSongDelay = 100;
    }
}

