/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.api.CustomizationsOptions;
import com.aetherteam.aether.client.AetherAtlases;
import com.aetherteam.aether.client.gui.screen.SunAltarScreen;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.client.gui.screen.inventory.AltarScreen;
import com.aetherteam.aether.client.gui.screen.inventory.FreezerScreen;
import com.aetherteam.aether.client.gui.screen.inventory.IncubatorScreen;
import com.aetherteam.aether.client.gui.screen.inventory.LoreBookScreen;
import com.aetherteam.aether.client.renderer.AetherRenderers;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.aetherteam.aether.item.AetherItems;
import com.google.common.reflect.Reflection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AetherClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        Reflection.initialize((Class[])new Class[]{CustomizationsOptions.class});
        AetherRenderers.registerCuriosRenderers();
        event.enqueueWork(() -> {
            AetherAtlases.registerTreasureChestAtlases();
            AetherAtlases.registerWoodTypeAtlases();
            AetherClient.registerGuiFactories();
            AetherClient.registerItemModelProperties();
        });
        AetherClient.registerLoreOverrides();
    }

    public static void registerGuiFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)AetherMenuTypes.ACCESSORIES.get()), AccessoriesScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)AetherMenuTypes.BOOK_OF_LORE.get()), LoreBookScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)AetherMenuTypes.ALTAR.get()), AltarScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)AetherMenuTypes.FREEZER.get()), FreezerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)AetherMenuTypes.INCUBATOR.get()), IncubatorScreen::new);
    }

    public static void registerItemModelProperties() {
        ItemProperties.register((Item)((Item)AetherItems.PHOENIX_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living, i) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)AetherItems.PHOENIX_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, living, i) -> {
            if (living == null) {
                return 0.0f;
            }
            return living.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)((Item)AetherItems.CANDY_CANE_SWORD.get()), (ResourceLocation)new ResourceLocation("aether", "named"), (stack, world, living, i) -> stack.m_41786_().getString().equalsIgnoreCase("green candy cane sword") ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (ResourceLocation)new ResourceLocation("aether", "named"), (stack, world, living, i) -> stack.m_41786_().getString().equalsIgnoreCase("hammer of jeb") ? 1.0f : 0.0f);
    }

    public static void registerLoreOverrides() {
        LoreBookMenu.addLoreEntryOverride(stack -> stack.m_41786_().getString().equalsIgnoreCase("hammer of jeb"), "lore.item.aether.hammer_of_jeb");
    }

    @SubscribeEvent
    public static void registerSpectatorShaders(RegisterEntitySpectatorShadersEvent event) {
        event.register((EntityType)AetherEntityTypes.SUN_SPIRIT.get(), new ResourceLocation("aether", "shaders/post/sun_spirit.json"));
    }

    public static void setToSunAltarScreen(Component name) {
        Minecraft.m_91087_().m_91152_((Screen)new SunAltarScreen(name));
    }
}

