/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.time;

import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.EternalDayPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class AetherTimeCapability
implements AetherTime {
    private final Level level;
    private long dayTime = 18000L;
    private boolean isEternalDay = true;

    public AetherTimeCapability(Level level) {
        this.level = level;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("DayTime", this.level.m_46468_());
        tag.m_128379_("EternalDay", this.getEternalDay());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("DayTime")) {
            this.setDayTime(tag.m_128454_("DayTime"));
        }
        if (tag.m_128441_("EternalDay")) {
            this.setEternalDay(tag.m_128471_("EternalDay"));
        }
    }

    @Override
    public long tickTime(Level level) {
        long dayTime = level.m_46468_();
        if (this.getEternalDay()) {
            if (dayTime != 18000L) {
                long tempTime = dayTime % 72000L;
                if (tempTime > 54000L) {
                    tempTime -= 72000L;
                }
                long target = (long)Mth.m_14036_((float)(18000L - tempTime), (float)-10.0f, (float)10.0f);
                dayTime += target;
            }
        } else {
            ++dayTime;
        }
        return dayTime;
    }

    @Override
    public void updateEternalDay() {
        AetherPacketHandler.sendToDimension(new EternalDayPacket(this.isEternalDay), (ResourceKey<Level>)this.level.m_46472_());
    }

    @Override
    public void updateEternalDay(ServerPlayer player) {
        AetherPacketHandler.sendToPlayer(new EternalDayPacket(this.isEternalDay), player);
    }

    @Override
    public void setDayTime(long time) {
        this.dayTime = time;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    @Override
    public void setEternalDay(boolean isEternalDay) {
        this.isEternalDay = isEternalDay;
    }

    @Override
    public boolean getEternalDay() {
        return this.isEternalDay;
    }
}

