/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.rankings;

import com.aetherteam.aether.api.CustomizationsOptions;
import com.aetherteam.aether.capability.CapabilitySyncing;
import com.aetherteam.aether.capability.rankings.AetherRankings;
import com.aetherteam.aether.network.AetherPacket;
import com.aetherteam.aether.network.packet.AetherRankingsSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Triple;

public class AetherRankingsCapability
extends CapabilitySyncing
implements AetherRankings {
    private final Player player;
    private boolean haloEnabled = true;
    private String haloColor = null;
    private boolean developerGlowEnabled = false;
    private String developerGlowColor = null;

    public AetherRankingsCapability(Player player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("RenderHalo", this.isHaloEnabled());
        if (this.getHaloHex() != null) {
            tag.m_128359_("HaloColor", this.getHaloHex());
        }
        tag.m_128379_("RenderDeveloperGlow", this.isDeveloperGlowEnabled());
        if (this.getDeveloperGlowHex() != null) {
            tag.m_128359_("DeveloperGlowColor", this.getDeveloperGlowHex());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("RenderHalo")) {
            this.setIsHaloEnabled(tag.m_128471_("RenderHalo"));
        }
        if (tag.m_128441_("HaloColor")) {
            this.setHaloColor(tag.m_128461_("HaloColor"));
        }
        if (tag.m_128441_("RenderDeveloperGlow")) {
            this.setIsDeveloperGlowEnabled(tag.m_128471_("RenderDeveloperGlow"));
        }
        if (tag.m_128441_("DeveloperGlowColor")) {
            this.setDeveloperGlowColor(tag.m_128461_("DeveloperGlowColor"));
        }
    }

    @Override
    public CompoundTag serializeSynchableNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("RenderHalo_Syncing", this.isHaloEnabled());
        if (this.getHaloHex() != null) {
            tag.m_128359_("HaloColor_Syncing", this.getHaloHex());
        }
        tag.m_128379_("RenderDeveloperGlow_Syncing", this.isDeveloperGlowEnabled());
        if (this.getDeveloperGlowHex() != null) {
            tag.m_128359_("DeveloperGlowColor_Syncing", this.getDeveloperGlowHex());
        }
        return tag;
    }

    @Override
    public void deserializeSynchableNBT(CompoundTag tag) {
        if (tag.m_128441_("RenderHalo_Syncing")) {
            this.setIsHaloEnabled(tag.m_128471_("RenderHalo_Syncing"));
        }
        if (tag.m_128441_("HaloColor_Syncing")) {
            this.setHaloColor(tag.m_128461_("HaloColor_Syncing"));
        }
        if (tag.m_128441_("RenderDeveloperGlow_Syncing")) {
            this.setIsDeveloperGlowEnabled(tag.m_128471_("RenderDeveloperGlow_Syncing"));
        }
        if (tag.m_128441_("DeveloperGlowColor_Syncing")) {
            this.setDeveloperGlowColor(tag.m_128461_("DeveloperGlowColor_Syncing"));
        }
    }

    @Override
    public void copyFrom(AetherRankings other) {
        this.setIsHaloEnabled(other.isHaloEnabled());
        this.setHaloColor(other.getHaloHex());
        this.setIsDeveloperGlowEnabled(other.isDeveloperGlowEnabled());
        this.setDeveloperGlowColor(other.getDeveloperGlowHex());
    }

    @Override
    public void onUpdate() {
        this.updateSyncableNBTFromServer(this.getPlayer().m_9236_());
        if (this.getPlayer().f_19853_.m_5776_()) {
            CustomizationsOptions.INSTANCE.sync();
        }
    }

    @Override
    public void setIsHaloEnabled(boolean renderHalo) {
        this.markDirty(true);
        this.haloEnabled = renderHalo;
        this.updateSyncableNBTFromClient(this.getPlayer().f_19853_);
    }

    @Override
    public boolean isHaloEnabled() {
        return this.haloEnabled;
    }

    @Override
    public void setHaloColor(String color) {
        this.markDirty(true);
        this.haloColor = color;
        this.updateSyncableNBTFromClient(this.getPlayer().f_19853_);
    }

    @Override
    public Triple<Float, Float, Float> getHaloColor() {
        return this.getColor(this.haloColor);
    }

    @Override
    public String getHaloHex() {
        return this.haloColor;
    }

    @Override
    public void setIsDeveloperGlowEnabled(boolean renderDeveloperGlow) {
        this.markDirty(true);
        this.developerGlowEnabled = renderDeveloperGlow;
        this.updateSyncableNBTFromClient(this.getPlayer().f_19853_);
    }

    @Override
    public boolean isDeveloperGlowEnabled() {
        return this.developerGlowEnabled;
    }

    @Override
    public void setDeveloperGlowColor(String color) {
        this.markDirty(true);
        this.developerGlowColor = color;
        this.updateSyncableNBTFromClient(this.getPlayer().f_19853_);
    }

    @Override
    public Triple<Float, Float, Float> getDeveloperGlowColor() {
        return this.getColor(this.developerGlowColor);
    }

    @Override
    public String getDeveloperGlowHex() {
        return this.developerGlowColor;
    }

    @Override
    public AetherPacket getSyncPacket(CompoundTag tag) {
        return new AetherRankingsSyncPacket(this.getPlayer().m_19879_(), tag);
    }

    private Triple<Float, Float, Float> getColor(String hex) {
        try {
            int decimal = Integer.parseInt(hex, 16);
            int r = (decimal & 0xFF0000) >> 16;
            int g = (decimal & 0xFF00) >> 8;
            int b = decimal & 0xFF;
            return Triple.of((Object)Float.valueOf((float)r / 255.0f), (Object)Float.valueOf((float)g / 255.0f), (Object)Float.valueOf((float)b / 255.0f));
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }
}

