/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.player;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.capability.CapabilitySyncing;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.miscellaneous.CloudMinion;
import com.aetherteam.aether.entity.miscellaneous.Parachute;
import com.aetherteam.aether.entity.passive.Aerbunny;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.ParachuteItem;
import com.aetherteam.aether.network.AetherPacket;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.aether.network.packet.client.CloudMinionPacket;
import com.aetherteam.aether.network.packet.client.RemountAerbunnyPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AetherPlayerCapability
extends CapabilitySyncing
implements AetherPlayer {
    private final Player player;
    private static final UUID LIFE_SHARD_HEALTH_ID = UUID.fromString("E11710C8-4247-4CB6-B3B5-729CB34CFC1A");
    private boolean canGetPortal = true;
    public boolean isInAetherPortal = false;
    public int aetherPortalTimer = 0;
    public float prevPortalAnimTime;
    public float portalAnimTime = 0.0f;
    private boolean isHitting;
    private boolean isMoving;
    private boolean isJumping;
    private boolean isGravititeJumpActive;
    private boolean seenSunSpiritDialogue;
    private int goldenDartCount;
    private int poisonDartCount;
    private int enchantedDartCount;
    private int removeGoldenDartTime;
    private int removePoisonDartTime;
    private int removeEnchantedDartTime;
    private int remedyMaximum;
    private int remedyTimer;
    private int impactedMaximum;
    private int impactedTimer;
    private boolean performVampireHealing;
    private Aerbunny mountedAerbunny;
    private CompoundTag mountedAerbunnyTag;
    private final List<CloudMinion> cloudMinions = new ArrayList<CloudMinion>(2);
    private float wingRotation;
    private int invisibilityAttackCooldown;
    private boolean attackedWithInvisibility;
    private boolean wearingInvisibilityCloak;
    private static final int FLIGHT_TIMER_MAX = 52;
    private static final float FLIGHT_MODIFIER_MAX = 15.0f;
    private int flightTimer;
    private float flightModifier = 1.0f;
    private double neptuneSubmergeLength;
    private double phoenixSubmergeLength;
    private static final int OBSIDIAN_TIMER_MAX = 20;
    private int obsidianConversionTime;
    private float savedHealth = 0.0f;
    private int lifeShards;

    public AetherPlayerCapability(Player player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("CanGetPortal", this.canGetPortal());
        tag.m_128350_("SavedHealth", this.getSavedHealth());
        tag.m_128405_("LifeShardCount", this.getLifeShardCount());
        tag.m_128379_("HasSeenSunSpirit", this.hasSeenSunSpiritDialogue());
        if (this.getMountedAerbunnyTag() != null) {
            tag.m_128365_("MountedAerbunnyTag", (Tag)this.getMountedAerbunnyTag());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("CanGetPortal")) {
            this.setCanGetPortal(tag.m_128471_("CanGetPortal"));
        }
        if (tag.m_128441_("SavedHealth")) {
            this.setSavedHealth(tag.m_128457_("SavedHealth"));
        }
        if (tag.m_128441_("LifeShardCount")) {
            this.setLifeShardCount(tag.m_128451_("LifeShardCount"));
        }
        if (tag.m_128441_("HasSeenSunSpirit")) {
            this.setSeenSunSpiritDialogue(tag.m_128471_("HasSeenSunSpirit"));
        }
        if (tag.m_128441_("MountedAerbunnyTag")) {
            this.setMountedAerbunnyTag(tag.m_128469_("MountedAerbunnyTag"));
        }
    }

    @Override
    public CompoundTag serializeSynchableNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("GravititeJump_Syncing", this.isGravititeJumpActive());
        tag.m_128405_("GoldenDartCount_Syncing", this.getGoldenDartCount());
        tag.m_128405_("PoisonDartCount_Syncing", this.getPoisonDartCount());
        tag.m_128405_("EnchantedDartCount_Syncing", this.getEnchantedDartCount());
        tag.m_128405_("FlightTimer_Syncing", this.getFlightTimer());
        tag.m_128350_("FlightModifier_Syncing", this.getFlightModifier());
        tag.m_128379_("AttackedWithInvisibility_Syncing", this.attackedWithInvisibility());
        tag.m_128379_("WearingInvisibilityCloak_Syncing", this.isWearingInvisibilityCloak());
        tag.m_128405_("LifeShardCount_Syncing", this.getLifeShardCount());
        return tag;
    }

    @Override
    public void deserializeSynchableNBT(CompoundTag tag) {
        if (tag.m_128441_("GravititeJump_Syncing")) {
            this.setGravititeJumpActive(tag.m_128471_("GravititeJump_Syncing"));
        }
        if (tag.m_128441_("GoldenDartCount_Syncing")) {
            this.setGoldenDartCount(tag.m_128451_("GoldenDartCount_Syncing"));
        }
        if (tag.m_128441_("PoisonDartCount_Syncing")) {
            this.setPoisonDartCount(tag.m_128451_("PoisonDartCount_Syncing"));
        }
        if (tag.m_128441_("EnchantedDartCount_Syncing")) {
            this.setEnchantedDartCount(tag.m_128451_("EnchantedDartCount_Syncing"));
        }
        if (tag.m_128441_("FlightTimer_Syncing")) {
            this.setFlightTimer(tag.m_128451_("FlightTimer_Syncing"));
        }
        if (tag.m_128441_("FlightModifier_Syncing")) {
            this.setFlightModifier(tag.m_128457_("FlightModifier_Syncing"));
        }
        if (tag.m_128441_("LifeShardCount_Syncing")) {
            this.setLifeShardCount(tag.m_128451_("LifeShardCount_Syncing"));
        }
        if (tag.m_128441_("AttackedWithInvisibility_Syncing")) {
            this.setAttackedWithInvisibility(tag.m_128471_("AttackedWithInvisibility_Syncing"));
        }
        if (tag.m_128441_("WearingInvisibilityCloak_Syncing")) {
            this.setWearingInvisibilityCloak(tag.m_128471_("WearingInvisibilityCloak_Syncing"));
        }
    }

    @Override
    public void onLogout() {
        this.removeAerbunny();
    }

    @Override
    public void onLogin() {
        this.handleGivePortal();
        this.remountAerbunny();
    }

    @Override
    public void copyFrom(AetherPlayer other, boolean isWasDeath) {
        if (!isWasDeath) {
            this.setRemedyMaximum(other.getRemedyMaximum());
            this.setRemedyTimer(other.getRemedyTimer());
            this.setProjectileImpactedMaximum(other.getProjectileImpactedMaximum());
            this.setProjectileImpactedTimer(other.getProjectileImpactedTimer());
        }
        this.setCanGetPortal(other.canGetPortal());
        this.setLifeShardCount(other.getLifeShardCount());
    }

    @Override
    public void onUpdate() {
        this.updateSyncableNBTFromServer(this.getPlayer().m_9236_());
        this.handleAetherPortal();
        this.activateParachute();
        this.handleRemoveDarts();
        this.tickDownRemedy();
        this.tickDownProjectileImpact();
        this.handleAttackCooldown();
        this.handleVampireHealing();
        this.checkToRemoveAerbunny();
        this.checkToRemoveCloudMinions();
        this.handleSavedHealth();
        this.handleLifeShardModifier();
    }

    private void handleGivePortal() {
        if (((Boolean)AetherConfig.COMMON.start_with_portal.get()).booleanValue()) {
            this.givePortalItem();
        } else {
            this.setCanGetPortal(false);
        }
    }

    private void handleAetherPortal() {
        if (this.player.f_19853_.f_46443_) {
            this.prevPortalAnimTime = this.portalAnimTime;
            Minecraft mc = Minecraft.m_91087_();
            if (this.isInAetherPortal) {
                if (mc.f_91080_ != null && !mc.f_91080_.m_7043_()) {
                    if (mc.f_91080_ instanceof AbstractContainerScreen) {
                        this.player.m_6915_();
                    }
                    mc.m_91152_(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    this.playPortalSound(mc);
                }
            }
        }
        if (this.isInAetherPortal) {
            ++this.aetherPortalTimer;
            if (this.player.f_19853_.f_46443_) {
                this.portalAnimTime += 0.0125f;
                if (this.portalAnimTime > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInAetherPortal = false;
        } else {
            if (this.player.f_19853_.f_46443_) {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.aetherPortalTimer > 0) {
                this.aetherPortalTimer -= 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playPortalSound(Minecraft mc) {
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)((SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRIGGER.get()), (float)(this.getPlayer().m_217043_().m_188501_() * 0.4f + 0.8f), (float)0.25f));
    }

    private void activateParachute() {
        Player player = this.getPlayer();
        Inventory inventory = this.getPlayer().m_150109_();
        Level level = player.f_19853_;
        if (!player.m_7500_() && !player.m_6144_() && !player.m_21255_() && !player.m_20159_() && player.m_20184_().m_7098_() < -1.5 && inventory.m_204075_(AetherTags.Items.DEPLOYABLE_PARACHUTES)) {
            for (ItemStack stack : inventory.f_35974_) {
                ParachuteItem parachuteItem;
                Parachute parachute;
                Item item = stack.m_41720_();
                if (!(item instanceof ParachuteItem) || (parachute = (Parachute)(parachuteItem = (ParachuteItem)item).getParachuteEntity().get().m_20615_(level)) == null) continue;
                parachute.m_6034_(player.m_20185_(), player.m_20186_() - 1.0, player.m_20189_());
                parachute.m_20256_(player.m_20184_());
                if (!level.f_46443_) {
                    level.m_7967_((Entity)parachute);
                    player.m_20329_((Entity)parachute);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                }
                parachute.spawnExplosionParticle();
                break;
            }
        }
    }

    private void handleRemoveDarts() {
        if (!this.getPlayer().f_19853_.m_5776_()) {
            if (this.getGoldenDartCount() > 0) {
                if (this.removeGoldenDartTime <= 0) {
                    this.removeGoldenDartTime = 20 * (30 - this.getGoldenDartCount());
                }
                --this.removeGoldenDartTime;
                if (this.removeGoldenDartTime <= 0) {
                    this.setGoldenDartCount(this.getGoldenDartCount() - 1);
                }
            }
            if (this.getPoisonDartCount() > 0) {
                if (this.removePoisonDartTime <= 0) {
                    this.removePoisonDartTime = 20 * (30 - this.getPoisonDartCount());
                }
                --this.removePoisonDartTime;
                if (this.removePoisonDartTime <= 0) {
                    this.setPoisonDartCount(this.getPoisonDartCount() - 1);
                }
            }
            if (this.getEnchantedDartCount() > 0) {
                if (this.removeEnchantedDartTime <= 0) {
                    this.removeEnchantedDartTime = 20 * (30 - this.getEnchantedDartCount());
                }
                --this.removeEnchantedDartTime;
                if (this.removeEnchantedDartTime <= 0) {
                    this.setEnchantedDartCount(this.getEnchantedDartCount() - 1);
                }
            }
        }
    }

    private void tickDownRemedy() {
        if (this.getPlayer().f_19853_.m_5776_()) {
            if (this.getRemedyTimer() > 0) {
                this.setRemedyTimer(this.getRemedyTimer() - 1);
            } else {
                this.setRemedyMaximum(0);
                this.setRemedyTimer(0);
            }
        }
    }

    private void tickDownProjectileImpact() {
        if (this.getPlayer().f_19853_.m_5776_()) {
            if (this.getProjectileImpactedTimer() > 0) {
                this.setProjectileImpactedTimer(this.getProjectileImpactedTimer() - 1);
            } else {
                this.setProjectileImpactedMaximum(0);
                this.setProjectileImpactedTimer(0);
            }
        }
    }

    private void handleAttackCooldown() {
        if (!this.getPlayer().m_9236_().m_5776_()) {
            if (this.attackedWithInvisibility()) {
                --this.invisibilityAttackCooldown;
                if (this.invisibilityAttackCooldown <= 0) {
                    this.setAttackedWithInvisibility(false);
                }
            } else {
                this.invisibilityAttackCooldown = (Integer)AetherConfig.SERVER.invisibility_visibility_time.get();
            }
        }
    }

    private void handleVampireHealing() {
        if (!this.getPlayer().m_9236_().m_5776_() && this.performVampireHealing()) {
            this.getPlayer().m_5634_(1.0f);
            this.setVampireHealing(false);
        }
    }

    private void checkToRemoveAerbunny() {
        if (!(this.getMountedAerbunny() == null || this.getMountedAerbunny().m_6084_() && this.getPlayer().m_6084_())) {
            this.setMountedAerbunny(null);
        }
    }

    private void removeAerbunny() {
        if (this.getMountedAerbunny() != null) {
            Aerbunny aerbunny = this.getMountedAerbunny();
            CompoundTag nbt = new CompoundTag();
            aerbunny.m_20223_(nbt);
            this.setMountedAerbunnyTag(nbt);
            aerbunny.m_8127_();
            aerbunny.m_142467_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    private void remountAerbunny() {
        if (this.getMountedAerbunnyTag() != null) {
            if (!this.getPlayer().f_19853_.m_5776_()) {
                Aerbunny aerbunny = new Aerbunny((EntityType<? extends Aerbunny>)((EntityType)AetherEntityTypes.AERBUNNY.get()), this.getPlayer().f_19853_);
                aerbunny.m_20258_(this.getMountedAerbunnyTag());
                this.getPlayer().f_19853_.m_7967_((Entity)aerbunny);
                aerbunny.m_20329_((Entity)this.getPlayer());
                this.setMountedAerbunny(aerbunny);
                Player player = this.getPlayer();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    AetherPacketHandler.sendToPlayer(new RemountAerbunnyPacket(this.getPlayer().m_19879_(), aerbunny.m_19879_()), serverPlayer);
                }
            }
            this.setMountedAerbunnyTag(null);
        }
    }

    private void checkToRemoveCloudMinions() {
        this.getCloudMinions().removeIf(cloudMinion -> !cloudMinion.m_6084_());
    }

    private void handleSavedHealth() {
        AttributeInstance health;
        if (this.getSavedHealth() > 0.0f && (health = this.getPlayer().m_21051_(Attributes.f_22276_)) != null && health.m_22109_(this.getLifeShardHealthAttributeModifier())) {
            if (this.getSavedHealth() >= this.getPlayer().m_21233_()) {
                this.getPlayer().m_21153_(this.getPlayer().m_21233_());
            } else {
                this.getPlayer().m_21153_(this.getSavedHealth());
            }
            this.setSavedHealth(0.0f);
        }
    }

    private void handleLifeShardModifier() {
        if (!this.getPlayer().m_9236_().m_5776_()) {
            AttributeInstance health = this.getPlayer().m_21051_(Attributes.f_22276_);
            AttributeModifier LIFE_SHARD_HEALTH = this.getLifeShardHealthAttributeModifier();
            if (health != null) {
                if (health.m_22109_(LIFE_SHARD_HEALTH)) {
                    health.m_22130_(LIFE_SHARD_HEALTH);
                }
                health.m_22118_(LIFE_SHARD_HEALTH);
            }
        }
    }

    @Override
    public void givePortalItem() {
        if (this.canGetPortal()) {
            this.getPlayer().m_36356_(new ItemStack((ItemLike)AetherItems.AETHER_PORTAL_FRAME.get()));
            this.setCanGetPortal(false);
        }
    }

    @Override
    public void setCanGetPortal(boolean canGetPortal) {
        this.canGetPortal = canGetPortal;
    }

    @Override
    public boolean canGetPortal() {
        return this.canGetPortal;
    }

    @Override
    public void setInPortal(boolean inPortal) {
        this.isInAetherPortal = inPortal;
    }

    @Override
    public boolean isInPortal() {
        return this.isInAetherPortal;
    }

    @Override
    public void addPortalTime(int time) {
        this.aetherPortalTimer += time;
    }

    @Override
    public void setPortalTimer(int timer) {
        this.aetherPortalTimer = timer;
    }

    @Override
    public int getPortalTimer() {
        return this.aetherPortalTimer;
    }

    @Override
    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    @Override
    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    @Override
    public void setHitting(boolean isHitting) {
        this.isHitting = isHitting;
    }

    @Override
    public boolean isHitting() {
        return this.isHitting;
    }

    @Override
    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setGravititeJumpActive(boolean isGravititeJumpActive) {
        this.markDirty(true);
        this.isGravititeJumpActive = isGravititeJumpActive;
    }

    @Override
    public boolean isGravititeJumpActive() {
        return this.isGravititeJumpActive;
    }

    @Override
    public void setSeenSunSpiritDialogue(boolean seenDialogue) {
        this.seenSunSpiritDialogue = seenDialogue;
    }

    @Override
    public boolean hasSeenSunSpiritDialogue() {
        return this.seenSunSpiritDialogue;
    }

    @Override
    public void setGoldenDartCount(int count) {
        this.markDirty(true);
        this.goldenDartCount = count;
    }

    @Override
    public int getGoldenDartCount() {
        return this.goldenDartCount;
    }

    @Override
    public void setPoisonDartCount(int count) {
        this.markDirty(true);
        this.poisonDartCount = count;
    }

    @Override
    public int getPoisonDartCount() {
        return this.poisonDartCount;
    }

    @Override
    public void setEnchantedDartCount(int count) {
        this.markDirty(true);
        this.enchantedDartCount = count;
    }

    @Override
    public int getEnchantedDartCount() {
        return this.enchantedDartCount;
    }

    @Override
    public void setRemedyMaximum(int remedyMaximum) {
        this.remedyMaximum = remedyMaximum;
    }

    @Override
    public int getRemedyMaximum() {
        return this.remedyMaximum;
    }

    @Override
    public void setRemedyTimer(int timer) {
        this.remedyTimer = timer;
    }

    @Override
    public int getRemedyTimer() {
        return this.remedyTimer;
    }

    @Override
    public void setProjectileImpactedMaximum(int projectileImpactedMaximum) {
        this.impactedMaximum = projectileImpactedMaximum;
    }

    @Override
    public int getProjectileImpactedMaximum() {
        return this.impactedMaximum;
    }

    @Override
    public void setProjectileImpactedTimer(int projectileImpactedTimer) {
        this.impactedTimer = projectileImpactedTimer;
    }

    @Override
    public int getProjectileImpactedTimer() {
        return this.impactedTimer;
    }

    @Override
    public void setVampireHealing(boolean performVampireHealing) {
        this.performVampireHealing = performVampireHealing;
    }

    @Override
    public boolean performVampireHealing() {
        return this.performVampireHealing;
    }

    @Override
    public void setMountedAerbunny(Aerbunny mountedAerbunny) {
        this.mountedAerbunny = mountedAerbunny;
    }

    @Override
    public Aerbunny getMountedAerbunny() {
        return this.mountedAerbunny;
    }

    @Override
    public void setMountedAerbunnyTag(CompoundTag mountedAerbunnyTag) {
        this.mountedAerbunnyTag = mountedAerbunnyTag;
    }

    @Override
    public CompoundTag getMountedAerbunnyTag() {
        return this.mountedAerbunnyTag;
    }

    @Override
    public void setCloudMinions(CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        this.sendCloudMinionPacket(cloudMinionRight, cloudMinionLeft);
        this.cloudMinions.add(0, cloudMinionRight);
        this.cloudMinions.add(1, cloudMinionLeft);
    }

    @Override
    public List<CloudMinion> getCloudMinions() {
        return this.cloudMinions;
    }

    @Override
    public void setWingRotation(float wingRotation) {
        this.wingRotation = wingRotation;
    }

    @Override
    public float getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setAttackedWithInvisibility(boolean attacked) {
        this.markDirty(true);
        this.attackedWithInvisibility = attacked;
    }

    @Override
    public boolean attackedWithInvisibility() {
        return this.attackedWithInvisibility;
    }

    @Override
    public void setWearingInvisibilityCloak(boolean wearing) {
        this.markDirty(true);
        this.wearingInvisibilityCloak = wearing;
    }

    @Override
    public boolean isWearingInvisibilityCloak() {
        return this.wearingInvisibilityCloak;
    }

    @Override
    public int getFlightTimerMax() {
        return 52;
    }

    @Override
    public float getFlightModifierMax() {
        return 15.0f;
    }

    @Override
    public void setFlightTimer(int timer) {
        this.markDirty(true);
        this.flightTimer = timer;
    }

    @Override
    public int getFlightTimer() {
        return this.flightTimer;
    }

    @Override
    public void setFlightModifier(float modifier) {
        this.markDirty(true);
        this.flightModifier = modifier;
    }

    @Override
    public float getFlightModifier() {
        return this.flightModifier;
    }

    @Override
    public void setSavedHealth(float health) {
        this.savedHealth = health;
    }

    @Override
    public float getSavedHealth() {
        return this.savedHealth;
    }

    @Override
    public void setNeptuneSubmergeLength(double length) {
        this.neptuneSubmergeLength = length;
    }

    @Override
    public double getNeptuneSubmergeLength() {
        return this.neptuneSubmergeLength;
    }

    @Override
    public void setPhoenixSubmergeLength(double length) {
        this.phoenixSubmergeLength = length;
    }

    @Override
    public double getPhoenixSubmergeLength() {
        return this.phoenixSubmergeLength;
    }

    @Override
    public int getObsidianConversionTimerMax() {
        return 20;
    }

    @Override
    public void setObsidianConversionTime(int time) {
        this.obsidianConversionTime = time;
    }

    @Override
    public int getObsidianConversionTime() {
        return this.obsidianConversionTime;
    }

    @Override
    public void addToLifeShardCount(int amountToAdd) {
        int newAmount = this.getLifeShardCount() + amountToAdd;
        this.markDirty(true);
        this.lifeShards = newAmount;
    }

    @Override
    public void setLifeShardCount(int amount) {
        this.markDirty(true);
        this.lifeShards = amount;
    }

    @Override
    public int getLifeShardCount() {
        return this.lifeShards;
    }

    @Override
    public int getLifeShardLimit() {
        return (Integer)AetherConfig.SERVER.maximum_life_shards.get();
    }

    @Override
    public AttributeModifier getLifeShardHealthAttributeModifier() {
        return new AttributeModifier(LIFE_SHARD_HEALTH_ID, "Life Shard health increase", (double)((float)this.getLifeShardCount() * 2.0f), AttributeModifier.Operation.ADDITION);
    }

    private void sendCloudMinionPacket(CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.getPlayer().f_19853_.f_46443_) {
                AetherPacketHandler.sendToPlayer(new CloudMinionPacket(this.getPlayer().m_19879_(), cloudMinionRight.m_19879_(), cloudMinionLeft.m_19879_()), serverPlayer);
            }
        }
    }

    @Override
    public AetherPacket getSyncPacket(CompoundTag tag) {
        return new AetherPlayerSyncPacket(this.getPlayer().m_19879_(), tag);
    }
}

