/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability;

import com.aetherteam.aether.capability.INBTSynchable;
import com.aetherteam.aether.network.AetherPacket;
import com.aetherteam.aether.network.AetherPacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public abstract class CapabilitySyncing
implements INBTSynchable<CompoundTag> {
    private CompoundTag storedTag;
    private boolean isDirty = false;
    private boolean shouldForce = false;

    public void updateSyncableNBTFromServer(Level level) {
        if (!level.m_5776_() && (this.canSendPacket() || this.shouldForce())) {
            AetherPacketHandler.sendToAll(this.getSyncPacket(this.getStoredTag()));
            this.markForced(false);
        }
    }

    public void updateSyncableNBTFromClient(Level level) {
        if (level.m_5776_() && (this.canSendPacket() || this.shouldForce())) {
            AetherPacketHandler.sendToServer(this.getSyncPacket(this.getStoredTag()));
            this.markForced(false);
        }
    }

    private boolean canSendPacket() {
        if (this.isDirty()) {
            CompoundTag tag = (CompoundTag)this.serializeSynchableNBT();
            if (!NbtUtils.m_129235_((Tag)tag, (Tag)this.getStoredTag(), (boolean)true)) {
                this.setStoredTag(tag);
                return true;
            }
            this.markDirty(false);
        }
        return false;
    }

    public CompoundTag getStoredTag() {
        return this.storedTag;
    }

    public void setStoredTag(CompoundTag storedTag) {
        this.storedTag = storedTag;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean shouldForce() {
        return this.shouldForce;
    }

    public void markForced(boolean shouldForce) {
        this.shouldForce = shouldForce;
    }

    public abstract AetherPacket getSyncPacket(CompoundTag var1);
}

