/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.blockentity;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.item.miscellaneous.DungeonKeyItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TreasureChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            TreasureChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            TreasureChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int count, int openCount) {
            TreasureChestBlockEntity.this.signalOpenCount(level, pos, state, count, openCount);
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof ChestMenu) {
                CompoundContainer compoundContainer;
                ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
                Container container = chestMenu.m_39261_();
                return container == TreasureChestBlockEntity.this || container instanceof CompoundContainer && (compoundContainer = (CompoundContainer)container).m_18927_((Container)TreasureChestBlockEntity.this);
            }
            return false;
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private boolean locked = true;
    private ResourceLocation kind = new ResourceLocation("aether", "bronze");
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    public TreasureChestBlockEntity() {
        this((BlockEntityType)AetherBlockEntityTypes.TREASURE_CHEST.get(), BlockPos.f_121853_, ((Block)AetherBlocks.TREASURE_CHEST.get()).m_49966_());
    }

    public TreasureChestBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)AetherBlockEntityTypes.TREASURE_CHEST.get(), pos, state);
    }

    protected TreasureChestBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    /*
     * Unable to fully structure code
     */
    public boolean tryUnlock(Player player) {
        stack = player.m_21205_();
        var5_3 = stack.m_41720_();
        if (!(var5_3 instanceof DungeonKeyItem)) ** GOTO lbl-1000
        dungeonKeyItem = (DungeonKeyItem)var5_3;
        if (this.getKind().equals((Object)dungeonKeyItem.getDungeonType())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = keyMatches = false;
        }
        if (this.getLocked() && keyMatches && this.m_58904_() != null) {
            this.setLocked(false);
            this.m_6596_();
            this.m_58904_().markAndNotifyBlock(this.f_58858_, this.m_58904_().m_46745_(this.f_58858_), this.m_58900_(), this.m_58900_(), 2, 512);
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)(this.getKind().m_135827_() + "." + this.getKind().m_135815_() + "_treasure_chest_locked")), true);
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof ChestBlock)) {
            return new InvWrapper((Container)this);
        }
        Container inv = ChestBlock.m_51511_((ChestBlock)((ChestBlock)blockState.m_60734_()), (BlockState)blockState, (Level)this.m_58904_(), (BlockPos)this.m_58899_(), (boolean)true);
        return new InvWrapper((Container)(inv == null ? this : inv));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
            this.chestHandler = null;
        }
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.items = stacks;
    }

    public int m_6643_() {
        return 27;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)("menu." + this.getKind().m_135827_() + "." + this.getKind().m_135815_() + "_treasure_chest"));
    }

    public static void setDungeonType(BlockGetter level, BlockPos pos, ResourceLocation dungeonType) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            TreasureChestBlockEntity treasure = (TreasureChestBlockEntity)blockEntity;
            treasure.setKind(dungeonType);
        }
    }

    public void setKind(ResourceLocation kind) {
        this.kind = kind;
    }

    public ResourceLocation getKind() {
        return this.kind;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int count, int openCount) {
        level.m_7696_(pos, state.m_60734_(), 1, openCount);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, TreasureChestBlockEntity blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Locked", this.getLocked());
        tag.m_128359_("Kind", this.getKind().toString());
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.locked = !tag.m_128441_("Locked") || tag.m_128471_("Locked");
        this.kind = tag.m_128441_("Kind") ? new ResourceLocation(tag.m_128461_("Kind")) : new ResourceLocation("aether", "bronze");
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        if (compound != null) {
            this.handleUpdateTag(compound);
        }
    }
}

