/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.blockentity;

import com.aetherteam.aether.blockentity.AbstractAetherFurnaceBlockEntity;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.inventory.menu.AltarMenu;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class AltarBlockEntity
extends AbstractAetherFurnaceBlockEntity {
    private static final Map<Item, Integer> enchantingMap = new LinkedHashMap<Item, Integer>();

    public AltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AetherBlockEntityTypes.ALTAR.get(), pos, state, (RecipeType<? extends AbstractCookingRecipe>)((RecipeType)AetherRecipeTypes.ENCHANTING.get()));
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"menu.aether.altar");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new AltarMenu(id, playerInventory, (Container)this, this.f_58311_);
    }

    protected int m_7743_(ItemStack fuelStack) {
        if (fuelStack.m_41619_() || !AltarBlockEntity.getEnchantingMap().containsKey(fuelStack.m_41720_())) {
            return 0;
        }
        return AltarBlockEntity.getEnchantingMap().get(fuelStack.m_41720_());
    }

    public static Map<Item, Integer> getEnchantingMap() {
        return enchantingMap;
    }

    private static void addItemTagEnchantingTime(TagKey<Item> itemTag, int burnTime) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags != null) {
            tags.getTag(itemTag).stream().forEach(item -> AltarBlockEntity.getEnchantingMap().put((Item)item, burnTime));
        }
    }

    public static void addItemEnchantingTime(ItemLike itemProvider, int burnTime) {
        Item item = itemProvider.m_5456_();
        AltarBlockEntity.getEnchantingMap().put(item, burnTime);
    }
}

