/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.capability.AetherCapabilities;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import com.aetherteam.aether.util.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;

public class AetherPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public AetherPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                LazyOptional aetherPlayer;
                if (!entity.m_9236_().m_5776_() && !pos.equals((Object)entityAccessor.aether$getPortalEntrancePos())) {
                    entityAccessor.aether$setPortalEntrancePos(pos.m_7949_());
                }
                if (!(aetherPlayer = entity.getCapability(AetherCapabilities.AETHER_PLAYER_CAPABILITY)).isPresent()) {
                    this.handleTeleportation(entity);
                } else {
                    aetherPlayer.ifPresent(handler -> {
                        handler.setInPortal(true);
                        int waitTime = handler.getPortalTimer();
                        if (waitTime >= entity.m_6078_()) {
                            this.handleTeleportation(entity);
                            handler.setPortalTimer(0);
                        }
                    });
                }
            }
        }
    }

    private void handleTeleportation(Entity entity) {
        ServerLevel destinationLevel;
        ResourceKey<Level> destinationKey;
        MinecraftServer minecraftserver = entity.m_9236_().m_7654_();
        ResourceKey<Level> resourceKey = destinationKey = entity.m_9236_().m_46472_() == LevelUtil.destinationDimension() ? LevelUtil.returnDimension() : LevelUtil.destinationDimension();
        if (minecraftserver != null && (destinationLevel = minecraftserver.m_129880_(destinationKey)) != null && !entity.m_20159_()) {
            entity.m_9236_().m_46473_().m_6180_("aether_portal");
            entity.m_20091_();
            entity.changeDimension(destinationLevel, (ITeleporter)new AetherPortalForcer(destinationLevel, true));
            entity.m_9236_().m_46473_().m_7238_();
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_AMBIENT.get(), SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + random.m_188500_();
            double z = (double)pos.m_123343_() + random.m_188500_();
            double xSpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            double ySpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            double zSpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            int j = random.m_188503_(2) * 2 - 1;
            if (!level.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !level.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                xSpeed = random.m_188501_() * 2.0f * (float)j;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                zSpeed = random.m_188501_() * 2.0f * (float)j;
            }
            level.m_7106_((ParticleOptions)AetherParticleTypes.AETHER_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.X -> X_AXIS_AABB;
            default -> X_AXIS_AABB;
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = direction.m_122434_();
        Direction.Axis blockAxis = (Direction.Axis)state.m_61143_(AXIS);
        boolean flag = blockAxis != directionAxis && directionAxis.m_122479_();
        return !flag && !facingState.m_60713_((Block)this) && !new AetherPortalShape(level, currentPos, blockAxis).isComplete() ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, facingState, level, currentPos, facingPos);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }
}

