/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.dispenser;

import com.aetherteam.aether.entity.projectile.weapon.HammerProjectile;
import com.aetherteam.aether.entity.projectile.weapon.ThrownLightningKnife;
import com.aetherteam.aether.inventory.menu.AccessoriesMenu;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.bucket.SkyrootBucketItem;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class AetherDispenseBehaviors {
    public static final DispenseItemBehavior DISPENSE_ACCESSORY_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            return AetherDispenseBehaviors.dispenseAccessory(blockSource, stack) ? stack : super.m_7498_(blockSource, stack);
        }
    };
    public static final DispenseItemBehavior DISPENSE_LIGHTNING_KNIFE_BEHAVIOR = new AbstractProjectileDispenseBehavior(){

        protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
            return (Projectile)Util.m_137469_((Object)((Object)new ThrownLightningKnife(level)), lightningKnife -> {
                lightningKnife.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                lightningKnife.m_37446_(stack);
            });
        }

        protected float m_7101_() {
            return 1.5f;
        }
    };
    public static final DispenseItemBehavior DISPENSE_KINGBDOGZ_HAMMER_BEHAVIOR = new AbstractProjectileDispenseBehavior(){

        public ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            Projectile projectile = this.m_6895_((Level)blockSource.m_7727_(), DispenserBlock.m_52720_((BlockSource)blockSource), stack);
            AetherDispenseBehaviors.spawnProjectile(blockSource, projectile, this.m_7104_(), this.m_7101_());
            stack.m_41721_(stack.m_41773_() + 1);
            if (stack.m_41773_() >= stack.m_41776_()) {
                stack.m_41774_(1);
            }
            return stack;
        }

        protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
            return (Projectile)Util.m_137469_((Object)((Object)new HammerProjectile(level)), projectile -> projectile.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_()));
        }

        protected float m_7101_() {
            return 1.0f;
        }
    };
    public static final DispenseItemBehavior SKYROOT_BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)stack.m_41720_();
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            if (dispensibleContainerItem.m_142073_(null, (Level)level, blockpos, null)) {
                dispensibleContainerItem.m_142131_(null, (Level)level, stack, blockpos);
                return new ItemStack((ItemLike)AetherItems.SKYROOT_BUCKET.get());
            }
            return this.defaultDispenseItemBehavior.m_6115_(source, stack);
        }
    };
    public static final DispenseItemBehavior SKYROOT_BUCKET_PICKUP_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockPos;
            ServerLevel levelAccessor = source.m_7727_();
            BlockState blockState = levelAccessor.m_8055_(blockPos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            Block block = blockState.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                ItemStack bucketStack = bucketPickup.m_142598_((LevelAccessor)levelAccessor, blockPos, blockState);
                if ((bucketStack = SkyrootBucketItem.swapBucketType(bucketStack)).m_41619_()) {
                    return super.m_7498_(source, stack);
                }
                levelAccessor.m_142346_(null, GameEvent.f_157816_, blockPos);
                Item item = bucketStack.m_41720_();
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    return new ItemStack((ItemLike)item);
                }
                if (((DispenserBlockEntity)source.m_8118_()).m_59237_(new ItemStack((ItemLike)item)) < 0) {
                    this.defaultDispenseItemBehavior.m_6115_(source, new ItemStack((ItemLike)item));
                }
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };

    public static boolean dispenseAccessory(BlockSource blockSource, ItemStack stack) {
        BlockPos pos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = blockSource.m_7727_().m_6443_(LivingEntity.class, new AABB(pos), EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(stack)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)list.get(0);
        ItemStack itemStack = stack.m_41620_(1);
        ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
        curiosHelper.getCurio(itemStack).ifPresent(curio -> curiosHelper.getCuriosHandler(livingEntity).ifPresent(handler -> {
            Map curios = handler.getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                if (!List.of(AccessoriesMenu.AETHER_IDENTIFIERS).contains(entry.getKey())) continue;
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack slotStack;
                    String id = (String)entry.getKey();
                    SlotContext slotContext = new SlotContext(id, livingEntity, i, false, true);
                    if (!curiosHelper.isStackValid(slotContext, itemStack) || !curio.canEquip(slotContext) || !curio.canEquipFromUse(slotContext) || !(slotStack = stackHandler.getStackInSlot(i)).m_41619_()) continue;
                    stackHandler.setStackInSlot(i, itemStack.m_41777_());
                    int count = itemStack.m_41613_();
                    itemStack.m_41774_(count);
                }
            }
        }));
        return true;
    }

    protected static void spawnProjectile(BlockSource source, Projectile projectile, float velocity, float inaccuracy) {
        ServerLevel level = source.m_7727_();
        Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        projectile.m_6686_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_(), velocity, inaccuracy);
        level.m_7967_((Entity)projectile);
    }
}

