/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block;

import com.aetherteam.aether.block.FreezingBehavior;
import com.aetherteam.aether.event.dispatch.AetherEventDispatch;
import com.aetherteam.aether.event.events.FreezeEvent;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.recipes.block.IcestoneFreezableRecipe;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.commands.CommandFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public interface FreezingBlock
extends FreezingBehavior<BlockState> {
    public static final float SQRT_8 = Mth.m_14116_((float)8.0f);
    public static final Table<Block, BlockPropertyPair, IcestoneFreezableRecipe> cachedBlocks = HashBasedTable.create();

    @Override
    default public int freezeFromRecipe(Level level, BlockPos pos, BlockState source, int flag) {
        if (!level.m_5776_()) {
            IcestoneFreezableRecipe freezableRecipe;
            BlockPropertyPair pair;
            BlockState oldBlockState = level.m_8055_(pos);
            Block oldBlock = oldBlockState.m_60734_();
            FluidState fluidState = level.m_6425_(pos);
            if (fluidState.m_76178_() || oldBlockState.m_60713_(fluidState.m_76188_().m_60734_())) {
                IcestoneFreezableRecipe freezableRecipe2;
                BlockPropertyPair pair2 = FreezingBlock.matchesCache(oldBlock, oldBlockState);
                if (pair2 != null && (freezableRecipe2 = (IcestoneFreezableRecipe)cachedBlocks.get((Object)oldBlock, (Object)pair2)) != null) {
                    BlockState newBlockState = freezableRecipe2.getResultState(oldBlockState);
                    CommandFunction.CacheableFunction function = freezableRecipe2.getFunction();
                    return this.freezeBlockAt(level, pos, oldBlockState, newBlockState, function, source, flag);
                }
            } else if (!oldBlockState.m_61138_((Property)BlockStateProperties.f_61362_) && (pair = FreezingBlock.matchesCache(oldBlock, oldBlockState = fluidState.m_76188_())) != null && (freezableRecipe = (IcestoneFreezableRecipe)cachedBlocks.get((Object)oldBlock, (Object)pair)) != null) {
                level.m_46961_(pos, true);
                BlockState newBlockState = freezableRecipe.getResultState(oldBlockState);
                CommandFunction.CacheableFunction function = freezableRecipe.getFunction();
                return this.freezeBlockAt(level, pos, oldBlockState, newBlockState, function, source, flag);
            }
        }
        return 0;
    }

    @Override
    default public FreezeEvent onFreeze(LevelAccessor level, BlockPos pos, BlockState oldBlockState, BlockState newBlockState, BlockState source) {
        return AetherEventDispatch.onBlockFreezeFluid(level, pos, oldBlockState, newBlockState, source);
    }

    public static void cacheRecipes(Level level) {
        if (cachedBlocks.isEmpty()) {
            for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.ICESTONE_FREEZABLE.get())) {
                IcestoneFreezableRecipe freezableRecipe;
                BlockPropertyPair[] pairs;
                if (!(recipe instanceof IcestoneFreezableRecipe) || (pairs = (freezableRecipe = (IcestoneFreezableRecipe)recipe).getIngredient().getPairs()) == null) continue;
                Arrays.stream(pairs).forEach(pair -> cachedBlocks.put((Object)pair.block(), pair, (Object)freezableRecipe));
            }
        }
    }

    public static BlockPropertyPair matchesCache(Block block, BlockState blockState) {
        if (cachedBlocks.containsRow((Object)block)) {
            BlockPropertyPair pair = null;
            for (Map.Entry entry : cachedBlocks.row((Object)block).entrySet()) {
                if (!((BlockPropertyPair)entry.getKey()).matches(blockState)) continue;
                pair = (BlockPropertyPair)entry.getKey();
            }
            return pair;
        }
        return null;
    }
}

