/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.api;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.mixin.mixins.common.accessor.LevelStorageAccessAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.MinecraftServerAccessor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.DirectoryLock;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;

public class WorldDisplayHelper {
    public static Level loadedLevel = null;
    public static LevelSummary loadedSummary = null;

    public static void toggleWorldPreview(boolean config) {
        if (config) {
            WorldDisplayHelper.enableWorldPreview();
        } else if (WorldDisplayHelper.disableWorldPreview((Screen)new GenericDirtMessageScreen((Component)Component.m_237113_((String)"")))) {
            Minecraft.m_91087_().m_91346_((Screen)GuiHooks.getMenu());
        }
    }

    public static void enableWorldPreview() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (((Boolean)AetherConfig.CLIENT.enable_world_preview.get()).booleanValue() && loadedLevel == null) {
            LevelStorageSource source = minecraft.m_91392_();
            try {
                ArrayList summaryList = new ArrayList((Collection)source.m_230813_(source.m_230833_()).get());
                Collections.sort(summaryList);
                if (summaryList.size() > 0) {
                    LevelSummary summary = null;
                    for (int i = summaryList.size() - 1; i >= 0; --i) {
                        LevelSummary s = (LevelSummary)summaryList.get(i);
                        if (s.m_78375_() || s.m_164916_()) continue;
                        summary = s;
                    }
                    if (summary != null) {
                        loadedSummary = summary;
                        WorldDisplayHelper.loadWorld(summary);
                    }
                }
            }
            catch (InterruptedException | UnsupportedOperationException | ExecutionException e) {
                AetherConfig.CLIENT.enable_world_preview.set((Object)false);
                e.printStackTrace();
            }
        }
    }

    public static boolean disableWorldPreview(Screen screen) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (loadedLevel != null) {
            AetherConfig.CLIENT.enable_world_preview.set((Object)false);
            AetherConfig.CLIENT.enable_world_preview.save();
            WorldDisplayHelper.stopWorld(minecraft, screen);
            return true;
        }
        return false;
    }

    public static void loadWorld(LevelSummary summary) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91392_().m_78255_(summary.m_78358_())) {
            minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
            loadedSummary = summary;
            minecraft.m_231466_().m_233133_(minecraft.f_91080_, summary.m_78358_());
        }
    }

    public static void setupLevelForDisplay() {
        Minecraft minecraft = Minecraft.m_91087_();
        IntegratedServer server = minecraft.m_91092_();
        if (server != null) {
            loadedLevel = minecraft.f_91073_;
            Minecraft.m_91087_().f_91066_.f_92062_ = true;
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            WorldDisplayHelper.deleteSessionLock();
        }
    }

    public static void quickLoad() {
        if (loadedSummary != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            if (minecraft.m_91392_().m_78255_(loadedSummary.m_78358_()) && minecraft.m_91092_() != null) {
                WorldDisplayHelper.openSessionLock();
                WorldDisplayHelper.fixWorld();
                minecraft.m_91346_(null);
            }
        }
    }

    public static void stopWorld(Minecraft minecraft, Screen screen) {
        WorldDisplayHelper.fixWorld();
        IntegratedServer server = minecraft.m_91092_();
        if (server != null) {
            server.m_7570_(false);
        }
        if (screen != null) {
            minecraft.m_91320_(screen);
        } else {
            minecraft.m_91399_();
        }
    }

    public static void fixWorld() {
        Minecraft.m_91087_().f_91066_.f_92062_ = false;
        Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
        loadedLevel = null;
        loadedSummary = null;
    }

    public static void deleteSessionLock() {
        try {
            LevelStorageSource.LevelStorageAccess storageAccess = WorldDisplayHelper.getStorageAccess();
            if (storageAccess != null) {
                storageAccess.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openSessionLock() {
        try {
            LevelStorageSource.LevelStorageAccess storageAccess = WorldDisplayHelper.getStorageAccess();
            if (storageAccess != null) {
                LevelStorageAccessAccessor levelStorageAccessAccessor = (LevelStorageAccessAccessor)storageAccess;
                levelStorageAccessAccessor.aether$setLock(DirectoryLock.m_13640_((Path)storageAccess.getWorldDir()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LevelStorageSource.LevelStorageAccess getStorageAccess() {
        Minecraft minecraft = Minecraft.m_91087_();
        IntegratedServer server = minecraft.m_91092_();
        if (server != null) {
            MinecraftServerAccessor minecraftServerAccessor = (MinecraftServerAccessor)server;
            return minecraftServerAccessor.aether$getStorageSource();
        }
        return null;
    }
}

