/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.api;

import com.aetherteam.aether.entity.BossMob;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record BossRoomTracker<T extends Mob>(T boss, Vec3 originCoordinates, AABB roomBounds, List<UUID> dungeonPlayers) {
    public boolean isBossWithinRoom() {
        return this.roomBounds().m_82390_(this.boss().m_20182_());
    }

    public boolean isPlayerWithinRoom(Entity entity) {
        return this.roomBounds().m_82390_(entity.m_20182_());
    }

    public boolean isPlayerWithinRoomInterior(Entity entity) {
        return this.roomBounds().m_165897_(1.0, 1.0, 1.0).m_82390_(entity.m_20182_());
    }

    public boolean isPlayerTracked(Player player) {
        return this.dungeonPlayers().contains(player.m_20148_());
    }

    public void trackPlayers() {
        this.boss().m_9236_().m_142425_((EntityTypeTest)EntityType.f_20532_, this.roomBounds(), Entity::m_6084_).forEach(player -> {
            if (!this.isPlayerTracked((Player)player)) {
                ((BossMob)this.boss()).onDungeonPlayerAdded((Player)player);
                this.dungeonPlayers().add(player.m_20148_());
            }
        });
        this.dungeonPlayers().removeIf(uuid -> {
            boolean shouldRemove;
            Player player = this.boss().m_9236_().m_46003_(uuid);
            boolean bl = shouldRemove = player != null && (!this.isPlayerWithinRoom((Entity)player) || !player.m_6084_());
            if (shouldRemove) {
                ((BossMob)this.boss()).onDungeonPlayerRemoved(player);
            }
            return shouldRemove;
        });
    }

    public void grantAdvancements(@Nonnull DamageSource damageSource) {
        for (UUID uuid : this.dungeonPlayers()) {
            Player player = this.boss().m_9236_().m_46003_(uuid);
            if (player == null) continue;
            player.m_5993_(this.boss(), ((BossMob)this.boss()).getDeathScore(), damageSource);
        }
    }

    public void modifyRoom(Function<BlockState, BlockState> function) {
        AABB bounds = this.roomBounds();
        Level level = this.boss().m_9236_();
        for (BlockPos pos : BlockPos.m_121976_((int)((int)bounds.f_82288_), (int)((int)bounds.f_82289_), (int)((int)bounds.f_82290_), (int)((int)bounds.f_82291_), (int)((int)bounds.f_82292_), (int)((int)bounds.f_82293_))) {
            BlockState state = level.m_8055_(pos);
            BlockState newState = function.apply(state);
            if (newState == null) continue;
            level.m_7731_(pos, newState, 3);
        }
    }

    public CompoundTag addAdditionalSaveData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("OriginX", this.originCoordinates().m_7096_());
        tag.m_128347_("OriginY", this.originCoordinates().m_7098_());
        tag.m_128347_("OriginZ", this.originCoordinates().m_7094_());
        tag.m_128347_("RoomBoundsMinX", this.roomBounds().f_82288_);
        tag.m_128347_("RoomBoundsMinY", this.roomBounds().f_82289_);
        tag.m_128347_("RoomBoundsMinZ", this.roomBounds().f_82290_);
        tag.m_128347_("RoomBoundsMaxX", this.roomBounds().f_82291_);
        tag.m_128347_("RoomBoundsMaxY", this.roomBounds().f_82292_);
        tag.m_128347_("RoomBoundsMaxZ", this.roomBounds().f_82293_);
        tag.m_128405_("DungeonPlayersSize", this.dungeonPlayers().size());
        for (int i = 0; i < this.dungeonPlayers().size(); ++i) {
            tag.m_128362_("Player" + i, this.dungeonPlayers().get(i));
        }
        return tag;
    }

    public static <T extends Mob> BossRoomTracker<T> readAdditionalSaveData(@Nonnull CompoundTag tag, T boss) {
        double originX = tag.m_128459_("OriginX");
        double originY = tag.m_128459_("OriginY");
        double originZ = tag.m_128459_("OriginZ");
        Vec3 originCoordinates = new Vec3(originX, originY, originZ);
        double minX = tag.m_128459_("RoomBoundsMinX");
        double minY = tag.m_128459_("RoomBoundsMinY");
        double minZ = tag.m_128459_("RoomBoundsMinZ");
        double maxX = tag.m_128459_("RoomBoundsMaxX");
        double maxY = tag.m_128459_("RoomBoundsMaxY");
        double maxZ = tag.m_128459_("RoomBoundsMaxZ");
        AABB roomBounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        ArrayList<UUID> dungeonPlayers = new ArrayList<UUID>();
        int size = tag.m_128451_("DungeonPlayersSize");
        for (int i = 0; i < size; ++i) {
            UUID uuid = tag.m_128342_("Player" + i);
            dungeonPlayers.add(uuid);
        }
        return new BossRoomTracker<T>(boss, originCoordinates, roomBounds, dungeonPlayers);
    }
}

