/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AetherConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_bed_explosions;
        public final ForgeConfigSpec.ConfigValue<Boolean> edible_ambrosium;
        public final ForgeConfigSpec.ConfigValue<Boolean> tools_debuff;
        public final ForgeConfigSpec.ConfigValue<Boolean> healing_gummy_swets;
        public final ForgeConfigSpec.ConfigValue<Integer> hammer_of_kingbdogz_cooldown;
        public final ForgeConfigSpec.ConfigValue<Integer> cloud_staff_cooldown;
        public final ForgeConfigSpec.ConfigValue<Integer> maximum_life_shards;
        public final ForgeConfigSpec.ConfigValue<Boolean> spawn_golden_feather;
        public final ForgeConfigSpec.ConfigValue<Boolean> spawn_valkyrie_cape;
        public final ForgeConfigSpec.ConfigValue<Boolean> generate_tall_grass;
        public final ForgeConfigSpec.ConfigValue<Boolean> generate_holiday_tree_always;
        public final ForgeConfigSpec.ConfigValue<Boolean> generate_holiday_tree_seasonally;
        public final ForgeConfigSpec.ConfigValue<Boolean> balance_invisibility_cloak;
        public final ForgeConfigSpec.ConfigValue<Integer> invisibility_visibility_time;
        public final ForgeConfigSpec.ConfigValue<Boolean> sun_altar_whitelist;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_aether_portal;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_falling_to_overworld;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_eternal_day;
        public final ForgeConfigSpec.ConfigValue<String> portal_destination_dimension_ID;
        public final ForgeConfigSpec.ConfigValue<String> portal_return_dimension_ID;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Gameplay");
            this.enable_bed_explosions = builder.comment("Vanilla's beds will explode in the Aether").translation("config.aether.server.gameplay.enable_bed_explosions").define("Beds explode", false);
            this.tools_debuff = builder.comment("Tools that aren't from the Aether will mine Aether blocks slower than tools that are from the Aether").translation("config.aether.server.gameplay.tools_debuff").define("Debuff non-Aether tools", true);
            this.edible_ambrosium = builder.comment("Ambrosium Shards can be eaten to restore a half heart of health").translation("config.aether.server.gameplay.edible_ambrosium").define("Ambrosium Shards are edible", true);
            this.healing_gummy_swets = builder.comment("Gummy Swets when eaten restore full health instead of full hunger").translation("config.aether.server.gameplay.healing_gummy_swets").define("Gummy Swets restore health", false);
            this.maximum_life_shards = builder.comment("Determines the limit of the amount of Life Shards a player can consume to increase their health").translation("config.aether.server.gameplay.maximum_life_shards").define("Maximum consumable Life Shards", (Object)10);
            this.hammer_of_kingbdogz_cooldown = builder.comment("Determines the cooldown in ticks for the Hammer of Kingbdogz's ability").translation("config.aether.server.gameplay.hammer_of_kingbdogz_cooldown").define("Cooldown for the Hammer of Kingbdogz", (Object)75);
            this.cloud_staff_cooldown = builder.comment("Determines the cooldown in ticks for the Cloud Staff's ability").translation("config.aether.server.gameplay.cloud_staff_cooldown").define("Cooldown for the Cloud Staff", (Object)40);
            builder.pop();
            builder.push("Loot");
            this.spawn_golden_feather = builder.comment("Allows the Golden Feather to spawn in the Silver Dungeon loot table").translation("config.aether.server.loot.spawn_golden_feather").define("Golden Feather in loot", true);
            this.spawn_valkyrie_cape = builder.comment("Allows the Valkyrie Cape to spawn in the Silver Dungeon loot table").translation("config.aether.server.loot.spawn_valkyrie_cape").define("Valkyrie Cape in loot", true);
            builder.pop();
            builder.push("World Generation");
            this.generate_tall_grass = builder.comment("Determines whether the Aether should generate Tall Grass blocks on terrain or not").translation("config.aether.server.world_generation.generate_tall_grass").define("Generate Tall Grass in the Aether", true);
            this.generate_holiday_tree_always = builder.comment("Determines whether Holiday Trees should always be able to generate when exploring new chunks in the Aether, if true, this overrides 'Generate Holiday Trees seasonally'").translation("config.aether.server.world_generation.generate_holiday_tree_always").define("Generate Holiday Trees always", false);
            this.generate_holiday_tree_seasonally = builder.comment("Determines whether Holiday Trees should be able to generate during the time frame of December and January when exploring new chunks in the Aether, only works if 'Generate Holiday Trees always' is set to false").translation("config.aether.server.world_generation.generate_holiday_tree_seasonally").define("Generate Holiday Trees seasonally", true);
            builder.pop();
            builder.push("Multiplayer");
            this.balance_invisibility_cloak = builder.comment("Makes the Invisibility Cloak more balanced in PVP by disabling equipment invisibility temporarily after attacks").translation("config.aether.server.multiplayer.balance_invisibility_cloak").define("Balance Invisibility Cloak for PVP", false);
            this.invisibility_visibility_time = builder.comment("Sets the time in ticks that it takes for the player to become fully invisible again after attacking when wearing an Invisibility Cloak; only works with 'Balance Invisibility Cloak for PVP'").translation("config.aether.server.multiplayer.invisibility_visibility_time").define("Invisibility Cloak visibility timer", (Object)50);
            this.sun_altar_whitelist = builder.comment("Makes it so that only whitelisted users or anyone with permission level 4 can use the Sun Altar on a server").translation("config.aether.server.multiplayer.sun_altar_whitelist").define("Only whitelisted users access Sun Altars", false);
            builder.pop();
            builder.push("Modpack");
            this.disable_aether_portal = builder.comment("Prevents the Aether Portal from being created normally in the mod").translation("config.aether.server.modpack.disable_aether_portal").define("Disables Aether Portal creation", false);
            this.disable_falling_to_overworld = builder.comment("Prevents the player from falling back to the Overworld when they fall out of the Aether").translation("config.aether.server.modpack.disable_falling_to_overworld").define("Disables falling into the Overworld", false);
            this.disable_eternal_day = builder.comment("Removes eternal day so that the Aether has a normal daylight cycle even before defeating the Sun Spirit").translation("config.aether.server.modpack.disable_eternal_day").define("Disables eternal day", false);
            this.portal_destination_dimension_ID = builder.comment("Sets the ID of the dimension that the Aether Portal will send the player to").translation("config.aether.server.modpack.portal_destination_dimension_ID").define("Sets portal destination dimension", (Object)AetherDimensions.AETHER_LEVEL.m_135782_().toString());
            this.portal_return_dimension_ID = builder.comment("Sets the ID of the dimension that the Aether Portal will return the player to").translation("config.aether.server.modpack.portal_return_dimension_ID").define("Sets portal return dimension", (Object)Level.f_46428_.m_135782_().toString());
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> start_with_portal;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_startup_loot;
        public final ForgeConfigSpec.ConfigValue<Boolean> repeat_sun_spirit_dialogue;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Gameplay");
            this.start_with_portal = builder.comment("On world creation, the player is given an Aether Portal Frame item to automatically go to the Aether with").translation("config.aether.common.gameplay.start_with_portal").define("Gives player Aether Portal Frame item", false);
            this.enable_startup_loot = builder.comment("When the player enters the Aether, they are given a Book of Lore and Golden Parachutes as starting loot").translation("config.aether.common.gameplay.enable_startup_loot").define("Gives starting loot on entry", true);
            this.repeat_sun_spirit_dialogue = builder.comment("Determines whether the Sun Spirit's dialogue when meeting him should play through every time you meet him").translation("config.aether.common.gameplay.repeat_sun_spirit_dialogue").define("Repeat Sun Spirit's battle dialogue", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> legacy_models;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_aether_skybox;
        public final ForgeConfigSpec.ConfigValue<Boolean> colder_lightmap;
        public final ForgeConfigSpec.ConfigValue<Boolean> green_sunset;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_aether_menu;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_aether_menu_button;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_world_preview;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_world_preview_button;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_quick_load_button;
        public final ForgeConfigSpec.ConfigValue<Boolean> menu_type_toggles_alignment;
        public final ForgeConfigSpec.ConfigValue<Boolean> align_vanilla_menu_elements_left;
        public final ForgeConfigSpec.ConfigValue<Boolean> align_aether_menu_elements_left;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_trivia;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_silver_hearts;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_accessory_button;
        public final ForgeConfigSpec.ConfigValue<Integer> button_inventory_x;
        public final ForgeConfigSpec.ConfigValue<Integer> button_inventory_y;
        public final ForgeConfigSpec.ConfigValue<Integer> button_creative_x;
        public final ForgeConfigSpec.ConfigValue<Integer> button_creative_y;
        public final ForgeConfigSpec.ConfigValue<Integer> button_accessories_x;
        public final ForgeConfigSpec.ConfigValue<Integer> button_accessories_y;
        public final ForgeConfigSpec.ConfigValue<Integer> music_backup_min_delay;
        public final ForgeConfigSpec.ConfigValue<Integer> music_backup_max_delay;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_music_manager;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_aether_menu_music;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_vanilla_world_preview_menu_music;
        public final ForgeConfigSpec.ConfigValue<Boolean> disable_aether_world_preview_menu_music;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("Rendering");
            this.legacy_models = builder.comment("Changes Zephyr and Aerwhale rendering to use their old models from the b1.7.3 version of the mod").translation("config.aether.client.rendering.legacy_models").define("Switches to legacy mob models", false);
            this.disable_aether_skybox = builder.comment("Disables the Aether's custom skybox in case you have a shader that is incompatible with custom skyboxes").translation("config.aether.client.rendering.disable_aether_skybox").define("Disables Aether custom skybox", false);
            this.colder_lightmap = builder.comment("Removes warm-tinting of the lightmap in the Aether, giving the lighting a colder feel").translation("config.aether.client.rendering.colder_lightmap").define("Makes lightmap colder", false);
            this.green_sunset = builder.comment("Enables a green-tinted sunrise and sunset in the Aether, similar to the original mod").translation("config.aether.client.rendering.green_sunset").define("Enables green sunrise/sunset", false);
            builder.pop();
            builder.push("Gui");
            this.enable_aether_menu = builder.comment("Changes the vanilla Minecraft menu into the Aether menu").translation("config.aether.client.gui.enable_aether_menu").define("Enables Aether menu", false);
            this.enable_aether_menu_button = builder.comment("Adds a button to the top right of the main menu screen to toggle between the Aether and vanilla menu").translation("config.aether.client.gui.enable_aether_menu_button").define("Enables Aether menu button", true);
            this.enable_world_preview = builder.comment("Changes the background panorama into a preview of the latest played world").translation("config.aether.client.gui.enable_world_preview").define("Enables world preview", false);
            this.enable_world_preview_button = builder.comment("Adds a button to the top right of the main menu screen to toggle between the panorama and world preview").translation("config.aether.client.gui.enable_world_preview_button").define("Enables toggle world button", true);
            this.enable_quick_load_button = builder.comment("Adds a button to the top right of the main menu screen to allow quick loading into a world if the world preview is enabled").translation("config.aether.client.gui.enable_quick_load_button").define("Enables quick load button", true);
            this.menu_type_toggles_alignment = builder.comment("Determines that menu elements will align left if the menu's world preview is active, if true, this overrides 'Align menu elements left'").translation("config.aether.client.gui.menu_type_toggles_alignment").define("Align menu elements left with world preview", false);
            this.align_vanilla_menu_elements_left = builder.comment("Aligns the elements of the vanilla menu to the left, only works if 'Align menu left with world preview' is set to false").translation("config.aether.client.gui.align_vanilla_menu_elements_left").define("Align vanilla menu elements left", false);
            this.align_aether_menu_elements_left = builder.comment("Aligns the elements of the Aether menu to the left, only works if 'Align menu left with world preview' is set to false").translation("config.aether.client.gui.align_aether_menu_elements_left").define("Align Aether menu elements left", true);
            this.enable_trivia = builder.comment("Adds random trivia and tips to the bottom of loading screens").translation("config.aether.client.gui.enable_trivia").define("Enables random trivia", true);
            this.enable_silver_hearts = builder.comment("Makes the extra hearts given by life shards display as silver colored").translation("config.aether.client.gui.enable_silver_hearts").define("Enables silver life shard hearts", true);
            this.disable_accessory_button = builder.comment("Disables the Aether's accessories button from appearing in GUIs").translation("config.aether.client.gui.disable_accessory_button").define("Disables the accessories button", false);
            this.button_inventory_x = builder.comment("The x-coordinate of the accessories button in the inventory and curios menus").translation("config.aether.client.gui.button_inventory_x").define("Button x-coordinate in inventory menus", (Object)27);
            this.button_inventory_y = builder.comment("The y-coordinate of the accessories button in the inventory and curios menus").translation("config.aether.client.gui.button_inventory_y").define("Button y-coordinate in inventory menus", (Object)68);
            this.button_creative_x = builder.comment("The x-coordinate of the accessories button in the creative menu").translation("config.aether.client.gui.button_creative_x").define("Button x-coordinate in creative menu", (Object)74);
            this.button_creative_y = builder.comment("The y-coordinate of the accessories button in the creative menu").translation("config.aether.client.gui.button_creative_y").define("Button y-coordinate in creative menu", (Object)40);
            this.button_accessories_x = builder.comment("The x-coordinate of the accessories button in the accessories menu").translation("config.aether.client.gui.button_accessories_x").define("Button x-accessories in accessories menu", (Object)9);
            this.button_accessories_y = builder.comment("The y-coordinate of the accessories button in the accessories menu").translation("config.aether.client.gui.button_accessories_y").define("Button y-accessories in accessories menu", (Object)68);
            builder.pop();
            builder.push("Audio");
            this.music_backup_min_delay = builder.comment("Sets the minimum delay for the Aether's music manager to use if needing to reset the song delay outside the Aether").translation("config.aether.client.audio.music_backup_min_delay").define("Set backup minimum music delay", (Object)12000);
            this.music_backup_max_delay = builder.comment("Sets the maximum delay for the Aether's music manager to use if needing to reset the song delay outside the Aether").translation("config.aether.client.audio.music_backup_max_delay").define("Set backup maximum music delay", (Object)24000);
            this.disable_music_manager = builder.comment("Disables the Aether's internal music manager, if true, this overrides all other audio configs").translation("config.aether.client.audio.disable_music_manager").define("Disables Aether music manager", false);
            this.disable_aether_menu_music = builder.comment("Disables the Aether's menu music in case another mod implements its own, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_aether_menu_music").define("Disables Aether menu music", false);
            this.disable_vanilla_world_preview_menu_music = builder.comment("Disables the menu music on the vanilla world preview menu, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_vanilla_world_preview_menu_music").define("Disables vanilla world preview menu music", false);
            this.disable_aether_world_preview_menu_music = builder.comment("Disables the menu music on the Aether world preview menu, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_aether_world_preview_menu_music").define("Disables Aether world preview menu music", false);
            builder.pop();
        }
    }
}

