/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.scissor.ScissorBoxStack;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import com.teamresourceful.resourcefullib.common.utils.types.Bound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;

public final class RenderUtils {
    private RenderUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static void bindTexture(ResourceLocation location) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
    }

    public static Bound getScissorBounds(Minecraft minecraft, PoseStack stack, int x, int y, int width, int height) {
        float guiScale = (float)minecraft.m_91268_().m_85449_();
        Vector2ic translation = RenderUtils.getTranslation(stack);
        float translationX = (float)translation.x() * guiScale;
        float translationY = (float)translation.y() * guiScale;
        return new Bound((int)(translationX + (float)x * guiScale), (int)((float)Minecraft.m_91087_().m_91268_().m_85442_() - (float)y * guiScale - translationY - (float)height * guiScale), (int)((float)width * guiScale), (int)((float)height * guiScale));
    }

    public static Vector2ic getTranslation(PoseStack stack) {
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f vec = pose.getTranslation(new Vector3f());
        return new Vector2i((int)vec.x, (int)vec.y);
    }

    @Deprecated
    public static void renderItem(PoseStack stack, ItemStack item, int x, int y) {
        Minecraft.m_91087_().m_91291_().m_274569_(stack, item, x, y);
    }

    public static ClosingScissorBox createScissorBox(Minecraft minecraft, PoseStack stack, int x, int y, int width, int height) {
        Bound bound = RenderUtils.getScissorBounds(minecraft, stack, x, y, width, height);
        return new ClosingScissorBox(bound.x(), bound.y(), bound.width(), bound.height());
    }

    public static CloseableScissorStack createScissorBoxStack(ScissorBoxStack scissorStack, Minecraft minecraft, PoseStack stack, int x, int y, int width, int height) {
        Bound bound = RenderUtils.getScissorBounds(minecraft, stack, x, y, width, height);
        return new CloseableScissorStack(scissorStack, bound.x(), bound.y(), bound.width(), bound.height());
    }
}

