/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.components.selection;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.scissor.ScissorBoxStack;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionList<T extends ListEntry>
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    private final List<T> entries = new ArrayList<T>();
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int itemHeight;
    private final Consumer<@Nullable T> onSelection;
    private final boolean relativeClicks;
    @Nullable
    private T selected;
    @Nullable
    private T hovered;
    private double scrollAmount;

    public SelectionList(int x, int y, int width, int height, int itemHeight, Consumer<@Nullable T> onSelection) {
        this(x, y, width, height, itemHeight, onSelection, false);
    }

    public SelectionList(int x, int y, int width, int height, int itemHeight, Consumer<@Nullable T> onSelection, boolean relativeClicks) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.itemHeight = itemHeight;
        this.onSelection = onSelection;
        this.relativeClicks = relativeClicks;
    }

    public void m_86412_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.hovered = this.getEntryAtPosition(mouseX, mouseY);
        try (CloseableScissorStack scissorStack = RenderUtils.createScissorBoxStack(new ScissorBoxStack(), Minecraft.m_91087_(), stack, this.x, this.y, this.width, this.height);){
            for (int i = 0; i < this.entries.size(); ++i) {
                int scrollY = this.y - (int)this.scrollAmount + i * this.itemHeight;
                if (scrollY + this.itemHeight < this.y || scrollY > this.y + this.height) continue;
                ListEntry entry = (ListEntry)this.entries.get(i);
                entry.render(scissorStack.stack(), stack, i, this.x, scrollY, this.width, this.itemHeight, mouseX, mouseY, this.isHoveredItem(i), partialTicks, this.isSelectedItem(i));
            }
        }
    }

    @NotNull
    public List<T> m_6702_() {
        return this.entries;
    }

    public void addEntry(@NotNull T entry) {
        this.entries.add(entry);
    }

    public boolean removeEntry(T entry) {
        boolean removed = this.entries.remove(entry);
        if (removed && entry == this.selected) {
            this.setSelected(null);
        }
        return removed;
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.selected, this.m_6702_().get(index));
    }

    protected boolean isHoveredItem(int index) {
        return Objects.equals(this.hovered, this.m_6702_().get(index));
    }

    @Nullable
    protected final T getEntryAtPosition(double mouseX, double mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        int index = Mth.m_14107_((double)(this.scrollAmount + (mouseY - (double)this.y))) / this.itemHeight;
        return (T)(index < 0 || index >= this.m_6702_().size() ? null : (ListEntry)this.m_6702_().get(index));
    }

    public void ensureVisible(T entry) {
        int k;
        int i = (int)((double)this.y - this.scrollAmount + (double)(this.m_6702_().indexOf(entry) * this.itemHeight));
        int j = i - this.y - this.itemHeight;
        if (j < 0) {
            this.setScrollAmount(this.scrollAmount + (double)j);
        }
        if ((k = this.y + this.height - i - this.itemHeight - this.itemHeight) < 0) {
            this.setScrollAmount(this.scrollAmount - (double)k);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX <= (double)(this.x + this.width) && mouseX >= (double)this.x && mouseY <= (double)(this.y + this.height) && mouseY >= (double)this.y;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        T entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            if (this.relativeClicks) {
                int scrollY = this.y - (int)this.scrollAmount + this.m_6702_().indexOf(entry) * this.itemHeight;
                mouseX -= (double)this.x;
                mouseY -= (double)scrollY;
            }
            if (entry.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)entry);
                this.m_7897_(true);
            }
            this.setSelected(entry);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.entries.size(); ++i) {
            int scrollY = this.y - (int)this.scrollAmount + i * this.itemHeight;
            ListEntry entry = (ListEntry)this.entries.get(i);
            if (!(this.relativeClicks ? entry.m_6348_(mouseX - (double)this.x, mouseY - (double)scrollY, button) : entry.m_6348_(mouseX, mouseY, button))) continue;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        this.setScrollAmount(this.scrollAmount - scrollAmount * (double)this.itemHeight / 2.0);
        return true;
    }

    public boolean m_7933_(int key, int point, int mod) {
        if (super.m_7933_(key, point, mod)) {
            return true;
        }
        if (key == 265 || key == 264) {
            if (!this.m_6702_().isEmpty()) {
                int clampedIndex;
                int index = this.m_6702_().indexOf(this.selected);
                if (index == (clampedIndex = Mth.m_14045_((int)(index + (key == 265 ? -1 : 1)), (int)0, (int)(this.entries.size() - 1)))) {
                    return true;
                }
                ListEntry entry = (ListEntry)this.m_6702_().get(clampedIndex);
                this.setSelected(entry);
                this.ensureVisible(entry);
            }
            return true;
        }
        return false;
    }

    public void setSelected(@Nullable T entry) {
        this.selected = entry;
        this.onSelection.accept(this.selected);
    }

    protected void setScrollAmount(double amount) {
        this.scrollAmount = Mth.m_14008_((double)amount, (double)0.0, (double)Math.max(0, this.entries.size() * this.itemHeight - this.height));
    }

    public void updateEntries(List<? extends T> entries) {
        this.scrollAmount = 0.0;
        this.selected = null;
        this.hovered = null;
        this.entries.clear();
        entries.forEach(this::addEntry);
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
    }

    public T getSelected() {
        return this.selected;
    }

    public T getHovered() {
        return this.hovered;
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }
}

