/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SpawnerRandomizingProcessor
extends StructureProcessor {
    public static final Codec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)BuiltInRegistries.f_256780_.m_194605_().fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("spawner_mob_entries").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.mainSpawnerData), (App)RegistryCodecs.m_206279_((ResourceKey)Registries.f_256939_, (Codec)BuiltInRegistries.f_256780_.m_194605_()).optionalFieldOf("override_mobs_to_pick_from").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.overrideMobsToPickFrom), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_to_override_with_tagged_mobs").orElse((Object)Float.valueOf(0.0f)).forGetter(spawnerRandomizingProcessor -> Float.valueOf(spawnerRandomizingProcessor.chanceToOverrideWithTaggedMobs))).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final List<Pair<EntityType<?>, Integer>> mainSpawnerData;
    public final Optional<HolderSet<EntityType<?>>> overrideMobsToPickFrom;
    public final float chanceToOverrideWithTaggedMobs;

    private SpawnerRandomizingProcessor(List<Pair<EntityType<?>, Integer>> mainSpawnerData, Optional<HolderSet<EntityType<?>>> overrideMobsToPickFrom, float chanceToOverrideWithTaggedMobs) {
        this.mainSpawnerData = mainSpawnerData;
        this.overrideMobsToPickFrom = overrideMobsToPickFrom;
        this.chanceToOverrideWithTaggedMobs = chanceToOverrideWithTaggedMobs;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.f_74676_.m_60734_() instanceof SpawnerBlock) {
            CompoundTag newSpawnerData;
            BlockPos worldPos = structureBlockInfoWorld.f_74675_;
            RandomSource randomSource = structurePlacementData.m_230326_(worldPos);
            if (this.overrideMobsToPickFrom.isPresent() && this.overrideMobsToPickFrom.get().m_203632_() > 0 && randomSource.m_188501_() < this.chanceToOverrideWithTaggedMobs) {
                newSpawnerData = this.SetMobSpawnerEntity((EntityType)this.overrideMobsToPickFrom.get().m_203662_(randomSource.m_188503_(this.overrideMobsToPickFrom.get().m_203632_())).m_203334_(), structureBlockInfoWorld.f_74677_);
            } else if (this.mainSpawnerData.size() > 0) {
                newSpawnerData = this.SetMobSpawnerEntity((EntityType)GeneralUtils.getRandomEntry(this.mainSpawnerData, randomSource), structureBlockInfoWorld.f_74677_);
            } else {
                return structureBlockInfoWorld;
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, structureBlockInfoWorld.f_74676_, newSpawnerData);
        }
        return structureBlockInfoWorld;
    }

    private CompoundTag SetMobSpawnerEntity(EntityType<?> entity, CompoundTag nbt) {
        if (entity != null) {
            if (nbt != null) {
                CompoundTag entityTag;
                CompoundTag spawnDataTag = nbt.m_128469_("SpawnData");
                if (spawnDataTag.m_128456_()) {
                    spawnDataTag = new CompoundTag();
                    nbt.m_128365_("SpawnData", (Tag)spawnDataTag);
                }
                if ((entityTag = nbt.m_128469_("entity")).m_128456_()) {
                    entityTag = new CompoundTag();
                    spawnDataTag.m_128365_("entity", (Tag)entityTag);
                }
                entityTag.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entity).toString());
                CompoundTag spawnEntityDataTag = new CompoundTag();
                spawnEntityDataTag.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entity).toString());
                CompoundTag spawnPotentialDataEntryTag = new CompoundTag();
                spawnPotentialDataEntryTag.m_128365_("entity", (Tag)spawnEntityDataTag);
                CompoundTag spawnPotentialEntryTag = new CompoundTag();
                spawnPotentialEntryTag.m_128365_("data", (Tag)spawnPotentialDataEntryTag);
                spawnPotentialEntryTag.m_128365_("weight", (Tag)IntTag.m_128679_((int)1));
                nbt.m_128365_("SpawnPotentials", (Tag)new ListTag());
                return nbt;
            }
            CompoundTag compound = new CompoundTag();
            compound.m_128376_("Delay", (short)20);
            compound.m_128376_("MinSpawnDelay", (short)200);
            compound.m_128376_("MaxSpawnDelay", (short)800);
            compound.m_128376_("SpawnCount", (short)4);
            compound.m_128376_("MaxNearbyEntities", (short)6);
            compound.m_128376_("RequiredPlayerRange", (short)16);
            compound.m_128376_("SpawnRange", (short)4);
            CompoundTag spawnDataEntity = new CompoundTag();
            spawnDataEntity.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entity).toString());
            CompoundTag spawnData = new CompoundTag();
            spawnData.m_128365_("entity", (Tag)spawnDataEntity);
            compound.m_128365_("SpawnData", (Tag)spawnData);
            CompoundTag entityData = new CompoundTag();
            entityData.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entity).toString());
            CompoundTag spawnPotentialData = new CompoundTag();
            spawnPotentialData.m_128365_("entity", (Tag)entityData);
            CompoundTag listEntry = new CompoundTag();
            listEntry.m_128365_("data", (Tag)spawnPotentialData);
            listEntry.m_128405_("weight", 1);
            compound.m_128365_("SpawnPotentials", (Tag)new ListTag());
            return compound;
        }
        return nbt;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.SPAWNER_RANDOMIZING_PROCESSOR.get();
    }
}

