/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class HoneycombHoleProcessor
extends StructureProcessor {
    public static final Codec<HoneycombHoleProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("flood_level").forGetter(config -> config.floodLevel)).apply((Applicative)instance, instance.stable(HoneycombHoleProcessor::new)));
    private final int floodLevel;

    private HoneycombHoleProcessor(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState placingState = structureBlockInfoWorld.f_74676_;
        BlockPos worldPos = structureBlockInfoWorld.f_74675_;
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_188584_(worldPos.m_121878_() * (long)worldPos.m_123342_());
        ChunkAccess chunk = worldView.m_46865_(structureBlockInfoWorld.f_74675_);
        BlockState checkedState = chunk.m_8055_(structureBlockInfoWorld.f_74675_);
        if (checkedState.m_60795_() || !checkedState.m_60819_().m_76178_()) {
            if (placingState.m_60795_() || placingState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
                if (!checkedState.m_60819_().m_76178_() || structureBlockInfoWorld.f_74675_.m_123342_() <= this.floodLevel) {
                    chunk.m_6978_(structureBlockInfoWorld.f_74675_, BzFluids.SUGAR_WATER_BLOCK.get().m_49966_(), false);
                    return null;
                }
            } else {
                return null;
            }
        }
        if (placingState.m_60713_(BzBlocks.HONEYCOMB_BROOD.get())) {
            if (random.m_188503_(5) < 2) {
                return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)placingState.m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.m_188503_(3))), null);
            }
            if (random.m_188503_(13) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)BzBlocks.EMPTY_HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)EmptyHoneycombBrood.f_52588_, (Comparable)((Direction)placingState.m_61143_((Property)HoneycombBrood.f_52588_))), null);
            }
            if (random.m_188503_(4) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50719_.m_49966_(), null);
        }
        if (placingState.m_60713_(Blocks.f_50719_) || placingState.m_60713_(BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            if (random.m_188503_(3) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50719_.m_49966_(), null);
        }
        if (placingState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            BlockState belowState = chunk.m_8055_(structureBlockInfoWorld.f_74675_.m_7495_());
            if (belowState.m_60795_() || !belowState.m_60819_().m_76178_()) {
                return null;
            }
            if (random.m_188503_(80) != 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50627_.m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)BzBlocks.PILE_OF_POLLEN.get().m_49966_().m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(random.m_188503_(3) + 1)), null);
        }
        if (placingState.m_60713_(Blocks.f_50720_) && random.m_188503_(3) != 0) {
            return new StructureTemplate.StructureBlockInfo(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), null);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.HONEYCOMB_HOLE_PROCESSOR.get();
    }
}

