/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BeeDungeonProcessor
extends StructureProcessor {
    public static final Codec<BeeDungeonProcessor> CODEC = Codec.unit(BeeDungeonProcessor::new);

    private BeeDungeonProcessor() {
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.f_74676_;
        BlockPos worldPos = structureBlockInfoWorld.f_74675_;
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_188584_(worldPos.m_121878_() * (long)worldPos.m_123342_());
        CompoundTag nbt = structureBlockInfoWorld.f_74677_;
        if (blockState.m_60713_(Blocks.f_50677_)) {
            String metadata = structureBlockInfoWorld.f_74677_.m_128461_("metadata");
            BlockState belowBlock = worldView.m_46865_(worldPos).m_8055_(worldPos);
            if (belowBlock.m_60795_()) {
                blockState = Blocks.f_50627_.m_49966_();
            } else {
                switch (metadata) {
                    case "center": {
                        if (random.m_188501_() < 0.1f) {
                            blockState = BzBlocks.HONEY_COCOON.get().m_49966_();
                            nbt = new CompoundTag();
                            nbt.m_128359_("LootTable", "the_bumblezone:structures/bee_dungeon");
                            break;
                        }
                        if (random.m_188501_() < 0.6f) {
                            blockState = BzBlocks.HONEY_CRYSTAL.get().m_49966_();
                            break;
                        }
                        if (random.m_188501_() < 0.6f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.m_188503_(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random.m_188503_(4) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                    case "inner_ring": {
                        if (random.m_188501_() < 0.35f) {
                            blockState = BzBlocks.HONEY_CRYSTAL.get().m_49966_();
                            break;
                        }
                        if (random.m_188501_() < 0.35f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.m_188503_(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random.m_188503_(random.m_188503_(4) + 1) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                    case "outer_ring": {
                        if (random.m_188501_() < 0.45f) {
                            blockState = BzBlocks.HONEY_CRYSTAL.get().m_49966_();
                            break;
                        }
                        if (random.m_188501_() < 0.2f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.m_188503_(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random.m_188503_(random.m_188503_(4) + 1) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                }
            }
        } else if (blockState.m_60713_(Blocks.f_50720_) || blockState.m_60713_(BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            boolean compatSuccess = false;
            for (ModCompat compat : ModChecker.DUNGEON_COMB_COMPATS) {
                if (!compat.checkCombSpawn(worldPos, (RandomSource)random, worldView, false)) continue;
                StructureTemplate.StructureBlockInfo info = compat.getHoneycomb(worldPos, (RandomSource)random, worldView, false);
                if (info != null) {
                    return info;
                }
                compatSuccess = true;
                break;
            }
            if (!compatSuccess) {
                blockState = random.m_188501_() < 0.4f ? Blocks.f_50720_.m_49966_() : BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_();
            }
        } else if (blockState.m_60713_(BzBlocks.HONEYCOMB_BROOD.get())) {
            blockState = random.m_188501_() < 0.6f ? (BlockState)((BlockState)BzBlocks.HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.m_188503_(3)))).m_61124_((Property)HoneycombBrood.f_52588_, (Comparable)((Direction)blockState.m_61143_((Property)HoneycombBrood.f_52588_))) : (random.m_188501_() < 0.2f ? Blocks.f_50719_.m_49966_() : BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_());
        } else if (blockState.m_60713_((Block)BzFluids.SUGAR_WATER_BLOCK.get()) && random.m_188501_() < 0.1f) {
            blockState = (BlockState)BzBlocks.HONEY_CRYSTAL.get().m_49966_().m_61124_((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.BEE_DUNGEON_PROCESSOR.get();
    }
}

