/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyWeb;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFeatures;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WebWall
extends Feature<NoneFeatureConfiguration> {
    public static final Map<Direction.Axis, Set<Direction>> AXIS_TO_FACINGS = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.Axis.class), map -> {
        map.put(Direction.Axis.X, ImmutableSet.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.UP, (Object)Direction.DOWN));
        map.put(Direction.Axis.Z, ImmutableSet.of((Object)Direction.EAST, (Object)Direction.WEST, (Object)Direction.UP, (Object)Direction.DOWN));
        map.put(Direction.Axis.Y, ImmutableSet.of((Object)Direction.EAST, (Object)Direction.WEST, (Object)Direction.NORTH, (Object)Direction.SOUTH));
    })));

    public WebWall(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos blockPos = new ChunkPos(context.m_159777_()).m_151394_(context.m_159777_().m_123342_());
        WorldGenLevel level = context.m_159774_();
        if (level.m_8055_(blockPos).m_60713_(Blocks.f_50627_)) {
            for (Direction.Axis axis : Direction.Axis.values()) {
                HashSet<BlockPos> validSpaces = new HashSet<BlockPos>();
                validSpaces.add(blockPos);
                boolean isInBounds = this.setIfValidSpace(level, axis, blockPos, blockPos, validSpaces);
                if (!isInBounds) continue;
                for (BlockPos validPos : validSpaces) {
                    for (int attempt = 0; attempt < 12; ++attempt) {
                        BzFeatures.STICKY_HONEY_RESIDUE_FEATURE.get().m_142674_(new FeaturePlaceContext(context.m_190935_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), validPos.m_7918_(context.m_225041_().m_188503_(9) - 4, context.m_225041_().m_188503_(9) - 4, context.m_225041_().m_188503_(9) - 4), (FeatureConfiguration)((NoneFeatureConfiguration)context.m_159778_())));
                    }
                    BlockState state = level.m_8055_(validPos);
                    if (state.m_60713_(BzBlocks.HONEY_WEB.get())) {
                        level.m_7731_(validPos, (BlockState)state.m_61124_((Property)HoneyWeb.AXIS_TO_PROP.get(axis), (Comparable)Boolean.valueOf(true)), 3);
                        continue;
                    }
                    level.m_7731_(validPos, (BlockState)BzBlocks.HONEY_WEB.get().m_49966_().m_61124_((Property)HoneyWeb.AXIS_TO_PROP.get(axis), (Comparable)Boolean.valueOf(true)), 3);
                }
                return true;
            }
        }
        return false;
    }

    private boolean setIfValidSpace(WorldGenLevel level, Direction.Axis axis, BlockPos originPos, BlockPos currentPos, Set<BlockPos> validSpaces) {
        int maxDistance = 14;
        for (Direction direction : AXIS_TO_FACINGS.get(axis)) {
            BlockPos newBlockPos = currentPos.m_121945_(direction);
            if (Math.abs(newBlockPos.m_123341_() - originPos.m_123341_()) > maxDistance || Math.abs(newBlockPos.m_123342_() - originPos.m_123342_()) > maxDistance || Math.abs(newBlockPos.m_123343_() - originPos.m_123343_()) > maxDistance) {
                return false;
            }
            if (validSpaces.contains(newBlockPos)) continue;
            BlockState state = level.m_8055_(newBlockPos);
            if (state.m_60795_() || state.m_60713_(BzBlocks.PILE_OF_POLLEN.get()) || state.m_60713_(BzBlocks.HONEY_WEB.get())) {
                validSpaces.add(newBlockPos);
                if (this.setIfValidSpace(level, axis, originPos, newBlockPos, validSpaces)) continue;
                return false;
            }
            if (!state.m_60713_(BzBlocks.HONEY_WEB.get())) continue;
            validSpaces.add(newBlockPos);
        }
        return true;
    }
}

