/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import com.telepathicgrunt.the_bumblezone.world.features.configs.NbtOreConfiguration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BlockEntityCombOre
extends Feature<NbtOreConfiguration> {
    private static final Map<ResourceKey<Level>, Map<Long, ChunkAccess>> CACHED_CHUNKS_ALL_WORLDS = new WeakHashMap<ResourceKey<Level>, Map<Long, ChunkAccess>>();

    public BlockEntityCombOre(Codec<NbtOreConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NbtOreConfiguration> context) {
        ModCompat compat;
        BlockPos.MutableBlockPos blockposMutable = new BlockPos.MutableBlockPos();
        float angleOfRotation = (float)(Math.PI * (double)context.m_225041_().m_188501_());
        float sinOfAngle = Mth.m_14031_((float)angleOfRotation);
        float cosOfAngle = Mth.m_14089_((float)angleOfRotation);
        float size = (float)((NbtOreConfiguration)context.m_159778_()).size * 0.5f;
        float stretchedFactor = 0.7f;
        if (((NbtOreConfiguration)context.m_159778_()).size < 10) {
            stretchedFactor = 1.0f;
        }
        int maxY = (int)(size / 3.0f);
        int minY = -maxY - 1;
        CompoundTag stateNbt = ((NbtOreConfiguration)context.m_159778_()).targetStates.get((int)0).stateNbt;
        OptionalBoolean data = OptionalBoolean.EMPTY;
        Iterator<ModCompat> iterator = ModChecker.COMB_ORE_COMPATS.iterator();
        while (iterator.hasNext() && !(data = (compat = iterator.next()).validateCombType(stateNbt)).isPresent()) {
        }
        if (data.isEmpty()) {
            return false;
        }
        for (int y = minY; y <= maxY; ++y) {
            float yModified = y;
            if (y < 0) {
                yModified = (float)y + 0.25f;
            } else if (y > 0) {
                y = (int)((float)y + 0.5f);
            }
            float percentageOfRadius = 1.0f - yModified / size * (yModified / size) * 3.0f;
            float majorRadiusSq = size * percentageOfRadius * (size * percentageOfRadius);
            float minorRadiusSq = size * stretchedFactor * percentageOfRadius * (size * stretchedFactor * percentageOfRadius);
            int x = (int)(-size);
            while ((float)x < size) {
                int z = (int)(-size);
                while ((float)z < size) {
                    float majorComp = ((float)x + 0.5f) * cosOfAngle - ((float)z + 0.5f) * sinOfAngle;
                    float minorComp = ((float)x + 0.5f) * sinOfAngle + ((float)z + 0.5f) * cosOfAngle;
                    float result = majorComp * majorComp / (majorRadiusSq * majorRadiusSq) + minorComp * minorComp / (minorRadiusSq * minorRadiusSq);
                    if (result * 100.0f < 1.0f && (x != 0 || z != 0 || !((float)(y * y) >= size * size))) {
                        blockposMutable.m_122178_(context.m_159777_().m_123341_() + x, context.m_159777_().m_123342_() + y, context.m_159777_().m_123343_() + z);
                        ChunkAccess cachedChunk = this.getCachedChunk((ServerLevelAccessor)context.m_159774_(), (BlockPos)blockposMutable);
                        BlockState blockToReplace = cachedChunk.m_8055_((BlockPos)blockposMutable);
                        for (NbtOreConfiguration.TargetBlockState targetBlockState : ((NbtOreConfiguration)context.m_159778_()).targetStates) {
                            if (!targetBlockState.target.m_213865_(blockToReplace, context.m_225041_())) continue;
                            cachedChunk.m_6978_((BlockPos)blockposMutable, targetBlockState.state, false);
                            BlockEntity blockentity = ((EntityBlock)targetBlockState.state.m_60734_()).m_142194_((BlockPos)blockposMutable, targetBlockState.state);
                            if (blockentity == null) {
                                return false;
                            }
                            blockentity.m_142466_(targetBlockState.stateNbt);
                            cachedChunk.m_142169_(blockentity);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return true;
    }

    public ChunkAccess getCachedChunk(ServerLevelAccessor world, BlockPos blockpos) {
        long posLong;
        ChunkAccess cachedChunk;
        ResourceKey worldKey = world.m_6018_().m_46472_();
        Map worldStorage = CACHED_CHUNKS_ALL_WORLDS.computeIfAbsent((ResourceKey<Level>)worldKey, k -> new WeakHashMap());
        if (worldStorage.size() > 9) {
            worldStorage.clear();
        }
        if ((cachedChunk = (ChunkAccess)worldStorage.get(posLong = (long)(blockpos.m_123341_() >> 4) & 0xFFFFFFFFL | ((long)(blockpos.m_123343_() >> 4) & 0xFFFFFFFFL) << 32)) == null) {
            cachedChunk = world.m_46865_(blockpos);
            worldStorage.put(posLong, cachedChunk);
        }
        return cachedChunk;
    }
}

