/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeBlobLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeMergeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePollinatedFieldsLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePollinatedPillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeScaleLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.Area;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.AreaFactory;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.AreaTransformer1;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.BigContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.Layer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyArea;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyAreaContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.ZoomLayer;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class BzBiomeProvider
extends BiomeSource
implements BiomeManager.NoiseBiomeSource {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElse((Object)0L).stable().forGetter(bzBiomeProvider -> bzBiomeProvider.seed), (App)Biome.f_47432_.fieldOf("blob_biomes").orElse((Object)HolderSet.m_205809_((Holder[])new Holder[0])).forGetter(biomeSource -> biomeSource.blobBiomes), (App)Biome.f_47432_.fieldOf("main_biomes").orElse((Object)HolderSet.m_205809_((Holder[])new Holder[0])).forGetter(biomeSource -> biomeSource.mainBiomes)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    public static ResourceLocation HIVE_WALL = new ResourceLocation("the_bumblezone", "hive_wall");
    public static ResourceLocation HIVE_PILLAR = new ResourceLocation("the_bumblezone", "hive_pillar");
    public static ResourceLocation SUGAR_WATER_FLOOR = new ResourceLocation("the_bumblezone", "sugar_water_floor");
    public static ResourceLocation POLLINATED_FIELDS = new ResourceLocation("the_bumblezone", "pollinated_fields");
    public static ResourceLocation POLLINATED_PILLAR = new ResourceLocation("the_bumblezone", "pollinated_pillar");
    public static ResourceLocation CRYSTAL_CANYON = new ResourceLocation("the_bumblezone", "crystal_canyon");
    private final long seed;
    private final Layer biomeSampler;
    public final HolderSet<Biome> blobBiomes;
    public final HolderSet<Biome> mainBiomes;
    public final GeneralUtils.Lazy<Set<Holder<Biome>>> lazyPossibleBiomes = new GeneralUtils.Lazy();

    public BzBiomeProvider(long seed, HolderSet<Biome> blobBiomes, HolderSet<Biome> mainBiomes) {
        this.seed = seed;
        this.blobBiomes = blobBiomes;
        this.mainBiomes = mainBiomes;
        this.biomeSampler = BzBiomeProvider.buildWorldProcedure(seed, this.blobBiomes);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return this.lazyPossibleBiomes.getOrCompute(() -> Stream.concat(this.blobBiomes.m_203614_(), this.mainBiomes.m_203614_()).collect(Collectors.toSet())).stream();
    }

    public Set<Holder<Biome>> m_207840_() {
        return this.lazyPossibleBiomes.getOrCompute(() -> Stream.concat(this.blobBiomes.m_203614_(), this.mainBiomes.m_203614_()).collect(Collectors.toSet()));
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> stack(long seed, AreaTransformer1 parent, AreaFactory<T> incomingArea, int count, LongFunction<C> contextFactory) {
        AreaFactory<T> LayerFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            LayerFactory = parent.run((BigContext)contextFactory.apply(seed + (long)i), LayerFactory);
        }
        return LayerFactory;
    }

    public static Layer buildWorldProcedure(long seed, HolderSet<Biome> blobBiomes) {
        AreaFactory<LazyArea> layerFactory = BzBiomeProvider.build(salt -> new LazyAreaContext(25, seed, salt), seed, blobBiomes);
        return new Layer(layerFactory);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> build(LongFunction<C> contextFactory, long seed, HolderSet<Biome> blobBiomes) {
        AreaFactory layer = new BzBiomeLayer(seed).run((BigContext)contextFactory.apply(200L));
        layer = new BzBiomePillarLayer().run((BigContext)contextFactory.apply(1008L), layer);
        layer = new BzBiomeScaleLayer(Set.of(HIVE_PILLAR)).run((BigContext)contextFactory.apply(1055L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2003L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2523L), layer);
        layer = new BzBiomeScaleLayer(Set.of(CRYSTAL_CANYON, SUGAR_WATER_FLOOR)).run((BigContext)contextFactory.apply(54088L), layer);
        AreaFactory layerOverlay = new BzBiomeBlobLayer(blobBiomes).run((BigContext)contextFactory.apply(204L));
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2423L), layerOverlay);
        layerOverlay = new BzBiomePollinatedPillarLayer().run((BigContext)contextFactory.apply(3008L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(Set.of(POLLINATED_PILLAR)).run((BigContext)contextFactory.apply(4455L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2503L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2603L), layerOverlay);
        layerOverlay = new BzBiomePollinatedFieldsLayer().run((BigContext)contextFactory.apply(3578L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(Set.of(POLLINATED_FIELDS)).run((BigContext)contextFactory.apply(4055L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2853L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(3583L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(4583L), layerOverlay);
        layer = new BzBiomeMergeLayer().run((BigContext)contextFactory.apply(5583L), layerOverlay, layer);
        return layer;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.biomeSampler.sample(x, z);
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        return this.biomeSampler.sample(x, z);
    }
}

