/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets.networking.forge;

import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannelHelperImpl {
    public static final Map<ResourceLocation, Channel> CHANNELS = new HashMap<ResourceLocation, Channel>();

    public static void registerChannel(ResourceLocation name, int protocolVersion) {
        String version = Integer.toString(protocolVersion);
        Channel channel = new Channel(0, NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> version, version::equals, version::equals));
        CHANNELS.put(name, channel);
    }

    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            Player player;
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            Object object = player = context.getSender() == null ? PacketChannelHelperImpl.getPlayer() : null;
            if (player != null) {
                context.enqueueWork(() -> handler.handle(msg).apply(player, player.f_19853_));
            }
            context.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            ServerPlayer player = context.getSender();
            if (player != null) {
                context.enqueueWork(() -> PacketChannelHelperImpl.lambda$registerC2SPacket$3(handler, msg, (Player)player));
            }
            context.setPacketHandled(true);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static <T extends Packet<T>> void sendToServer(ResourceLocation name, T packet) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        channel.channel.sendToServer(packet);
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation name, T packet, Player player) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            channel.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        }
    }

    private static /* synthetic */ void lambda$registerC2SPacket$3(PacketHandler handler, Packet msg, Player player) {
        handler.handle(msg).apply(player, player.f_19853_);
    }

    private static final class Channel {
        private int packets;
        private final SimpleChannel channel;

        private Channel(int packets, SimpleChannel channel) {
            this.packets = packets;
            this.channel = channel;
        }
    }
}

