/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketContext;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record MobEffectClientSyncPacket(int entityId, byte effectId, byte effectAmplifier, int effectDurationTicks, byte flags) implements Packet<MobEffectClientSyncPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("the_bumblezone", "mob_effect_client_sync");
    public static final Handler HANDLER = new Handler();
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;

    public MobEffectClientSyncPacket(int mobId, MobEffectInstance mobEffectInstance) {
        this(mobId, (byte)(MobEffect.m_19459_((MobEffect)mobEffectInstance.m_19544_()) & 0xFF), (byte)(mobEffectInstance.m_19564_() & 0xFF), Math.min(mobEffectInstance.m_19557_(), Short.MAX_VALUE), MobEffectClientSyncPacket.getFlags(mobEffectInstance));
    }

    private static byte getFlags(MobEffectInstance mobEffectInstance) {
        byte flags = 0;
        if (mobEffectInstance.m_19571_()) {
            flags = (byte)(flags | 1);
        }
        if (mobEffectInstance.m_19572_()) {
            flags = (byte)(flags | 2);
        }
        if (mobEffectInstance.m_19575_()) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }

    public static void sendToClient(Entity entity, MobEffectInstance mobEffectInstance) {
        MessageHandler.DEFAULT_CHANNEL.sendToAllLoaded(new MobEffectClientSyncPacket(entity.m_19879_(), mobEffectInstance), entity.f_19853_, entity.m_20183_());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<MobEffectClientSyncPacket> getHandler() {
        return HANDLER;
    }

    private static final class Handler
    implements PacketHandler<MobEffectClientSyncPacket> {
        private Handler() {
        }

        @Override
        public void encode(MobEffectClientSyncPacket message, FriendlyByteBuf buffer) {
            buffer.m_130130_(message.entityId);
            buffer.writeByte((int)message.effectId);
            buffer.writeByte((int)message.effectAmplifier);
            buffer.m_130130_(message.effectDurationTicks);
            buffer.writeByte((int)message.flags);
        }

        @Override
        public MobEffectClientSyncPacket decode(FriendlyByteBuf buffer) {
            return new MobEffectClientSyncPacket(buffer.m_130242_(), buffer.readByte(), buffer.readByte(), buffer.m_130242_(), buffer.readByte());
        }

        @Override
        public PacketContext handle(MobEffectClientSyncPacket message) {
            return (player, level) -> {
                MobEffect mobeffect;
                Entity entity = level.m_6815_(message.entityId());
                if (entity instanceof LivingEntity && (mobeffect = MobEffect.m_19453_((int)(message.effectId() & 0xFF))) != null) {
                    MobEffectInstance mobeffectinstance = new MobEffectInstance(mobeffect, message.effectDurationTicks(), (int)message.effectAmplifier(), message.isEffectAmbient(), message.isEffectVisible(), message.effectShowsIcon());
                    ((LivingEntity)entity).m_147215_(mobeffectinstance, null);
                }
            };
        }
    }
}

