/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketContext;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.screens.EnchantmentSkeleton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record CrystallineFlowerEnchantmentPacket(int containerId, List<EnchantmentSkeleton> enchantmentSkeletons) implements Packet<CrystallineFlowerEnchantmentPacket>
{
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation ID = new ResourceLocation("the_bumblezone", "crystalline_flower_enchantment");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(ServerPlayer player, int containerId, List<EnchantmentSkeleton> enchantmentSkeletons) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new CrystallineFlowerEnchantmentPacket(containerId, enchantmentSkeletons), (Player)player);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<CrystallineFlowerEnchantmentPacket> getHandler() {
        return HANDLER;
    }

    private static final class Handler
    implements PacketHandler<CrystallineFlowerEnchantmentPacket> {
        private Handler() {
        }

        @Override
        public void encode(CrystallineFlowerEnchantmentPacket message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.containerId());
            buffer.m_236828_(message.enchantmentSkeletons(), (buf, enchantmentSkeleton) -> buf.m_130070_(GSON.toJson(enchantmentSkeleton)));
        }

        @Override
        public CrystallineFlowerEnchantmentPacket decode(FriendlyByteBuf buffer) {
            return new CrystallineFlowerEnchantmentPacket(buffer.readInt(), buffer.m_236845_(buf -> (EnchantmentSkeleton)GSON.fromJson(buf.m_130277_(), EnchantmentSkeleton.class)));
        }

        @Override
        public PacketContext handle(CrystallineFlowerEnchantmentPacket message) {
            return (player, level) -> {
                if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_36096_.f_38840_ == message.containerId) {
                    CrystallineFlowerScreen.enchantmentsAvailable = message.enchantmentSkeletons();
                }
            };
        }
    }
}

