/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.forge.ProductiveBeesDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.util.Lazy;

public class ProductiveBeesCompat
implements ModCompat {
    private static final Lazy<List<String>> SPIDER_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        int primary = tag.m_128451_("primaryColor");
        return BzModCompatibilityConfigs.allowedCombsForDungeons.contains(e.getKey()) && tag.m_128471_("createComb") && (ProductiveBeesCompat.colorsAreClose(new Color(106, 127, 0), new Color(primary), 150) || ProductiveBeesCompat.colorsAreClose(new Color(129, 198, 0), new Color(primary), 150) || ProductiveBeesCompat.colorsAreClose(new Color(34, 45, 0), new Color(primary), 150));
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> BEE_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        return BzModCompatibilityConfigs.allowedCombsForDungeons.contains(e.getKey()) && tag.m_128471_("createComb") && !((List)SPIDER_DUNGEON_HONEYCOMBS.get()).contains(e.getKey());
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> ALL_BEES = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().keySet().stream().filter(e -> BzModCompatibilityConfigs.allowedBees.contains(e)).toList());
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("productivebees", "solitary_overworld_nests"));
    protected static Optional<Item> BEE_CAGE;
    protected static Optional<Item> STURDY_BEE_CAGE;

    public ProductiveBeesCompat() {
        BEE_CAGE = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("productivebees", "bee_cage"));
        STURDY_BEE_CAGE = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("productivebees", "sturdy_bee_cage"));
        if (BEE_CAGE.isPresent() && BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            ProductiveBeesDispenseBehavior.DEFAULT_BEE_CAGED_DISPENSE_BEHAVIOR = ((DispenserBlockInvoker)Blocks.f_50061_).invokeGetDispenseMethod(new ItemStack((ItemLike)BEE_CAGE.get()));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)BEE_CAGE.get()), (DispenseItemBehavior)new ProductiveBeesDispenseBehavior());
        }
        if (STURDY_BEE_CAGE.isPresent() && BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            ProductiveBeesDispenseBehavior.DEFAULT_STURDY_BEE_CAGED_DISPENSE_BEHAVIOR = ((DispenserBlockInvoker)Blocks.f_50061_).invokeGetDispenseMethod(new ItemStack((ItemLike)STURDY_BEE_CAGE.get()));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)STURDY_BEE_CAGE.get()), (DispenseItemBehavior)new ProductiveBeesDispenseBehavior());
        }
        ModChecker.productiveBeesPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS, ModCompat.Type.COMBS, ModCompat.Type.BLOCK_TELEPORT, ModCompat.Type.COMB_ORE, ModCompat.Type.EMPTY_BROOD);
    }

    private static boolean colorsAreClose(Color a, Color z, int threshold) {
        int b;
        int g;
        int r = a.getRed() - z.getRed();
        return r * r + (g = a.getGreen() - z.getGreen()) * g + (b = a.getBlue() - z.getBlue()) * b <= threshold * threshold;
    }

    @Override
    public boolean isValidBeeHiveForTeleportation(BlockState state) {
        if (state.m_60734_() instanceof ExpansionBox && state.m_61143_((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        if (state.m_204336_(SOLITARY_OVERWORLD_NESTS_TAG)) {
            return true;
        }
        return state.m_60734_() instanceof AdvancedBeehiveAbstract;
    }

    @Override
    public boolean onBeeSpawn(EntitySpawnEvent event, boolean isChild) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesBeesMob) {
            return false;
        }
        if ((double)event.entity().m_217043_().m_188501_() >= BzModCompatibilityConfigs.spawnrateOfProductiveBeesMobs) {
            return false;
        }
        if (event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowProductiveBeesSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        if (((List)ALL_BEES.get()).size() == 0) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        ConfigurableBee productiveBeeEntity = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(entity.f_19853_);
        if (productiveBeeEntity == null) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)entity.m_20183_());
        productiveBeeEntity.m_7678_((double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.5f), (double)((float)blockpos.m_123343_() + 0.5f), productiveBeeEntity.m_217043_().m_188501_() * 360.0f, 0.0f);
        productiveBeeEntity.m_6863_(isChild);
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)ALL_BEES.get()).get(productiveBeeEntity.m_217043_().m_188503_(((List)ALL_BEES.get()).size())));
        productiveBeeEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(productiveBeeEntity.m_20183_()), event.spawnType(), null, newTag);
        productiveBeeEntity.setBeeType(newTag.m_128461_("type"));
        world.m_7967_((Entity)productiveBeeEntity);
        return true;
    }

    @Override
    public OptionalBoolean validateCombType(CompoundTag tag) {
        CompoundTag productiveBeesData;
        if (tag.m_128441_("type") && (productiveBeesData = (CompoundTag)BeeReloadListener.INSTANCE.getData().get(tag.m_128461_("type"))) != null && productiveBeesData.m_128471_("createComb")) {
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.EMPTY;
    }

    @Override
    public boolean checkCombSpawn(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return (double)random.m_188501_() < BzModCompatibilityConfigs.PBOreHoneycombSpawnRateSpiderBeeDungeon;
        }
        return (double)random.m_188501_() < BzModCompatibilityConfigs.PBOreHoneycombSpawnRateBeeDungeon;
    }

    @Override
    public StructureTemplate.StructureBlockInfo getHoneycomb(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return ProductiveBeesCompat.PBGetRottenedHoneycomb(pos, random);
        }
        return ProductiveBeesCompat.PBGetRandomHoneycomb(pos, random);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRottenedHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants || ((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)SPIDER_DUNGEON_HONEYCOMBS.get()).get(random.m_188503_(((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRandomHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants || ((List)BEE_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)BEE_DUNGEON_HONEYCOMBS.get()).get(random.m_188503_(((List)BEE_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static boolean isFilledBeeCageItem(ItemStack stack) {
        return (BEE_CAGE.isPresent() && stack.m_150930_(BEE_CAGE.get()) || STURDY_BEE_CAGE.isPresent() && stack.m_150930_(STURDY_BEE_CAGE.get())) && !stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_("entity");
    }

    public static boolean isFilledBabyBeeCageItem(ItemStack stack) {
        return ProductiveBeesCompat.isFilledBeeCageItem(stack) && stack.m_41784_().m_128451_("Age") < 0;
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (ProductiveBeesCompat.isFilledBeeCageItem(itemstack) && !playerEntity.m_6047_()) {
            if (!playerEntity.m_150110_().f_35937_) {
                ItemStack itemToGive = ItemStack.f_41583_;
                if (STURDY_BEE_CAGE.isPresent() && itemstack.m_150930_(STURDY_BEE_CAGE.get())) {
                    itemToGive = STURDY_BEE_CAGE.get().m_7968_();
                } else if (BEE_CAGE.isPresent() && itemstack.m_150930_(BEE_CAGE.get())) {
                    itemToGive = BEE_CAGE.get().m_7968_();
                }
                GeneralUtils.givePlayerItem(playerEntity, playerHand, itemToGive, true, true);
            }
            return ProductiveBeesCompat.isFilledBabyBeeCageItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

