/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ResourcefulBeesCompat
implements ModCompat {
    public static final TagKey<Block> SPAWNS_IN_BEE_DUNGEONS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawns_in_bee_dungeons"));
    public static final TagKey<Block> SPAWNS_IN_SPIDER_INFESTED_BEE_DUNGEONS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawns_in_spider_infested_bee_dungeons"));
    public static final TagKey<EntityType<?>> SPAWNABLE_FROM_BROOD_BLOCK_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawnable_from_brood_block"));
    public static final TagKey<EntityType<?>> SPAWNABLE_FROM_CHUNK_CREATION_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("the_bumblezone", "resourcefulbees/spawnable_from_chunk_creation"));
    private static Optional<Item> BEE_JAR;

    public ResourcefulBeesCompat() {
        BEE_JAR = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("resourcefulbees", "bee_jar"));
        if (BEE_JAR.isPresent() && BzModCompatibilityConfigs.allowResourcefulBeesBeeJarRevivingEmptyBroodBlock) {
            ResourcefulBeesDispenseBehavior.DEFAULT_BOTTLED_BEE_DISPENSE_BEHAVIOR = ((DispenserBlockInvoker)Blocks.f_50061_).invokeGetDispenseMethod(new ItemStack((ItemLike)BEE_JAR.get()));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)BEE_JAR.get()), (DispenseItemBehavior)new ResourcefulBeesDispenseBehavior());
        }
        ModChecker.resourcefulBeesPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS, ModCompat.Type.COMBS, ModCompat.Type.EMPTY_BROOD);
    }

    @Override
    public boolean onBeeSpawn(EntitySpawnEvent event, boolean isBaby) {
        double spawnRate;
        if (!BzModCompatibilityConfigs.spawnResourcefulBeesBeesMob || event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowResourcefulBeesSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        double d = spawnRate = event.spawnType() == MobSpawnType.SPAWNER ? BzModCompatibilityConfigs.spawnrateOfResourcefulBeesMobsBrood : BzModCompatibilityConfigs.spawnrateOfResourcefulBeesMobsOther;
        if ((double)event.entity().m_217043_().m_188501_() >= spawnRate) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        Registry entityTypes = world.m_9598_().m_175515_(Registries.f_256939_);
        Optional optionalNamed = entityTypes.m_203431_(event.spawnType() == MobSpawnType.CHUNK_GENERATION ? SPAWNABLE_FROM_CHUNK_CREATION_TAG : SPAWNABLE_FROM_BROOD_BLOCK_TAG);
        if (optionalNamed.isEmpty()) {
            return false;
        }
        HolderSet.Named holders = (HolderSet.Named)optionalNamed.get();
        if (holders.m_203632_() == 0) {
            return false;
        }
        EntityType rbBeeType = (EntityType)holders.m_203662_(entity.m_217043_().m_188503_(holders.m_203632_())).m_203334_();
        Entity rbBeeUnchecked = rbBeeType.m_20615_(entity.m_9236_());
        if (rbBeeUnchecked instanceof Bee) {
            Bee rbBee = (Bee)rbBeeUnchecked;
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)entity.m_20183_());
            rbBee.m_7678_((double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.5f), (double)((float)blockpos.m_123343_() + 0.5f), rbBee.m_217043_().m_188501_() * 360.0f, 0.0f);
            rbBee.m_6863_(isBaby);
            rbBee.m_6518_((ServerLevelAccessor)world, world.m_6436_(rbBee.m_20183_()), event.spawnType(), null, null);
            world.m_7967_((Entity)rbBee);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkCombSpawn(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return (double)random.m_188501_() < BzModCompatibilityConfigs.RBOreHoneycombSpawnRateSpiderBeeDungeon;
        }
        return (double)random.m_188501_() < BzModCompatibilityConfigs.RBOreHoneycombSpawnRateBeeDungeon;
    }

    @Override
    public StructureTemplate.StructureBlockInfo getHoneycomb(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return ResourcefulBeesCompat.getRandomCombFromTag(pos, random, level, SPAWNS_IN_SPIDER_INFESTED_BEE_DUNGEONS_TAG);
        }
        return ResourcefulBeesCompat.getRandomCombFromTag(pos, random, level, SPAWNS_IN_BEE_DUNGEONS_TAG);
    }

    private static StructureTemplate.StructureBlockInfo getRandomCombFromTag(BlockPos worldPos, RandomSource random, LevelReader worldView, TagKey<Block> spawnsInBeeDungeonsTag) {
        if (worldView instanceof CommonLevelAccessor) {
            CommonLevelAccessor world = (CommonLevelAccessor)worldView;
            Registry blockRegistry = world.m_9598_().m_175515_(Registries.f_256747_);
            Optional optionalNamed = blockRegistry.m_203431_(spawnsInBeeDungeonsTag);
            if (optionalNamed.isEmpty()) {
                return null;
            }
            List<Block> holders = GeneralUtils.getListOfNonDummyBlocks(optionalNamed);
            if (holders.size() == 0) {
                return null;
            }
            Block rbComb = holders.get(random.m_188503_(random.m_188503_(holders.size()) + 1));
            return new StructureTemplate.StructureBlockInfo(worldPos, rbComb.m_49966_(), null);
        }
        return null;
    }

    public static boolean isFilledBeeJarItem(ItemStack stack) {
        return BEE_JAR.isPresent() && stack.m_150930_(BEE_JAR.get()) && !stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_("Entity") && stack.m_41784_().m_128469_("Entity").m_128441_("id");
    }

    public static boolean isFilledBabyBeeJarItem(ItemStack stack) {
        return ResourcefulBeesCompat.isFilledBeeJarItem(stack) && stack.m_41784_().m_128469_("Entity").m_128471_("isBaby");
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowResourcefulBeesBeeJarRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (ResourcefulBeesCompat.isFilledBeeJarItem(itemstack) && !playerEntity.m_6047_()) {
            if (!playerEntity.m_7500_()) {
                itemstack.m_41784_().m_128473_("Entity");
            }
            return ResourcefulBeesCompat.isFilledBabyBeeJarItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

