/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.GoodallBottledBeeDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;

public class GoodallCompat
implements ModCompat {
    private static Optional<Item> BOTTLED_BEE;

    public GoodallCompat() {
        BOTTLED_BEE = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("goodall", "bottled_bee"));
        if (BOTTLED_BEE.isPresent() && BzModCompatibilityConfigs.allowGoodallBottledBeesRevivingEmptyBroodBlock) {
            GoodallBottledBeeDispenseBehavior.DEFAULT_BOTTLED_BEE_DISPENSE_BEHAVIOR = ((DispenserBlockInvoker)Blocks.f_50061_).invokeGetDispenseMethod(new ItemStack((ItemLike)BOTTLED_BEE.get()));
            DispenserBlock.m_52672_((ItemLike)((ItemLike)BOTTLED_BEE.get()), (DispenseItemBehavior)new GoodallBottledBeeDispenseBehavior());
        }
        ModChecker.goodallPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.EMPTY_BROOD);
    }

    public static boolean isBottledBeesItem(ItemStack itemStack) {
        return BOTTLED_BEE.isPresent() && itemStack.m_150930_(BOTTLED_BEE.get());
    }

    public static boolean isBabyBottledBeesItem(ItemStack itemStack) {
        if (!GoodallCompat.isBottledBeesItem(itemStack) || !itemStack.m_41782_()) {
            return false;
        }
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128441_("BlockEntityTag") && compoundTag.m_128469_("BlockEntityTag").m_128441_("Entity") && compoundTag.m_128469_("BlockEntityTag").m_128469_("Entity").m_128451_("Age") < 0;
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowGoodallBottledBeesRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (GoodallCompat.isBottledBeesItem(itemstack) && !playerEntity.m_6047_()) {
            if (!playerEntity.m_7500_()) {
                playerEntity.m_21008_(playerHand, new ItemStack((ItemLike)Items.f_42590_));
            }
            return GoodallCompat.isBabyBottledBeesItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

