/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.IncenseCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.items.recipes.BzRecipeSerializer;
import com.telepathicgrunt.the_bumblezone.mixin.containers.ShapedRecipeAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2CharOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class IncenseCandleRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final int outputCount;
    private final int maxAllowedPotions;
    private final NonNullList<Ingredient> shapedRecipeItems;
    private final NonNullList<Ingredient> shapelessRecipeItems;
    private final ItemStack result;
    private final int width;
    private final int height;
    private final boolean allowNormalPotions;
    private final boolean allowSplashPotions;
    private final boolean allowLingeringPotions;
    private final int maxLevelCap;

    public IncenseCandleRecipe(ResourceLocation id, String group, int outputCount, int maxAllowedPotions, NonNullList<Ingredient> shapedRecipeItems, NonNullList<Ingredient> shapelessRecipeItems, int width, int height, boolean allowNormalPotions, boolean allowSplashPotions, boolean allowLingeringPotions, int maxLevelCap) {
        this.id = id;
        this.group = group;
        this.outputCount = outputCount;
        this.maxAllowedPotions = maxAllowedPotions;
        this.shapedRecipeItems = shapedRecipeItems;
        this.shapelessRecipeItems = shapelessRecipeItems;
        this.result = IncenseCandleRecipe.getResultStack(outputCount);
        this.width = width;
        this.height = height;
        this.allowNormalPotions = allowNormalPotions;
        this.allowSplashPotions = allowSplashPotions;
        this.allowLingeringPotions = allowLingeringPotions;
        this.maxLevelCap = maxLevelCap;
    }

    public int getMaxAllowedPotions() {
        return this.maxAllowedPotions;
    }

    public boolean getAllowNormalPotions() {
        return this.allowNormalPotions;
    }

    public boolean getAllowSplashPotions() {
        return this.allowSplashPotions;
    }

    public boolean getAllowLingeringPotions() {
        return this.allowLingeringPotions;
    }

    public int getMaxLevelCap() {
        return this.maxLevelCap;
    }

    public NonNullList<Ingredient> getShapedRecipeItems() {
        return this.shapedRecipeItems;
    }

    public NonNullList<Ingredient> getShapelessRecipeItems() {
        return this.shapelessRecipeItems;
    }

    private static ItemStack getResultStack(int outputCountIn) {
        ItemStack stack = BzItems.INCENSE_CANDLE.get().m_7968_();
        stack.m_41764_(outputCountIn);
        return stack;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ArrayList effects = new ArrayList();
        AtomicInteger maxDuration = new AtomicInteger();
        AtomicInteger amplifier = new AtomicInteger();
        AtomicInteger potionEffectsFound = new AtomicInteger();
        int splashCount = 0;
        int lingerCount = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (!itemStack.m_150930_(Items.f_42589_) && !itemStack.m_150930_(Items.f_42736_) && !itemStack.m_150930_(Items.f_42739_)) continue;
            PotionUtils.m_43547_((ItemStack)itemStack).forEach(me -> {
                effects.add(me.m_19544_());
                maxDuration.addAndGet(me.m_19544_().m_8093_() ? 200 : me.m_19557_());
                amplifier.addAndGet(me.m_19564_() + 1);
                potionEffectsFound.getAndIncrement();
            });
            if (itemStack.m_150930_(Items.f_42736_)) {
                ++splashCount;
            }
            if (!itemStack.m_150930_(Items.f_42739_)) continue;
            ++lingerCount;
        }
        if (effects.isEmpty()) {
            return IncenseCandleRecipe.getResultStack(this.outputCount);
        }
        HashSet setPicker = new HashSet(effects);
        List<MobEffect> filteredMobEffects = setPicker.stream().filter(e -> !GeneralUtils.isInTag(BuiltInRegistries.f_256974_, BzTags.DISALLOWED_INCENSE_CANDLE_EFFECTS, e)).toList();
        MobEffect chosenEffect = filteredMobEffects.get(new Random().nextInt(filteredMobEffects.size()));
        if (chosenEffect == null) {
            return IncenseCandleRecipe.getResultStack(this.outputCount);
        }
        IncenseCandleRecipe.balanceStats(chosenEffect, maxDuration, amplifier, potionEffectsFound);
        amplifier.set(Math.min(amplifier.get(), this.maxLevelCap));
        return IncenseCandleRecipe.createTaggedIncenseCandle(chosenEffect, maxDuration, amplifier, splashCount, lingerCount, this.outputCount);
    }

    public static void balanceStats(MobEffect chosenEffect, AtomicInteger maxDuration, AtomicInteger amplifier, AtomicInteger potionEffectsFound) {
        amplifier.set(amplifier.get() / potionEffectsFound.get());
        float durationBaseMultiplier = 0.4f / (0.9f * (float)potionEffectsFound.get()) + (float)amplifier.get() * 0.22f;
        float durationAdjustment = (float)potionEffectsFound.get() * durationBaseMultiplier;
        maxDuration.set((int)((float)maxDuration.get() / durationAdjustment));
        if (chosenEffect.m_8093_()) {
            long thresholdTime = IncenseCandleBlockEntity.getInstantEffectThresholdTime(amplifier.intValue());
            int activationAmounts = (int)Math.ceil((double)maxDuration.intValue() / (double)thresholdTime);
            maxDuration.set((int)((long)activationAmounts * thresholdTime));
        }
    }

    public static ItemStack createTaggedIncenseCandle(MobEffect chosenEffect, AtomicInteger maxDuration, AtomicInteger amplifier, int splashCount, int lingerCount, int outputCount) {
        ItemStack resultStack = IncenseCandleRecipe.getResultStack(outputCount);
        CompoundTag tag = resultStack.m_41784_();
        CompoundTag blockEntityTag = new CompoundTag();
        tag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
        blockEntityTag.m_128405_(IncenseCandleBlockEntity.COLOR_TAG, chosenEffect.m_19484_());
        blockEntityTag.m_128405_(IncenseCandleBlockEntity.AMPLIFIER_TAG, amplifier.intValue());
        blockEntityTag.m_128405_(IncenseCandleBlockEntity.MAX_DURATION_TAG, maxDuration.intValue());
        blockEntityTag.m_128359_(IncenseCandleBlockEntity.STATUS_EFFECT_TAG, BuiltInRegistries.f_256974_.m_7981_((Object)chosenEffect).toString());
        blockEntityTag.m_128379_(IncenseCandleBlockEntity.INFINITE_TAG, false);
        blockEntityTag.m_128405_(IncenseCandleBlockEntity.RANGE_TAG, 3 + splashCount * 2);
        if (chosenEffect.m_8093_()) {
            blockEntityTag.m_128405_(IncenseCandleBlockEntity.LINGER_TIME_TAG, 1);
        } else if (chosenEffect == MobEffects.f_19611_) {
            IncenseCandleRecipe.setLingerTime(lingerCount, blockEntityTag, 240);
        } else {
            IncenseCandleRecipe.setLingerTime(lingerCount, blockEntityTag, 60);
        }
        return resultStack;
    }

    private static void setLingerTime(int lingerCount, CompoundTag blockEntityTag, int baseLingerTime) {
        blockEntityTag.m_128405_(IncenseCandleBlockEntity.LINGER_TIME_TAG, baseLingerTime + lingerCount * baseLingerTime * 2);
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean shapedMatch = false;
        for (int column = 0; column <= inv.m_39347_() - this.width; ++column) {
            for (int row = 0; row <= inv.m_39346_() - this.height; ++row) {
                if (this.matches(inv, column, row, true)) {
                    shapedMatch = true;
                }
                if (!this.matches(inv, column, row, false)) continue;
                shapedMatch = true;
            }
        }
        return shapedMatch;
    }

    private boolean matches(CraftingContainer craftingInventory, int width, int height, boolean mirrored) {
        int potionCount = 0;
        ArrayList<ItemStack> secondaryIngredientsFound = new ArrayList<ItemStack>();
        ObjectArrayList mobEffects = new ObjectArrayList();
        for (int column = 0; column < craftingInventory.m_39347_(); ++column) {
            for (int row = 0; row < craftingInventory.m_39346_(); ++row) {
                ItemStack itemStack = craftingInventory.m_8020_(column + row * craftingInventory.m_39347_());
                int k = column - width;
                int l = row - height;
                Ingredient ingredient = null;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (Ingredient)this.shapedRecipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.shapedRecipeItems.get(k + l * this.width);
                }
                if (ingredient == null) {
                    if (itemStack.m_41619_()) continue;
                    if (itemStack.m_150930_(Items.f_42589_) || itemStack.m_150930_(Items.f_42736_) || itemStack.m_150930_(Items.f_42739_)) {
                        if (itemStack.m_150930_(Items.f_42589_) && !this.allowNormalPotions) {
                            return false;
                        }
                        if (itemStack.m_150930_(Items.f_42736_) && !this.allowSplashPotions) {
                            return false;
                        }
                        if (itemStack.m_150930_(Items.f_42739_) && !this.allowLingeringPotions) {
                            return false;
                        }
                        List currentMobEffects = PotionUtils.m_43547_((ItemStack)itemStack);
                        mobEffects.addAll(currentMobEffects);
                        if (currentMobEffects.isEmpty()) {
                            return false;
                        }
                        if (++potionCount <= this.maxAllowedPotions) continue;
                        return false;
                    }
                    secondaryIngredientsFound.add(itemStack);
                    continue;
                }
                if (ingredient.test(itemStack)) continue;
                return false;
            }
        }
        if (mobEffects.stream().allMatch(e -> GeneralUtils.isInTag(BuiltInRegistries.f_256974_, BzTags.DISALLOWED_INCENSE_CANDLE_EFFECTS, e.m_19544_()))) {
            return false;
        }
        return potionCount > 0 && GeneralUtils.listMatches(secondaryIngredientsFound, this.shapelessRecipeItems);
    }

    public RecipeSerializer<?> m_7707_() {
        return BzRecipes.INCENSE_CANDLE_RECIPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll(this.shapelessRecipeItems);
        ingredients.addAll(this.shapedRecipeItems);
        return ingredients;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<IncenseCandleRecipe>,
    BzRecipeSerializer<IncenseCandleRecipe> {
        private static NonNullList<Ingredient> getIngredients(JsonArray jsonElements) {
            NonNullList defaultedList = NonNullList.m_122779_();
            for (int i = 0; i < jsonElements.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElements.get(i));
                if (ingredient.m_43947_()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public IncenseCandleRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = ShapedRecipeAccessor.callKeyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = ShapedRecipeAccessor.callShrink(ShapedRecipeAccessor.callPatternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = astring[0].length();
            int height = astring.length;
            NonNullList<Ingredient> shapedRecipeItems = ShapedRecipeAccessor.callDissolvePattern(astring, map, width, height);
            NonNullList<Ingredient> shapelessRecipeItems = Serializer.getIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"shapelessExtraIngredients"));
            if (shapelessRecipeItems.isEmpty()) {
                throw new JsonParseException("No shapeless ingredients for Super Incense Candle recipe");
            }
            int maxPotions = json.get("maxAllowedPotions").getAsInt();
            boolean allowNormalPotionsRead = json.get("allowNormalPotions").getAsBoolean();
            boolean allowSplashPotionsRead = json.get("allowSplashPotions").getAsBoolean();
            boolean allowLingeringPotionsRead = json.get("allowLingeringPotions").getAsBoolean();
            int maxLevelRead = json.get("maxLevelCap").getAsInt();
            int resultCount = json.get("resultCount").getAsInt();
            return new IncenseCandleRecipe(recipeId, group, resultCount, maxPotions, shapedRecipeItems, shapelessRecipeItems, width, height, allowNormalPotionsRead, allowSplashPotionsRead, allowLingeringPotionsRead, maxLevelRead);
        }

        @Override
        public JsonObject toJson(IncenseCandleRecipe recipe) {
            JsonObject json = new JsonObject();
            json.addProperty("type", BuiltInRegistries.f_256769_.m_7981_(BzRecipes.INCENSE_CANDLE_RECIPE.get()).toString());
            json.addProperty("group", recipe.group);
            NonNullList<Ingredient> recipeIngredients = recipe.shapedRecipeItems;
            Object2CharOpenHashMap ingredients = new Object2CharOpenHashMap();
            Char2ObjectOpenHashMap inputs = new Char2ObjectOpenHashMap();
            ingredients.defaultReturnValue(' ');
            char currentChar = 'A';
            for (Ingredient ingredient : recipeIngredients) {
                if (ingredient.m_43947_() || ingredients.putIfAbsent((Object)ingredient, currentChar) != ingredients.defaultReturnValue()) continue;
                inputs.putIfAbsent(currentChar, (Object)ingredient);
                currentChar = (char)(currentChar + '\u0001');
            }
            ArrayList<String> pattern = new ArrayList<String>();
            StringBuilder patternLine = new StringBuilder();
            for (int i = 0; i < recipeIngredients.size(); ++i) {
                if (i != 0 && i % recipe.getWidth() == 0) {
                    pattern.add(patternLine.toString());
                    patternLine.setLength(0);
                }
                Ingredient ingredient = (Ingredient)recipeIngredients.get(i);
                patternLine.append(ingredients.getChar((Object)ingredient));
            }
            pattern.add(patternLine.toString());
            JsonArray jsonArray = new JsonArray();
            for (String string : pattern) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : inputs.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), ((Ingredient)entry.getValue()).m_43942_());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonArray shapelessRecipeJsonArray = new JsonArray();
            recipe.shapelessRecipeItems.stream().map(Ingredient::m_43942_).forEach(arg_0 -> ((JsonArray)shapelessRecipeJsonArray).add(arg_0));
            json.add("shapelessExtraIngredients", (JsonElement)shapelessRecipeJsonArray);
            json.addProperty("maxAllowedPotions", (Number)recipe.maxAllowedPotions);
            json.addProperty("allowNormalPotions", Boolean.valueOf(recipe.allowNormalPotions));
            json.addProperty("allowSplashPotions", Boolean.valueOf(recipe.allowSplashPotions));
            json.addProperty("allowLingeringPotions", Boolean.valueOf(recipe.allowLingeringPotions));
            json.addProperty("maxLevelCap", (Number)recipe.maxLevelCap);
            json.addProperty("resultCount", (Number)recipe.result.m_41613_());
            return json;
        }

        public IncenseCandleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList shapedRecipe = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            shapedRecipe.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            int ingredientCount = buffer.m_130242_();
            NonNullList shapelessRecipe = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            shapelessRecipe.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            int maxPotionRead = buffer.m_130242_();
            boolean allowNormalPotionsRead = buffer.readBoolean();
            boolean allowSplashPotionsRead = buffer.readBoolean();
            boolean allowLingeringPotionsRead = buffer.readBoolean();
            int maxLevelRead = buffer.m_130242_();
            int resultCountRead = buffer.m_130242_();
            return new IncenseCandleRecipe(recipeId, group, resultCountRead, maxPotionRead, (NonNullList<Ingredient>)shapedRecipe, (NonNullList<Ingredient>)shapelessRecipe, width, height, allowNormalPotionsRead, allowSplashPotionsRead, allowLingeringPotionsRead, maxLevelRead);
        }

        public void toNetwork(FriendlyByteBuf buffer, IncenseCandleRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            for (Ingredient ingredient : recipe.shapedRecipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.shapelessRecipeItems.size());
            for (Ingredient ingredient : recipe.shapelessRecipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.maxAllowedPotions);
            buffer.writeBoolean(recipe.allowNormalPotions);
            buffer.writeBoolean(recipe.allowSplashPotions);
            buffer.writeBoolean(recipe.allowLingeringPotions);
            buffer.m_130130_(recipe.maxLevelCap);
            buffer.m_130130_(recipe.outputCount);
        }
    }
}

