/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.fluids.base.BzBucketItem;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BzCustomBucketItem
extends BzBucketItem {
    public final Fluid fluid;

    public BzCustomBucketItem(FluidInfo info, Item.Properties builder) {
        super(info, builder);
        this.fluid = info.source().m_5613_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        BlockHitResult raytraceresult;
        InteractionResultHolder<ItemStack> specialActionResult = PlatformHooks.performItemUse(world, playerEntity, hand, this.fluid, this);
        if (specialActionResult.m_19089_() != InteractionResult.PASS) {
            return specialActionResult;
        }
        InteractionResultHolder actionResult = super.m_7203_(world, playerEntity, hand);
        if (this.getFluid() == BzFluids.SUGAR_WATER_FLUID.get() && actionResult.m_19089_() == InteractionResult.CONSUME && playerEntity instanceof ServerPlayer && (raytraceresult = BzCustomBucketItem.m_41435_((Level)world, (Player)playerEntity, (ClipContext.Fluid)ClipContext.Fluid.NONE)).m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.m_82425_();
            Direction direction = raytraceresult.m_82434_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos blockpos2 = this.canBlockContainFluid(world, blockpos, blockstate) ? blockpos : blockpos1;
            boolean isNextToSugarCane = false;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction directionOffset : Direction.Plane.HORIZONTAL) {
                mutable.m_122190_((Vec3i)blockpos2).m_122173_(directionOffset).m_122173_(Direction.UP);
                BlockState state = world.m_8055_((BlockPos)mutable);
                if (!state.m_60713_(Blocks.f_50130_)) continue;
                isNextToSugarCane = true;
                break;
            }
            if (isNextToSugarCane) {
                BzCriterias.SUGAR_WATER_NEXT_TO_SUGAR_CANE_TRIGGER.trigger((ServerPlayer)playerEntity);
            }
        }
        return actionResult;
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && (((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, (Fluid)this.getFluid()) || ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, (Fluid)Fluids.f_76193_));
    }

    @PlatformOnly(value={"forge"})
    public boolean emptyContents(@Nullable Player player, Level world, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        return this.m_142073_(player, world, pos, hitResult);
    }

    public boolean m_142073_(@Nullable Player player, Level world, BlockPos pos, @Nullable BlockHitResult hitResult) {
        if (!(this.fluid instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        Material material = blockState.m_60767_();
        boolean canBucketPlace = blockState.m_60722_(this.fluid);
        boolean canPlaceFluid = blockState.m_60795_() || canBucketPlace;
        boolean feedVanillaWaterOverride = false;
        if (block instanceof LiquidBlockContainer) {
            if (((LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, blockState, this.fluid)) {
                canPlaceFluid = true;
            }
            if (this.fluid.m_205067_(FluidTags.f_13131_) && ((LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, blockState, (Fluid)Fluids.f_76193_)) {
                canPlaceFluid = true;
                feedVanillaWaterOverride = true;
            }
        }
        if (!canPlaceFluid) {
            return hitResult != null && this.m_142073_(player, world, hitResult.m_82425_().m_121945_(hitResult.m_82434_()), null);
        }
        if (world.m_6042_().f_63857_() && this.fluid.m_205067_(FluidTags.f_13131_)) {
            double x = pos.m_123341_();
            double y = pos.m_123342_();
            double z = pos.m_123343_();
            world.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + Math.random(), y + Math.random(), z + Math.random(), 0.0, 0.0, 0.0);
            }
            if (this.fluid.m_205067_(BzTags.SUGAR_WATER_FLUID) && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                if (world.m_7654_() != null) {
                    Vec3 targetPos = hitResult != null ? hitResult.m_82450_() : new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    LootTable sugarWaterEvaporateLootTable = world.m_7654_().m_129898_().m_79217_(new ResourceLocation("the_bumblezone", "fluids/sugar_water_evaporates"));
                    LootContext.Builder contextBuilder = new LootContext.Builder(serverLevel).m_230911_(serverLevel.f_46441_);
                    ObjectArrayList evaporateItems = sugarWaterEvaporateLootTable.m_230922_(contextBuilder.m_78975_(sugarWaterEvaporateLootTable.m_79122_()));
                    for (ItemStack itemStackToSpawn : evaporateItems) {
                        ItemEntity itementity = new ItemEntity(world, targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), itemStackToSpawn);
                        itementity.m_32060_();
                        world.m_7967_((Entity)itementity);
                    }
                }
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && this.fluid.m_205067_(FluidTags.f_13131_)) {
            if (feedVanillaWaterOverride) {
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, pos, blockState, Fluids.f_76193_.m_76068_(false));
            } else {
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, pos, blockState, ((FlowingFluid)this.fluid).m_76068_(false));
            }
            this.m_7718_(player, (LevelAccessor)world, pos);
            return true;
        }
        if (!world.f_46443_ && canBucketPlace && !material.m_76332_()) {
            world.m_46961_(pos, true);
        }
        if (!world.m_7731_(pos, this.fluid.m_76145_().m_76188_(), 11) && !blockState.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(player, (LevelAccessor)world, pos);
        return true;
    }
}

