/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.forge;

import com.telepathicgrunt.the_bumblezone.client.BumblezoneClient;
import com.telepathicgrunt.the_bumblezone.client.DimensionTeleportingScreen;
import com.telepathicgrunt.the_bumblezone.client.forge.ForgeConnectedBlockModel;
import com.telepathicgrunt.the_bumblezone.client.forge.ForgeConnectedModelLoader;
import com.telepathicgrunt.the_bumblezone.events.client.BlockRenderedOnScreenEvent;
import com.telepathicgrunt.the_bumblezone.events.client.ClientTickEvent;
import com.telepathicgrunt.the_bumblezone.events.client.KeyInputEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterBlockColorEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterClientFluidPropertiesEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterDimensionEffectsEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEffectRenderersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEntityLayersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEntityRenderersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterItemColorEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterItemPropertiesEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterKeyMappingEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterMenuScreenEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterParticleEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterRenderTypeEvent;
import com.telepathicgrunt.the_bumblezone.items.DispenserAddedSpawnEgg;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.registry.RegistryEntry;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.util.TriConsumer;

public class BumblezoneForgeClient {
    public static void init() {
        BumblezoneClient.init();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(BumblezoneForgeClient::onBlockScreen);
        forgeBus.addListener(BumblezoneForgeClient::onKeyInput);
        forgeBus.addListener(BumblezoneForgeClient::onClientTick);
        forgeBus.addListener(BumblezoneForgeClient::onScreenRendering);
        modBus.addListener(BumblezoneForgeClient::onClientSetup);
        modBus.addListener(BumblezoneForgeClient::onRegisterModelLoaders);
        modBus.addListener(BumblezoneForgeClient::onRegisterParticles);
        modBus.addListener(ForgeConnectedBlockModel::onBakingCompleted);
        modBus.addListener(BumblezoneForgeClient::onRegisterKeys);
        modBus.addListener(BumblezoneForgeClient::onRegisterItemColors);
        modBus.addListener(BumblezoneForgeClient::onRegisterBlockColors);
        modBus.addListener(BumblezoneForgeClient::onRegisterEntityRenderers);
        modBus.addListener(BumblezoneForgeClient::onEntityLayers);
        modBus.addListener(BumblezoneForgeClient::onRegisterDimensionEffects);
        RegisterClientFluidPropertiesEvent.EVENT.invoke(new RegisterClientFluidPropertiesEvent((info, properties) -> {}));
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            RegisterEffectRenderersEvent.EVENT.invoke(RegisterEffectRenderersEvent.INSTANCE);
            RegisterRenderTypeEvent.EVENT.invoke(new RegisterRenderTypeEvent(ItemBlockRenderTypes::setRenderLayer, ItemBlockRenderTypes::setRenderLayer));
            RegisterMenuScreenEvent.EVENT.invoke(new RegisterMenuScreenEvent(BumblezoneForgeClient::registerScreen));
            RegisterItemPropertiesEvent.EVENT.invoke(new RegisterItemPropertiesEvent((TriConsumer<Item, ResourceLocation, ClampedItemPropertyFunction>)((TriConsumer)ItemProperties::register)));
        });
    }

    private static <M extends AbstractContainerMenu, U extends Screen> void registerScreen(MenuType<? extends M> arg, RegisterMenuScreenEvent.ScreenConstructor<M, U> arg2) {
        MenuScreens.m_96206_(arg, arg2::create);
    }

    private static void onRegisterKeys(RegisterKeyMappingsEvent event) {
        RegisterKeyMappingEvent.EVENT.invoke(new RegisterKeyMappingEvent(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0)));
    }

    private static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        RegisterItemColorEvent.EVENT.invoke(new RegisterItemColorEvent((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Item)event).register(arg_0, arg_1), (arg_0, arg_1, arg_2, arg_3) -> ((BlockColors)event.getBlockColors()).m_92577_(arg_0, arg_1, arg_2, arg_3)));
        BzItems.ITEMS.stream().map(RegistryEntry::get).filter(item -> item instanceof DispenserAddedSpawnEgg).map(item -> (DispenserAddedSpawnEgg)((Object)item)).forEach(item -> event.register((stack, index) -> item.m_43211_(index), new ItemLike[]{item}));
    }

    private static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        RegisterBlockColorEvent.EVENT.invoke(new RegisterBlockColorEvent((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)event).register(arg_0, arg_1)));
    }

    private static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        RegisterEntityRenderersEvent.EVENT.invoke(new RegisterEntityRenderersEvent((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1)));
    }

    private static void onEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        RegisterEntityLayersEvent.EVENT.invoke(new RegisterEntityLayersEvent((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1)));
    }

    private static void onRegisterDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        RegisterDimensionEffectsEvent.EVENT.invoke(new RegisterDimensionEffectsEvent((arg_0, arg_1) -> ((RegisterDimensionSpecialEffectsEvent)event).register(arg_0, arg_1)));
    }

    private static void onKeyInput(InputEvent.Key event) {
        KeyInputEvent.EVENT.invoke(new KeyInputEvent(event.getKey(), event.getScanCode(), event.getAction()));
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientTickEvent.EVENT.invoke(new ClientTickEvent(event.phase == TickEvent.Phase.END));
    }

    public static void onBlockScreen(RenderBlockScreenEffectEvent event) {
        BlockRenderedOnScreenEvent.Type type = switch (event.getOverlayType()) {
            default -> throw new IncompatibleClassChangeError();
            case RenderBlockScreenEffectEvent.OverlayType.BLOCK -> BlockRenderedOnScreenEvent.Type.BLOCK;
            case RenderBlockScreenEffectEvent.OverlayType.FIRE -> BlockRenderedOnScreenEvent.Type.FIRE;
            case RenderBlockScreenEffectEvent.OverlayType.WATER -> BlockRenderedOnScreenEvent.Type.WATER;
        };
        BlockRenderedOnScreenEvent.EVENT.invoke(new BlockRenderedOnScreenEvent(event.getPlayer(), event.getPoseStack(), type, event.getBlockState(), event.getBlockPos()));
    }

    public static void onRegisterModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("connected_block", (IGeometryLoader)new ForgeConnectedModelLoader());
    }

    public static void onRegisterParticles(RegisterParticleProvidersEvent event) {
        RegisterParticleEvent.EVENT.invoke(new RegisterParticleEvent(BumblezoneForgeClient.registerParticle(event)));
    }

    private static RegisterParticleEvent.Registrar registerParticle(final RegisterParticleProvidersEvent event) {
        return new RegisterParticleEvent.Registrar(){

            @Override
            public <T extends ParticleOptions> void register(ParticleType<T> type, Function<SpriteSet, ParticleProvider<T>> registration) {
                event.registerSpriteSet(type, registration::apply);
            }
        };
    }

    public static void onScreenRendering(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof ReceivingLevelScreen) {
            ReceivingLevelScreen receivingLevelScreen = (ReceivingLevelScreen)screen;
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_19853_.m_46472_() == BzDimension.BZ_WORLD_KEY) {
                DimensionTeleportingScreen.renderScreenAndText(receivingLevelScreen, event.getPoseStack());
                event.setCanceled(true);
            }
        }
    }
}

