/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids.base;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ClientFluidProperties {
    private static final Map<ResourceLocation, ClientFluidProperties> PROPERTIES = new HashMap<ResourceLocation, ClientFluidProperties>();
    private ModifyFogColor modifyFogColor = null;
    private ModifyFog modifyFog = null;
    private FluidOverlay fluidOverlay = null;
    private TriFunction<@Nullable FluidState, @Nullable BlockAndTintGetter, @Nullable BlockPos, Integer> tintColor = (state, level, pos) -> -1;
    private ResourceLocation still;
    private ResourceLocation flowing;
    private ResourceLocation overlay;

    public ClientFluidProperties(FluidProperties properties) {
        this(properties.id());
    }

    public ClientFluidProperties(ResourceLocation id) {
        PROPERTIES.put(id, this);
    }

    public ClientFluidProperties modifyFogColor(ModifyFogColor modifyFogColor) {
        this.modifyFogColor = modifyFogColor;
        return this;
    }

    public ClientFluidProperties modifyFog(ModifyFog modifyFog) {
        this.modifyFog = modifyFog;
        return this;
    }

    public ClientFluidProperties tintColor(int tintColor) {
        this.tintColor = (state, level, pos) -> tintColor;
        return this;
    }

    public ClientFluidProperties tintColor(TriFunction<@Nullable FluidState, @Nullable BlockAndTintGetter, @Nullable BlockPos, Integer> tintColor) {
        this.tintColor = tintColor;
        return this;
    }

    public ClientFluidProperties still(ResourceLocation still) {
        this.still = still;
        return this;
    }

    public ClientFluidProperties flowing(ResourceLocation flowing) {
        this.flowing = flowing;
        return this;
    }

    public ClientFluidProperties overlay(ResourceLocation overlay) {
        this.overlay = overlay;
        return this;
    }

    public ClientFluidProperties screenOverlay(ResourceLocation screenOverlay) {
        this.fluidOverlay = (mc, stack) -> {
            if (mc.f_91074_ == null) {
                return;
            }
            ClientFluidProperties.bz$renderFluid((Player)mc.f_91074_, stack, screenOverlay);
        };
        return this;
    }

    public ClientFluidProperties screenOverlay(BiConsumer<Player, PoseStack> fluidOverlay) {
        this.fluidOverlay = (mc, stack) -> {
            if (mc.f_91074_ == null) {
                return;
            }
            fluidOverlay.accept((Player)mc.f_91074_, stack);
        };
        return this;
    }

    public static ClientFluidProperties get(ResourceLocation id) {
        return PROPERTIES.get(id);
    }

    public ResourceLocation still() {
        return this.still;
    }

    public ResourceLocation flowing() {
        return this.flowing;
    }

    public ResourceLocation overlay() {
        return this.overlay;
    }

    public void fluidOverlay(Minecraft mc, PoseStack stack) {
        if (this.fluidOverlay != null) {
            this.fluidOverlay.render(mc, stack);
        }
    }

    public int tintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return (Integer)this.tintColor.apply((Object)state, (Object)getter, (Object)pos);
    }

    public Optional<Vector3f> modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
        if (this.modifyFogColor != null) {
            return Optional.of(this.modifyFogColor.modify(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor));
        }
        return Optional.empty();
    }

    public void modifyFog(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
        if (this.modifyFog != null) {
            this.modifyFog.modify(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
        }
    }

    private static void bz$renderFluid(@NotNull Player player, PoseStack pPoseStack, ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        BlockPos blockpos = BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_());
        float f = LightTexture.m_234316_((DimensionType)player.f_19853_.m_6042_(), (int)player.f_19853_.m_46803_(blockpos));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)f, (float)f, (float)f, (float)0.1f);
        float f7 = -player.m_146908_() / 64.0f;
        float f8 = player.m_146909_() / 64.0f;
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + f7, 4.0f + f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + f7, 4.0f + f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(0.0f + f7, 0.0f + f8).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + f7, 0.0f + f8).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69461_();
    }

    @FunctionalInterface
    public static interface ModifyFogColor {
        public Vector3f modify(Camera var1, float var2, ClientLevel var3, int var4, float var5, Vector3f var6);
    }

    @FunctionalInterface
    public static interface ModifyFog {
        public void modify(Camera var1, FogRenderer.FogMode var2, float var3, float var4, float var5, float var6, FogShape var7);
    }

    @FunctionalInterface
    public static interface FluidOverlay {
        public void render(Minecraft var1, PoseStack var2);
    }
}

