/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.fluids.base.BzFlowingFluid;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FlowingFluidAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class HoneyFluid
extends BzFlowingFluid {
    protected HoneyFluid(FluidInfo properties, boolean source) {
        super(properties, source);
    }

    @Override
    public Fluid m_5615_() {
        return (Fluid)BzFluids.HONEY_FLUID_FLOWING.get();
    }

    @Override
    public Fluid m_5613_() {
        return (Fluid)BzFluids.HONEY_FLUID.get();
    }

    @Override
    public Item m_6859_() {
        return BzItems.HONEY_BUCKET.get();
    }

    public void m_213811_(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        float fluidHeightPercent = Math.min(1.0f, (float)(state.m_76170_() ? 8 : (Integer)state.m_61143_((Property)f_75948_)) / 7.0f);
        float fluidBottomOffset = Math.min(1.0f, (float)(state.m_76170_() ? 0 : (Integer)state.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL)) / 7.0f);
        if (random.m_188503_(82) == 0) {
            worldIn.m_7106_((ParticleOptions)BzParticles.HONEY_PARTICLE.get(), (double)((float)pos.m_123341_() + random.m_188501_()), (double)((float)pos.m_123342_() + fluidBottomOffset + random.m_188501_() * (fluidHeightPercent - fluidBottomOffset)), (double)((float)pos.m_123343_() + random.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions m_7792_() {
        return (ParticleOptions)BzParticles.HONEY_PARTICLE.get();
    }

    @Override
    protected float m_6752_() {
        return 120.0f;
    }

    @Override
    protected void m_7456_(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? world.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    @Override
    public int m_6719_(LevelReader world) {
        return 4;
    }

    @Override
    public int m_6713_(LevelReader world) {
        return 1;
    }

    @Override
    public int m_6718_(LevelReader world) {
        return 30;
    }

    @Override
    public boolean m_6212_(Fluid fluid) {
        return fluid.m_205067_(BzTags.VISUAL_HONEY_FLUID);
    }

    @Override
    public boolean m_5486_(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.m_205067_(FluidTags.f_13131_);
    }

    @Override
    public BlockState m_5804_(FluidState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)BzFluids.HONEY_FLUID_BLOCK.get().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(state.m_76170_() ? 0 : state.m_76186_()))).m_61124_((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)(state.m_76170_() ? Integer.valueOf(0) : (Integer)state.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL)))).m_61124_((Property)f_75947_, (Comparable)Boolean.valueOf(!state.m_76170_() && (Boolean)state.m_61143_((Property)f_75947_) != false))).m_61124_((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)((Boolean)state.m_61143_((Property)HoneyFluidBlock.ABOVE_FLUID)));
    }

    public void m_6292_(Level world, BlockPos blockPos, FluidState fluidState) {
        boolean justFilledBottom = false;
        if (!fluidState.m_76170_()) {
            FluidState newFluidState = this.m_76035_(world, blockPos, world.m_8055_(blockPos));
            int spreadDelay = this.m_6886_(world, blockPos, fluidState, newFluidState);
            if (newFluidState.m_76178_()) {
                fluidState = newFluidState;
                world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                if ((Integer)fluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0 && (newFluidState.m_76170_() || (Integer)newFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0)) {
                    justFilledBottom = true;
                }
                fluidState = newFluidState;
                BlockState blockstate = newFluidState.m_76188_();
                world.m_7731_(blockPos, blockstate, 2);
                world.m_186469_(blockPos, newFluidState.m_76152_(), spreadDelay);
                world.m_46672_(blockPos, blockstate.m_60734_());
            }
        }
        if (!fluidState.m_76178_()) {
            int bottomFluidLevel;
            int n = bottomFluidLevel = fluidState.m_76170_() ? 0 : (Integer)fluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL);
            if (bottomFluidLevel == 0) {
                BlockState blockState = world.m_8055_(blockPos);
                BlockPos belowBlockPos = blockPos.m_7495_();
                BlockState belowBlockState = world.m_8055_(belowBlockPos);
                FluidState belowFluidState = this.m_76035_(world, belowBlockPos, belowBlockState);
                if (!belowBlockState.m_60819_().m_205070_(BzTags.HONEY_FLUID) && this.m_75977_((BlockGetter)world, blockPos, blockState, Direction.DOWN, belowBlockPos, belowBlockState, world.m_6425_(belowBlockPos), belowFluidState.m_76152_())) {
                    if (!justFilledBottom) {
                        this.spreadDown((LevelAccessor)world, belowBlockPos, belowBlockState, Direction.DOWN, belowFluidState);
                        if (((FlowingFluidAccessor)((Object)this)).callSourceNeighborCount((LevelReader)world, blockPos) >= 3) {
                            ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
                        }
                    }
                } else if (fluidState.m_76170_() || !belowBlockState.m_60819_().m_76152_().m_6212_((Fluid)this)) {
                    ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
                }
            }
        }
    }

    protected void m_76010_(Level world, BlockPos blockPos, FluidState fluidState) {
        int bottomFluidLevel;
        if (!fluidState.m_76178_() && (bottomFluidLevel = ((Integer)fluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue()) == 0) {
            BlockState blockState = world.m_8055_(blockPos);
            BlockPos belowBlockPos = blockPos.m_7495_();
            BlockState belowBlockState = world.m_8055_(belowBlockPos);
            FluidState belowFluidState = this.m_76035_(world, belowBlockPos, belowBlockState);
            if (!belowBlockState.m_60819_().m_205070_(BzTags.HONEY_FLUID) && this.m_75977_((BlockGetter)world, blockPos, blockState, Direction.DOWN, belowBlockPos, belowBlockState, world.m_6425_(belowBlockPos), belowFluidState.m_76152_())) {
                this.spreadDown((LevelAccessor)world, belowBlockPos, belowBlockState, Direction.DOWN, belowFluidState);
                if (((FlowingFluidAccessor)((Object)this)).callSourceNeighborCount((LevelReader)world, blockPos) >= 3) {
                    ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
                }
            } else if (fluidState.m_76170_() || !belowBlockState.m_60819_().m_76152_().m_6212_((Fluid)this)) {
                ((FlowingFluidAccessor)((Object)this)).callSpreadToSides(world, blockPos, fluidState, blockState);
            }
        }
    }

    protected void spreadDown(LevelAccessor world, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (!blockState.m_60795_()) {
            this.m_7456_(world, blockPos, blockState);
        }
        world.m_7731_(blockPos, fluidState.m_76188_(), 3);
    }

    protected FluidState m_76035_(Level worldReader, BlockPos blockPos, BlockState blockState) {
        int currentFluidLevel;
        boolean isBzFluidBlock = blockState.m_61138_((Property)HoneyFluidBlock.BOTTOM_LEVEL) && blockState.m_61138_((Property)LiquidBlock.f_54688_);
        int lowestNeighboringFluidLevel = isBzFluidBlock ? (Integer)blockState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) : 8;
        int highestNeighboringFluidLevel = currentFluidLevel = isBzFluidBlock ? (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) : 0;
        int neighboringFluidSource = 0;
        boolean hasAboveFluid = isBzFluidBlock ? (Boolean)blockState.m_61143_((Property)HoneyFluidBlock.ABOVE_FLUID) : false;
        BlockPos aboveBlockPos = blockPos.m_7494_();
        BlockState aboveBlockState = worldReader.m_8055_(aboveBlockPos);
        BlockState belowBlockState = worldReader.m_8055_(blockPos.m_7495_());
        boolean canPassThroughBelow = ((FlowingFluidAccessor)((Object)this)).callCanPassThroughWall(Direction.DOWN, (BlockGetter)worldReader, blockPos, blockState, blockPos.m_7495_(), belowBlockState);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos sideBlockPos = blockPos.m_121945_(direction);
            BlockState sideBlockState = worldReader.m_8055_(sideBlockPos);
            FluidState sideFluidState = sideBlockState.m_60819_();
            if (!sideFluidState.m_76152_().m_6212_((Fluid)this) || !((FlowingFluidAccessor)((Object)this)).callCanPassThroughWall(direction, (BlockGetter)worldReader, blockPos, blockState, sideBlockPos, sideBlockState)) continue;
            if (sideFluidState.m_76170_()) {
                ++neighboringFluidSource;
            }
            highestNeighboringFluidLevel = Math.max(highestNeighboringFluidLevel, sideFluidState.m_76186_());
            if (!sideFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE) || canPassThroughBelow && !sideFluidState.m_76170_() && ((Boolean)sideBlockState.m_61143_((Property)f_75947_)).booleanValue() && aboveBlockState.m_60819_().m_205070_(BzTags.SPECIAL_HONEY_LIKE)) continue;
            lowestNeighboringFluidLevel = Math.min(lowestNeighboringFluidLevel, sideFluidState.m_76170_() ? 0 : (Integer)sideFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL));
        }
        FluidState aboveFluidState = aboveBlockState.m_60819_();
        boolean aboveFluidIsThisFluid = !aboveFluidState.m_76178_() && aboveFluidState.m_76152_().m_6212_((Fluid)this);
        int newBottomFluidLevel = Math.max(lowestNeighboringFluidLevel - 1, 0);
        boolean isFalling = true;
        int newFluidLevel = 8;
        int dropOffValue = this.m_6713_((LevelReader)worldReader);
        if (hasAboveFluid && !aboveFluidIsThisFluid) {
            dropOffValue = 0;
        }
        if (aboveFluidIsThisFluid && ((FlowingFluidAccessor)((Object)this)).callCanPassThroughWall(Direction.UP, (BlockGetter)worldReader, blockPos, blockState, aboveBlockPos, aboveBlockState)) {
            if (!aboveFluidState.m_76170_() && aboveFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE) && (Integer)aboveFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0) {
                newFluidLevel = highestNeighboringFluidLevel - dropOffValue;
            }
        } else {
            isFalling = aboveFluidState.m_76178_() && neighboringFluidSource == 0 && highestNeighboringFluidLevel <= currentFluidLevel && canPassThroughBelow;
            newFluidLevel = highestNeighboringFluidLevel - dropOffValue;
        }
        return newFluidLevel <= 0 ? Fluids.f_76191_.m_76145_() : (FluidState)((FluidState)this.m_75953_(newFluidLevel, isFalling).m_61124_((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)Integer.valueOf(newBottomFluidLevel))).m_61124_((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(aboveFluidIsThisFluid && (aboveFluidState.m_76170_() || aboveFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE) && (Integer)aboveFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0)));
    }

    public float m_6098_(FluidState fluidState, BlockGetter world, BlockPos blockPos) {
        BlockPos aboveBlockPos = blockPos.m_7494_();
        BlockState aboveBlockState = world.m_8055_(aboveBlockPos);
        FluidState aboveFluidState = aboveBlockState.m_60819_();
        boolean aboveFluidIsThisFluid = !aboveFluidState.m_76178_() && aboveFluidState.m_76152_().m_6212_((Fluid)this) && (aboveFluidState.m_76170_() || !aboveFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE) || (Integer)aboveFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0);
        return (Boolean)fluidState.m_61143_((Property)HoneyFluidBlock.ABOVE_FLUID) != false || aboveFluidIsThisFluid ? 1.0f : fluidState.m_76182_();
    }

    public static boolean shouldRenderSide(BlockGetter world, BlockPos blockPos, Direction direction, FluidState currentFluidState) {
        if (direction == Direction.UP) {
            FluidState aboveFluidState = world.m_8055_(blockPos.m_7494_()).m_60819_();
            if (aboveFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE)) {
                return !aboveFluidState.m_76170_() && (Integer)aboveFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0 || currentFluidState.m_76186_() != 8;
            }
        } else if (direction == Direction.DOWN) {
            FluidState belowFluidState = world.m_8055_(blockPos.m_7495_()).m_60819_();
            if (belowFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE)) {
                return !currentFluidState.m_76170_() && (belowFluidState.m_76186_() != 8 || (Integer)currentFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0);
            }
        } else {
            FluidState sideFluidState = world.m_8055_(blockPos.m_121945_(direction)).m_60819_();
            if (sideFluidState.m_205070_(BzTags.SPECIAL_HONEY_LIKE)) {
                int bottomLayerCurrent = currentFluidState.m_76170_() ? 0 : (Integer)currentFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL);
                int bottomLayerSide = sideFluidState.m_76170_() ? 0 : (Integer)sideFluidState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL);
                return bottomLayerCurrent < bottomLayerSide;
            }
        }
        return true;
    }

    public static class Source
    extends HoneyFluid {
        public Source(FluidInfo properties) {
            super(properties, true);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{HoneyFluidBlock.ABOVE_FLUID});
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }

        @Override
        protected boolean m_6760_(Level level) {
            return false;
        }
    }

    public static class Flowing
    extends HoneyFluid {
        public Flowing(FluidInfo properties) {
            super(properties, false);
            this.m_76142_((FluidState)((FluidState)((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(8))).m_61124_((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
            builder.m_61104_(new Property[]{HoneyFluidBlock.BOTTOM_LEVEL});
            builder.m_61104_(new Property[]{HoneyFluidBlock.ABOVE_FLUID});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }

        @Override
        protected boolean m_6760_(Level level) {
            return true;
        }
    }
}

