/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenPose;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAlwaysLookAtPlayerGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAngerableMeleeAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.EntityMiscHandler;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeeQueenEntity
extends Animal
implements NeutralMob {
    private static final TargetingConditions PLAYER_ACKNOWLEDGE_SIGHT = TargetingConditions.m_148353_();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState itemThrownAnimationState = new AnimationState();
    public final AnimationState itemRejectAnimationState = new AnimationState();
    public static final EntityDataSerializer<BeeQueenPose> QUEEN_POSE_SERIALIZER = EntityDataSerializer.m_238090_(BeeQueenPose.class);
    private static final EntityDataAccessor<Integer> THROWCOOLDOWN = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEESPAWNCOOLDOWN = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BeeQueenPose> QUEEN_POSE = SynchedEntityData.m_135353_(BeeQueenEntity.class, QUEEN_POSE_SERIALIZER);
    private static final EntityDataAccessor<Integer> REMAINING_BONUS_TRADE_TIME = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> BONUS_TRADE_ITEM = SynchedEntityData.m_135353_(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)60, (int)120);
    private final Set<UUID> acknowledgedPlayers = new HashSet<UUID>();
    private final HashMap<UUID, Item> acknowledgedPlayerHeldItem = new HashMap();
    private UUID persistentAngerTarget;
    private int underWaterTicks;
    private int poseTicks;
    private boolean hasTrades = true;
    private static final WeightedTradeResult ESSENCE_DROP = new WeightedTradeResult(null, Optional.of(List.of(BzItems.ESSENCE_OF_THE_BEES.get())), 1, 1000, 1);
    private static final ResourceLocation ESSENCE_ADVANCEMENT_RL = new ResourceLocation("the_bumblezone", "the_bumblezone/the_queens_desire/essence_infusion");

    public BeeQueenEntity(EntityType<? extends BeeQueenEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWCOOLDOWN, (Object)0);
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(BEESPAWNCOOLDOWN, (Object)0);
        this.f_19804_.m_135372_(QUEEN_POSE, (Object)BeeQueenPose.NONE);
        this.f_19804_.m_135372_(REMAINING_BONUS_TRADE_TIME, (Object)0);
        this.f_19804_.m_135372_(BONUS_TRADE_ITEM, (Object)ItemStack.f_41583_);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (QUEEN_POSE.equals(entityDataAccessor)) {
            BeeQueenPose pose = this.getQueenPose();
            if (pose == BeeQueenPose.ATTACKING) {
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attackAnimationState.m_216973_();
            }
            if (pose == BeeQueenPose.ITEM_REJECT) {
                this.itemRejectAnimationState.m_216977_(this.f_19797_);
            } else {
                this.itemRejectAnimationState.m_216973_();
            }
            if (pose == BeeQueenPose.ITEM_THROW) {
                this.itemThrownAnimationState.m_216977_(this.f_19797_);
            } else {
                this.itemThrownAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BeeQueenAngerableMeleeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BeeQueenAlwaysLookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("throwcooldown", this.getThrowCooldown());
        tag.m_128405_("beespawncooldown", this.getBeeSpawnCooldown());
        tag.m_128405_("bonusTradetime", this.getRemainingBonusTradeTime());
        tag.m_128365_("bonusTradeitem", (Tag)this.getBonusTradeItem().m_41739_(new CompoundTag()));
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setThrowCooldown(tag.m_128451_("throwcooldown"));
        this.setBeeSpawnCooldown(tag.m_128451_("beespawncooldown"));
        this.setRemainingBonusTradeTime(tag.m_128451_("bonusTradetime"));
        this.setBonusTradeItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("bonusTradeitem")));
        if (this.getBonusTradeItem().m_204117_(BzTags.DISALLOWED_RANDOM_BONUS_TRADE_ITEMS) && !this.getBonusTradeItem().m_204117_(BzTags.FORCED_ALLOWED_RANDOM_BONUS_TRADE_ITEMS)) {
            this.setBonusTradeItem(ItemStack.f_41583_);
            this.setRemainingBonusTradeTime(0);
        }
        this.m_147285_(this.f_19853_, tag);
    }

    public void setQueenPose(BeeQueenPose beeQueenPose) {
        this.f_19804_.m_135381_(QUEEN_POSE, (Object)beeQueenPose);
    }

    public BeeQueenPose getQueenPose() {
        return (BeeQueenPose)((Object)this.f_19804_.m_135370_(QUEEN_POSE));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new DirectPathNavigator((Mob)this, pLevel);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return true;
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public boolean m_6914_(LevelReader worldReader) {
        AABB box = this.m_20191_();
        return !worldReader.m_46855_(box) && worldReader.m_45556_(box).noneMatch(state -> state.m_60767_().m_76334_()) && worldReader.m_45784_((Entity)this);
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7332_(Entity entity) {
        this.positionRider(entity, Entity::m_6034_);
    }

    public double m_6048_() {
        return this.m_6972_((Pose)Pose.STANDING).f_20378_ * 0.9f;
    }

    private void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double riderYOffset = this.m_20186_() + this.m_6048_() + entity.m_6049_();
            Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
            Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
            moveFunction.m_20372_(entity, this.m_20185_() + sideVect.m_7096_() - forwardVect.m_7096_() * 0.5, riderYOffset, this.m_20189_() + sideVect.m_7094_() - forwardVect.m_7094_() * 0.5);
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource == this.f_19853_.m_269111_().m_269555_()) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public void m_7601_(BlockState blockState, Vec3 speedMult) {
        if (blockState.m_60734_() instanceof SweetBerryBushBlock) {
            return;
        }
        super.m_7601_(blockState, speedMult);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_20092_() && source == this.f_19853_.m_269111_().m_269318_()) {
            this.spawnAngryParticles(6);
            this.m_6677_(source);
            return false;
        }
        if (!this.m_21525_() && (entity = source.m_7639_()) instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_5833_()) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL || player.m_7500_()) {
                    this.spawnAngryParticles(6);
                    return super.m_6469_(source, amount);
                }
            }
            if ((livingEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees) {
                if (livingEntity.m_21023_(BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    livingEntity.m_21195_(BzEffects.PROTECTION_OF_THE_HIVE.get());
                } else {
                    livingEntity.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 3, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            }
            this.m_6825_();
            this.m_6925_(livingEntity.m_20148_());
            this.m_6710_(livingEntity);
        }
        this.spawnAngryParticles(6);
        return super.m_6469_(source, amount);
    }

    protected void m_8024_() {
        this.underWaterTicks = this.m_5842_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 100) {
            this.m_6469_(this.f_19853_.m_269111_().m_269063_(), 3.0f);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
    }

    public static void applyMiningFatigueInStructures(ServerPlayer serverPlayer) {
        if (serverPlayer.m_7500_() || serverPlayer.m_5833_()) {
            return;
        }
        StructureManager structureManager = ((ServerLevel)serverPlayer.f_19853_).m_215010_();
        if (structureManager.m_220491_(serverPlayer.m_20183_(), BzTags.BEE_QUEEN_MINING_FATIGUE).m_73603_() && !serverPlayer.f_19853_.m_6443_(BeeQueenEntity.class, serverPlayer.m_20191_().m_82377_(30.0, 30.0, 30.0), e -> !e.m_21525_()).isEmpty()) {
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 2, false, false, true));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        BeeQueenPose pose = this.getQueenPose();
        if (pose != BeeQueenPose.NONE) {
            if (pose == BeeQueenPose.ATTACKING && this.poseTicks > 17) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenPose.ITEM_REJECT && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenPose.ITEM_THROW && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenPose.NONE);
                this.poseTicks = 0;
            }
            ++this.poseTicks;
        }
        if (!this.m_21525_()) {
            if (!this.m_9236_().m_5776_() && this.m_9236_().m_46467_() % 200L == 0L) {
                this.m_5634_(1.0f);
            }
            if (!this.f_19853_.m_5776_()) {
                if (this.m_21660_()) {
                    this.performAngryActions();
                } else {
                    this.performGroundTrades();
                }
            }
        }
        this.performBonusTradeTick();
    }

    private void performBonusTradeTick() {
        if (!this.f_19853_.m_5776_()) {
            if (BzGeneralConfigs.beeQueenBonusTradeRewardMultiplier <= 1 || BzGeneralConfigs.beeQueenBonusTradeDurationInTicks == 0 || BzGeneralConfigs.beeQueenBonusTradeAmountTillSatified == 0) {
                if (this.getRemainingBonusTradeTime() > 0) {
                    this.setRemainingBonusTradeTime(0);
                }
                if (!this.getBonusTradeItem().m_41619_()) {
                    this.setBonusTradeItem(ItemStack.f_41583_);
                    this.acknowledgedPlayers.clear();
                }
            }
            int minNotifyTime = 1200;
            if (this.getRemainingBonusTradeTime() > 0) {
                this.setRemainingBonusTradeTime(this.getRemainingBonusTradeTime() - 1);
            } else if (!this.getBonusTradeItem().m_41619_()) {
                this.setBonusTradeItem(ItemStack.f_41583_);
                this.acknowledgedPlayers.clear();
            }
            if (this.hasTrades && !this.m_21660_() && (this.m_9236_().m_46467_() + this.m_20148_().getLeastSignificantBits()) % 20L == 0L) {
                List nearbyPlayers = this.f_19853_.m_45955_(PLAYER_ACKNOWLEDGE_SIGHT, (LivingEntity)this, this.m_20191_().m_82400_(8.0));
                if (this.getRemainingBonusTradeTime() == 0 && nearbyPlayers.size() > 0) {
                    this.setRemainingBonusTradeTime(BzGeneralConfigs.beeQueenBonusTradeDurationInTicks);
                    Iterator allowedBonusTradeItems = QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.keySet().stream().filter(i -> i.m_245993_(this.f_19853_.m_246046_()) && !i.m_204114_().m_203656_(BzTags.DISALLOWED_RANDOM_BONUS_TRADE_ITEMS) || i.m_204114_().m_203656_(BzTags.FORCED_ALLOWED_RANDOM_BONUS_TRADE_ITEMS)).toList();
                    if (allowedBonusTradeItems.size() > 0) {
                        this.setBonusTradeItem(((Item)allowedBonusTradeItems.get(this.m_217043_().m_188503_(allowedBonusTradeItems.size()))).m_7968_());
                        this.getBonusTradeItem().m_41769_(BzGeneralConfigs.beeQueenBonusTradeAmountTillSatified);
                    } else {
                        this.hasTrades = false;
                        this.setRemainingBonusTradeTime(0);
                    }
                }
                for (Player player : nearbyPlayers) {
                    Item heldItem = player.m_21205_().m_41720_();
                    if (this.acknowledgedPlayerHeldItem.containsKey(player.m_20148_()) && this.acknowledgedPlayerHeldItem.get(player.m_20148_()).equals(heldItem)) continue;
                    if ((this.getBonusTradeItem().m_41619_() || !this.getBonusTradeItem().m_150930_(heldItem)) && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)heldItem)) {
                        player.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_regular_trade_held").m_130940_(ChatFormatting.WHITE), true);
                    }
                    this.acknowledgedPlayerHeldItem.put(player.m_20148_(), heldItem);
                }
                if (this.hasTrades && this.getBonusTradeItem().m_41619_() && this.getRemainingBonusTradeTime() > 0) {
                    if (this.getRemainingBonusTradeTime() > minNotifyTime) {
                        for (Player player : nearbyPlayers) {
                            if (this.acknowledgedPlayers.contains(player.m_20148_())) continue;
                            player.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_satisfied").m_130940_(ChatFormatting.WHITE), true);
                            this.acknowledgedPlayers.add(player.m_20148_());
                        }
                    }
                    return;
                }
                if (!this.getBonusTradeItem().m_41619_() && this.getRemainingBonusTradeTime() >= minNotifyTime) {
                    boolean notifiedAPlayer = false;
                    for (Player player : nearbyPlayers) {
                        if (this.acknowledgedPlayers.contains(player.m_20148_())) continue;
                        Component itemName = this.getBonusTradeItem().m_41786_();
                        if (itemName instanceof MutableComponent) {
                            MutableComponent mutableComponent = (MutableComponent)itemName;
                            mutableComponent.m_130940_(ChatFormatting.YELLOW);
                        }
                        if (player.f_36095_.f_38839_.stream().anyMatch(s -> s.m_7993_().m_41656_(this.getBonusTradeItem()))) {
                            player.m_5661_((Component)Component.m_237110_((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_inventory", (Object[])new Object[]{itemName}).m_130940_(ChatFormatting.WHITE), true);
                        } else {
                            player.m_5661_((Component)Component.m_237110_((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade", (Object[])new Object[]{itemName, this.getRemainingBonusTradeTime() / minNotifyTime}).m_130940_(ChatFormatting.WHITE), true);
                        }
                        notifiedAPlayer = true;
                        this.acknowledgedPlayers.add(player.m_20148_());
                    }
                    if (notifiedAPlayer) {
                        this.setQueenPose(BeeQueenPose.ITEM_THROW);
                    }
                }
            }
        }
    }

    private void performAngryActions() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_21662_();
            return;
        }
        int beeCooldown = this.getBeeSpawnCooldown();
        if (beeCooldown <= 0 && !this.m_6107_()) {
            this.setBeeSpawnCooldown(this.f_19796_.m_188503_(50) + 75);
            BlockPos spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange((LivingEntity)this, 5, 0);
            if (!this.f_19853_.m_8055_(spawnBlockPos).m_60795_()) {
                return;
            }
            Bee bee = (Bee)EntityType.f_20550_.m_20615_(this.f_19853_);
            if (bee == null) {
                return;
            }
            bee.m_7870_(this.m_6784_());
            bee.m_6925_(this.m_6120_());
            bee.m_6710_(this.m_5448_());
            bee.m_19890_((double)spawnBlockPos.m_123341_() + 0.5, (double)spawnBlockPos.m_123342_() + 0.5, (double)spawnBlockPos.m_123343_() + 0.5, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            bee.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(spawnBlockPos), MobSpawnType.TRIGGERED, null, null);
            bee.m_7292_(new MobEffectInstance(MobEffects.f_19615_, Integer.MAX_VALUE, 0, true, false, false));
            this.f_19853_.m_7967_((Entity)bee);
            this.spawnAngryParticles(6);
            this.setQueenPose(BeeQueenPose.ATTACKING);
        } else {
            this.setBeeSpawnCooldown(beeCooldown - 1);
        }
    }

    private void performGroundTrades() {
        int throwCooldown = this.getThrowCooldown();
        if (throwCooldown > 0) {
            this.setThrowCooldown(throwCooldown - 1);
        }
        if ((this.m_9236_().m_46467_() + this.m_20148_().getLeastSignificantBits()) % 20L == 0L && throwCooldown <= 0) {
            Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
            Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
            AABB scanArea = this.m_20191_().m_165897_(0.45, 0.9, 0.45).m_82386_(forwardVect.m_7096_() * 0.5, -0.95, forwardVect.m_7094_() * 0.5);
            List items = this.f_19853_.m_45976_(ItemEntity.class, scanArea);
            items.stream().filter(ie -> !ie.m_32063_()).findFirst().ifPresent(itemEntity -> {
                Player patt28078$temp;
                int tradedItems = 0;
                Item item = itemEntity.m_32055_().m_41720_();
                if (QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
                    for (int i = 0; i < itemEntity.m_32055_().m_41613_(); ++i) {
                        Optional reward = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).m_216829_(this.f_19796_);
                        if (!reward.isPresent()) continue;
                        this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.m_32055_(), itemEntity.m_19749_().m_20148_());
                        ++tradedItems;
                    }
                }
                if (tradedItems > 0) {
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                } else {
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    ItemEntity rejectedItemEntity = new ItemEntity(this.f_19853_, this.m_20185_() + sideVect.m_7096_() * 1.75 + forwardVect.m_7096_() * 1.0, this.m_20186_() + 0.3, this.m_20189_() + sideVect.m_7094_() * 1.75 + forwardVect.m_7096_() * 1.0, itemEntity.m_32055_(), (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7096_() / 3.0, (double)0.4f, (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7094_() / 3.0);
                    this.f_19853_.m_7967_((Entity)rejectedItemEntity);
                    rejectedItemEntity.m_32060_();
                    this.spawnAngryParticles(2);
                    this.setQueenPose(BeeQueenPose.ITEM_REJECT);
                }
                this.setThrowCooldown(50);
                if (tradedItems > 0 && itemEntity.m_19749_() != null && (patt28078$temp = this.f_19853_.m_46003_(itemEntity.m_19749_().m_20148_())) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt28078$temp;
                    BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.trigger(serverPlayer);
                    EntityMiscHandler.onQueenBeeTrade((Player)serverPlayer, tradedItems);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.ENTITY_MISC).ifPresent(capability -> {
                            if (!capability.receivedEssencePrize) {
                                this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.f_41583_, null);
                                capability.receivedEssencePrize = true;
                                serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_reset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                            }
                        });
                    }
                }
            });
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_21525_()) {
            return InteractionResult.PASS;
        }
        if (this.m_21660_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (stack.m_41619_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.ENTITY_MISC).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
                        Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.f_41583_, null);
                        capability.receivedEssencePrize = true;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_reset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                    } else {
                        long timeDiff = this.f_19853_.m_46467_() - capability.tradeResetPrimedTime;
                        if (timeDiff < 200L && timeDiff > 10L) {
                            this.resetAdvancementTree(serverPlayer, BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
                            capability.resetAllTrackerStats();
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.reset_advancements").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                        } else {
                            capability.tradeResetPrimedTime = this.f_19853_.m_46467_();
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.advancements_warning").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                        }
                    }
                });
            }
            return InteractionResult.PASS;
        }
        boolean traded = false;
        if (QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            if (this.f_19853_.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
            Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
            Optional reward = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).m_216829_(this.f_19796_);
            if (reward.isPresent()) {
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.m_20148_());
                traded = true;
            }
        }
        if (!this.f_19853_.m_5776_()) {
            if (!traded) {
                this.spawnAngryParticles(2);
                this.setQueenPose(BeeQueenPose.ITEM_REJECT);
            } else {
                this.setThrowCooldown(50);
                stack.m_41774_(1);
                player.m_21008_(hand, stack);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.trigger(serverPlayer);
                    EntityMiscHandler.onQueenBeeTrade((Player)serverPlayer);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.ENTITY_MISC).ifPresent(capability -> {
                            if (!capability.receivedEssencePrize) {
                                Vec3 forwardVect = Vec3.m_82498_((float)0.0f, (float)this.m_213816_());
                                Vec3 sideVect = Vec3.m_82498_((float)0.0f, (float)(this.m_213816_() - 90.0f));
                                this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.f_41583_, null);
                                capability.receivedEssencePrize = true;
                                serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_reset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), false);
                            }
                        });
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void resetAdvancementTree(ServerPlayer serverPlayer, ResourceLocation advancementRL) {
        Iterable advancements = serverPlayer.f_8924_.m_129889_().m_136041_(advancementRL).m_138322_();
        for (Advancement advancement : advancements) {
            if (advancement.m_138327_().equals((Object)ESSENCE_ADVANCEMENT_RL)) continue;
            AdvancementProgress advancementprogress = serverPlayer.m_8960_().m_135996_(advancement);
            for (String criteria : advancementprogress.m_8220_()) {
                serverPlayer.m_8960_().m_135998_(advancement, criteria);
            }
            this.resetAdvancementTree(serverPlayer, advancement.m_138327_());
        }
    }

    private static boolean finalbeeQueenAdvancementDone(ServerPlayer serverPlayer) {
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(BzCriterias.QUEENS_DESIRE_FINAL_ADVANCEMENT);
        Map<Advancement, AdvancementProgress> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.m_8960_()).getProgress();
        return advancement != null && advancementsProgressMap.containsKey(advancement) && advancementsProgressMap.get(advancement).m_8193_();
    }

    private boolean isContainerBlockEntity(ItemStack itemStack) {
        EntityBlock block;
        BlockItem blockItem;
        Item item = itemStack.m_41720_();
        return item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof EntityBlock && (block = (EntityBlock)item).m_142194_(this.m_20183_(), blockItem.m_40614_().m_49966_()) instanceof Container;
    }

    private void spawnReward(Vec3 forwardVect, Vec3 sideVect, WeightedTradeResult reward, ItemStack originalItem, UUID playerUUID) {
        int currentItemStackCount;
        int rewardMultiplier = 1;
        if (this.getBonusTradeItem().m_41656_(originalItem) && BzGeneralConfigs.beeQueenBonusTradeRewardMultiplier > 1) {
            Player player;
            rewardMultiplier = BzGeneralConfigs.beeQueenBonusTradeRewardMultiplier;
            this.getBonusTradeItem().m_41774_(1);
            if (this.getBonusTradeItem().m_41619_()) {
                this.setBonusTradeItem(ItemStack.f_41583_);
            }
            if ((player = this.f_19853_.m_46003_(playerUUID)) != null) {
                if (!this.getBonusTradeItem().m_41619_()) {
                    player.m_5661_((Component)Component.m_237110_((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_performed", (Object[])new Object[]{BzGeneralConfigs.beeQueenBonusTradeRewardMultiplier}).m_130940_(ChatFormatting.WHITE), true);
                } else {
                    this.acknowledgedPlayers.clear();
                    player.m_5661_((Component)Component.m_237115_((String)"entity.the_bumblezone.bee_queen.mention_bonus_trade_satisfied").m_130940_(ChatFormatting.WHITE), true);
                    this.acknowledgedPlayers.add(playerUUID);
                }
            }
        }
        Item chosenItem = reward.getItems().get(this.f_19796_.m_188503_(reward.getItems().size()));
        int itemStackMaxSize = chosenItem.m_41459_();
        for (int remainingItemToSpawn = reward.count * rewardMultiplier; remainingItemToSpawn > 0; remainingItemToSpawn -= currentItemStackCount) {
            Level level;
            ItemStack rewardItem = chosenItem.m_7968_();
            this.setQueenPose(BeeQueenPose.ITEM_THROW);
            if (originalItem.m_204117_(ItemTags.f_13191_) && rewardItem.m_204117_(ItemTags.f_13191_) && originalItem.m_41782_()) {
                rewardItem.m_41784_().m_128391_(originalItem.m_41784_());
            } else if (originalItem.m_41656_(rewardItem) && originalItem.m_41782_()) {
                rewardItem.m_41784_().m_128391_(originalItem.m_41784_());
            } else if (this.isContainerBlockEntity(originalItem) && this.isContainerBlockEntity(rewardItem) && originalItem.m_41782_()) {
                rewardItem.m_41784_().m_128391_(originalItem.m_41784_());
            }
            currentItemStackCount = Math.min(remainingItemToSpawn, itemStackMaxSize);
            rewardItem.m_41764_(currentItemStackCount);
            ItemEntity rewardItemEntity = new ItemEntity(this.f_19853_, this.m_20185_() + sideVect.m_7096_() * 0.9 + forwardVect.m_7096_() * 1.0, this.m_20186_() + 0.3, this.m_20189_() + sideVect.m_7094_() * 0.9 + forwardVect.m_7096_() * 1.0, rewardItem, (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7096_() / 4.0, (double)0.3f, (double)((this.f_19796_.m_188501_() - 0.5f) / 10.0f) + forwardVect.m_7094_() / 4.0);
            this.f_19853_.m_7967_((Entity)rewardItemEntity);
            rewardItemEntity.m_32060_();
            this.spawnHappyParticles();
            if (reward.xpReward <= 0 || !((level = this.f_19853_) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)new Vec3(this.m_20185_() + forwardVect.m_7096_() * 1.0, this.m_20186_() + 0.3, this.m_20189_() + forwardVect.m_7096_() * 1.0), (int)reward.xpReward);
        }
        this.f_19853_.m_5594_(null, this.m_20183_(), BzSounds.BEE_QUEEN_HAPPY.get(), SoundSource.NEUTRAL, 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.6f);
    }

    public void spawnAngryParticles(int particles) {
        if (!this.f_19853_.m_5776_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20186_() + (double)0.45f, this.m_20189_(), particles, (double)(this.m_217043_().m_188501_() - 0.5f), (double)(this.m_217043_().m_188501_() * 0.4f + 0.4f), (double)(this.m_217043_().m_188501_() - 0.5f), (double)(this.m_217043_().m_188501_() * 0.8f + 0.4f));
        }
    }

    private void spawnHappyParticles() {
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 0.75, this.m_20189_(), 5, 0.8, 0.75, 0.8, (double)this.m_217043_().m_188501_() + 0.5);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        Bee bee = (Bee)EntityType.f_20550_.m_20615_((Level)serverWorld);
        bee.m_6863_(true);
        return bee;
    }

    public int m_21529_() {
        return 1;
    }

    public int m_8132_() {
        return 90;
    }

    public int getThrowCooldown() {
        return (Integer)this.f_19804_.m_135370_(THROWCOOLDOWN);
    }

    public void setThrowCooldown(Integer cooldown) {
        this.f_19804_.m_135381_(THROWCOOLDOWN, (Object)cooldown);
    }

    public int getBeeSpawnCooldown() {
        return (Integer)this.f_19804_.m_135370_(BEESPAWNCOOLDOWN);
    }

    public void setBeeSpawnCooldown(Integer cooldown) {
        this.f_19804_.m_135381_(BEESPAWNCOOLDOWN, (Object)cooldown);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int remainingPersistentAngerTime) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)remainingPersistentAngerTime);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_21662_() {
        super.m_21662_();
        this.setBeeSpawnCooldown(0);
        this.m_6710_(null);
    }

    public int getRemainingBonusTradeTime() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_BONUS_TRADE_TIME);
    }

    public void setRemainingBonusTradeTime(Integer remainingBonusTradeItem) {
        this.f_19804_.m_135381_(REMAINING_BONUS_TRADE_TIME, (Object)remainingBonusTradeItem);
    }

    public ItemStack getBonusTradeItem() {
        return (ItemStack)this.f_19804_.m_135370_(BONUS_TRADE_ITEM);
    }

    public void setBonusTradeItem(ItemStack bonusTradeItem) {
        this.f_19804_.m_135381_(BONUS_TRADE_ITEM, (Object)bonusTradeItem);
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
    }

    protected SoundEvent m_7515_() {
        return BzSounds.BEE_QUEEN_LOOP.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BzSounds.BEE_QUEEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return BzSounds.BEE_QUEEN_DEATH.get();
    }

    public static class DirectPathNavigator
    extends GroundPathNavigation {
        private final Mob mob;

        public DirectPathNavigator(Mob mob, Level world) {
            super(mob, world);
            this.mob = mob;
        }

        public void m_7638_() {
            ++this.f_26498_;
        }

        public boolean m_26519_(double x, double y, double z, double speedIn) {
            this.mob.m_21566_().m_6849_(x, y, z, speedIn);
            return true;
        }

        public boolean m_5624_(Entity entityIn, double speedIn) {
            this.mob.m_21566_().m_6849_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_(), speedIn);
            return true;
        }
    }
}

