/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public final class BeeDedicatedSpawning {
    private BeeDedicatedSpawning() {
    }

    public static void specialSpawnBees(ServerLevel world) {
        int despawnDistance = 80;
        int entityCountChange = 0;
        Set<Bee> allWildBees = GeneralUtils.getAllWildBees();
        List serverPlayers = world.m_6907_();
        for (Bee wildBee : allWildBees) {
            for (ServerPlayer serverPlayer : serverPlayers) {
                if (PlatformHooks.isFakePlayer(serverPlayer) || !(wildBee.m_20182_().m_82546_(serverPlayer.m_20182_()).m_82553_() > (double)despawnDistance)) continue;
                wildBee.m_142687_(Entity.RemovalReason.DISCARDED);
                --entityCountChange;
            }
        }
        int beesPerPlayer = BzGeneralConfigs.nearbyBeesPerPlayerInBz;
        int maxWildBeeLimit = beesPerPlayer * serverPlayers.size();
        if (allWildBees.size() <= maxWildBeeLimit) {
            for (ServerPlayer serverPlayer : serverPlayers) {
                if (PlatformHooks.isFakePlayer(serverPlayer)) continue;
                int nearbyBees = 0;
                for (Entity entity : world.m_45933_((Entity)serverPlayer, serverPlayer.m_20191_().m_82377_((double)despawnDistance, (double)despawnDistance, (double)despawnDistance))) {
                    if (!(entity instanceof Bee)) continue;
                    ++nearbyBees;
                }
                for (int i = nearbyBees; i <= beesPerPlayer; ++i) {
                    BlockPos newBeePos = GeneralUtils.getRandomBlockposWithinRange((LivingEntity)serverPlayer, 45, 20);
                    if (!world.m_8055_(newBeePos).m_60795_()) continue;
                    Bee newBee = (Bee)EntityType.f_20550_.m_20615_((Level)world);
                    newBee.m_146884_(Vec3.m_82512_((Vec3i)newBeePos));
                    newBee.m_20256_(new Vec3(0.0, 1.0, 0.0));
                    newBee.m_7910_(0.0f);
                    newBee.m_6518_((ServerLevelAccessor)world, world.m_6436_(newBee.m_20183_()), MobSpawnType.NATURAL, null, null);
                    PlatformHooks.finalizeSpawn((Mob)newBee, (ServerLevelAccessor)world, null, MobSpawnType.NATURAL, null);
                    world.m_7967_((Entity)newBee);
                    ++entityCountChange;
                }
            }
        }
        GeneralUtils.adjustEntityCountInBz(entityCountChange);
    }
}

