/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.forge;

import com.telepathicgrunt.the_bumblezone.configs.forge.BzBeeAggressionConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzClientConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzDimensionConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzGeneralConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzModCompatibilityConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzWorldgenConfig;
import java.nio.file.Path;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;

public class BzConfigHandler {
    public static void setup() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(BzConfigHandler::onConfigLoad);
        bus.addListener(BzConfigHandler::onConfigReload);
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("the_bumblezone"), (String)"the_bumblezone");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BzClientConfig.GENERAL_SPEC, "the_bumblezone/client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzGeneralConfig.GENERAL_SPEC, "the_bumblezone/general.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzWorldgenConfig.GENERAL_SPEC, "the_bumblezone/worldgen.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzDimensionConfig.GENERAL_SPEC, "the_bumblezone/dimension.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzBeeAggressionConfig.GENERAL_SPEC, "the_bumblezone/bee_aggression.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzModCompatibilityConfig.GENERAL_SPEC, "the_bumblezone/mod_compatibility.toml");
    }

    private static void onConfigLoad(ModConfigEvent.Loading event) {
        BzConfigHandler.copyToCommon(event.getConfig().getSpec());
    }

    private static void onConfigReload(ModConfigEvent.Reloading event) {
        BzConfigHandler.copyToCommon(event.getConfig().getSpec());
    }

    private static void copyToCommon(IConfigSpec<?> spec) {
        if (spec == BzClientConfig.GENERAL_SPEC) {
            BzClientConfig.copyToCommon();
        }
        if (spec == BzGeneralConfig.GENERAL_SPEC) {
            BzGeneralConfig.copyToCommon();
        }
        if (spec == BzWorldgenConfig.GENERAL_SPEC) {
            BzWorldgenConfig.copyToCommon();
        }
        if (spec == BzDimensionConfig.GENERAL_SPEC) {
            BzDimensionConfig.copyToCommon();
        }
        if (spec == BzBeeAggressionConfig.GENERAL_SPEC) {
            BzBeeAggressionConfig.copyToCommon();
        }
        if (spec == BzModCompatibilityConfig.GENERAL_SPEC) {
            BzModCompatibilityConfig.copyToCommon();
        }
    }
}

