/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.forge;

import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import net.minecraftforge.common.ForgeConfigSpec;

public class BzClientConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.DoubleValue fogBrightnessPercentage;
    public static ForgeConfigSpec.DoubleValue fogThickness;
    public static ForgeConfigSpec.BooleanValue enableDimensionFog;
    public static ForgeConfigSpec.DoubleValue lgbtBeeRate;
    public static ForgeConfigSpec.DoubleValue ukraineBeeRate;
    public static ForgeConfigSpec.BooleanValue enableAltBeeSkinRenderer;
    public static ForgeConfigSpec.BooleanValue playWrathOfHiveEffectMusic;
    public static ForgeConfigSpec.BooleanValue renderBeeQueenBonusTradeItem;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("The Bumblezone Client Dimension Options");
        fogBrightnessPercentage = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How bright the fog is in the Bumblezone dimension. ", " ", " The brightness is represented as a percentage", " so 0 will be pitch black, 50 will be half", " as bright, 100 will be normal orange brightness,", " and 100000 will be white.\n"}).translation("the_bumblezone.config.fogbrightnesspercentage").defineInRange("fogBrightnessPercentage", 100.0, 0.0, 100000.0);
        fogThickness = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How thick the fog in Bumblezone is.", " 2 is a little bit of fog and 50 is super thick fog. Decimal values are allowed.\n"}).translation("the_bumblezone.config.fogthickness").defineInRange("fogThickness", 4.0, 0.0, 100.0);
        enableDimensionFog = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bumblezone dimension has thick fog or not.\n"}).translation("the_bumblezone.config.enabledimensionfog").define("enableDimensionFog", true);
        builder.pop();
        lgbtBeeRate = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Rate for how often a bee will have an LGBT+ pajama!\n"}).translation("the_bumblezone.config.lgbtbeerate").defineInRange("lgbt+ bee rates", 0.013, 0.0, 1.0);
        ukraineBeeRate = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Rate for how often a bee will have an Ukraine pajama!\n"}).translation("the_bumblezone.config.ukrainebeerate").defineInRange("ukraine bee rates", 0.004, 0.0, 1.0);
        enableAltBeeSkinRenderer = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Enable replacing the bee renderer for alternative skins.", " Set this to false if the render is messing with other mod's bee renderers.\n"}).translation("the_bumblezone.config.enablelgbtbeerenderer").define("Enable lgbt+ bee renderer", true);
        playWrathOfHiveEffectMusic = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If on, Flight of the Bumblebee by Rimsky Korsakov will play when you have Wrath of the Hive effect on.\n"}).translation("the_bumblezone.config.playwrathofhiveeffectmusic").define("playWrathOfHiveEffectMusic", true);
        renderBeeQueenBonusTradeItem = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether to show the item on the Bee Queen that the Queen wants for Bonus Trades.\n"}).translation("the_bumblezone.config.renderbeequeenbonusTradeitem").define("renderBeeQueenBonusTradeItem", true);
    }

    public static void copyToCommon() {
        BzDimensionConfigs.fogBrightnessPercentage = (Double)fogBrightnessPercentage.get();
        BzDimensionConfigs.fogThickness = (Double)fogThickness.get();
        BzDimensionConfigs.enableDimensionFog = (Boolean)enableDimensionFog.get();
        BzClientConfigs.lgbtBeeRate = (Double)lgbtBeeRate.get();
        BzClientConfigs.ukraineBeeRate = (Double)ukraineBeeRate.get();
        BzClientConfigs.enableAltBeeSkinRenderer = (Boolean)enableAltBeeSkinRenderer.get();
        BzClientConfigs.playWrathOfHiveEffectMusic = (Boolean)playWrathOfHiveEffectMusic.get();
        BzClientConfigs.renderBeeQueenBonusTradeItem = (Boolean)renderBeeQueenBonusTradeItem.get();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        BzClientConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

