/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering;

import com.google.common.collect.ImmutableList;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;

public class BeeVariantRenderer {
    private static final List<String> LGBT_VARIANTS = ImmutableList.of((Object)"transbee", (Object)"asexualbee", (Object)"agenderbee", (Object)"aroacebee", (Object)"aromanticbee", (Object)"bisexualbee");
    private static final String UKRAINE_VARIANT = "ukrainebee";

    public static ResourceLocation getTextureLocation(Bee entity) {
        if (BzClientConfigs.enableAltBeeSkinRenderer) {
            boolean ukraine;
            UUID id = entity.m_20148_();
            long most = id.getMostSignificantBits();
            double lgbtChance = BzClientConfigs.lgbtBeeRate;
            boolean lgbt = new Random(most + 1001L).nextDouble() < lgbtChance;
            double ukraineChance = BzClientConfigs.ukraineBeeRate;
            boolean bl = ukraine = new Random(most + 2005L).nextDouble() < ukraineChance;
            if (entity.m_8077_() || lgbt || ukraine) {
                String custName = entity.m_8077_() ? entity.m_7770_().getString().trim() : "";
                String name = custName.toLowerCase(Locale.ROOT);
                if (!LGBT_VARIANTS.contains(name) && !UKRAINE_VARIANT.equals(name)) {
                    if (lgbt) {
                        name = LGBT_VARIANTS.get(Math.abs((int)(most % (long)LGBT_VARIANTS.size())));
                    }
                    if (ukraine) {
                        name = UKRAINE_VARIANT;
                    }
                }
                if (LGBT_VARIANTS.contains(name) || UKRAINE_VARIANT.equals(name)) {
                    String type = "";
                    boolean angery = entity.m_27857_();
                    boolean nectar = entity.m_27856_();
                    if (angery) {
                        type = nectar ? "_angry_nectar" : "_angry";
                    } else if (nectar) {
                        type = "_nectar";
                    }
                    String path = String.format("textures/entity/bee_variants/%s/bee%s.png", name, type);
                    return new ResourceLocation("the_bumblezone", path);
                }
            }
        }
        return null;
    }
}

