/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.telepathicgrunt.the_bumblezone.client.bakedmodel.ConnectedBlockModel;
import com.telepathicgrunt.the_bumblezone.client.forge.ForgeConnectedBlockModel;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class ForgeConnectedModelLoader
implements IGeometryLoader<GeometryModel> {
    public GeometryModel read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        Set<Block> blocks = ForgeConnectedModelLoader.getBlocks(json);
        return new GeometryModel(ForgeConnectedModelLoader.makeMaterials(GsonHelper.m_13930_((JsonObject)json, (String)"textures")), state -> blocks.contains(state.m_60734_()));
    }

    private static Set<Block> getBlocks(JsonObject json) {
        if (json.has("block")) {
            JsonElement jsonElement = json.get("block");
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                ObjectOpenHashSet blocks = new ObjectOpenHashSet(array.size());
                for (int i = 0; i < array.size(); ++i) {
                    blocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(array.get(i).getAsString())));
                }
                return blocks;
            }
            return Set.of((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"))));
        }
        throw new JsonParseException("Missing block, expected to find a string or a list of strings");
    }

    private static EnumMap<ConnectedBlockModel.Texture, Material> makeMaterials(JsonObject json) {
        EnumMap<ConnectedBlockModel.Texture, Material> map = new EnumMap<ConnectedBlockModel.Texture, Material>(ConnectedBlockModel.Texture.class);
        for (String key : json.keySet()) {
            ConnectedBlockModel.Texture.tryParse(key).ifPresent(connection -> map.put((ConnectedBlockModel.Texture)((Object)connection), ForgeConnectedModelLoader.create(json.get(key).getAsString())));
        }
        return map;
    }

    private static Material create(String id) {
        return new Material(TextureAtlas.f_118259_, new ResourceLocation(id));
    }

    public record GeometryModel(EnumMap<ConnectedBlockModel.Texture, Material> textures, Predicate<BlockState> predicate) implements IUnbakedGeometry<GeometryModel>
    {
        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> function, ModelState state, ItemOverrides overrides, ResourceLocation id) {
            return new ForgeConnectedBlockModel(id, this.textures, this.predicate);
        }
    }
}

