/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.forge;

import com.google.common.collect.Maps;
import com.telepathicgrunt.the_bumblezone.client.bakedmodel.ConnectedBlockModel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ForgeConnectedBlockModel
implements IDynamicBakedModel {
    private static final BlockElementFace FULL_FACE = new BlockElementFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
    public static final List<ForgeConnectedBlockModel> INSTANCES = new ArrayList<ForgeConnectedBlockModel>();
    public static final ModelProperty<EnumMap<Direction, Set<ConnectedBlockModel.Texture>>> DATA = new ModelProperty();
    private final ConnectedBlockModel model;
    private final EnumMap<ConnectedBlockModel.Texture, Material> sprites;
    private final ResourceLocation id;
    private EnumMap<Direction, EnumMap<ConnectedBlockModel.Texture, BakedModel>> quads;
    private BakedModel baseModel;
    private BakedModel facingModel;

    public ForgeConnectedBlockModel(ResourceLocation id, EnumMap<ConnectedBlockModel.Texture, Material> sprites, Predicate<BlockState> predicate) {
        this.model = new ConnectedBlockModel(predicate);
        this.sprites = sprites;
        this.id = id;
        INSTANCES.add(this);
    }

    private void lateInit() {
        this.baseModel = ForgeConnectedBlockModel.createFullBlock(this.sprites.get((Object)ConnectedBlockModel.Texture.BASE).m_119204_(), this.id);
        this.facingModel = this.sprites.containsKey((Object)ConnectedBlockModel.Texture.FRONT) ? ForgeConnectedBlockModel.createFullBlock(this.sprites.get((Object)ConnectedBlockModel.Texture.FRONT).m_119204_(), this.id) : null;
        this.quads = ForgeConnectedBlockModel.buildFaces(this.id, this.sprites.getOrDefault((Object)ConnectedBlockModel.Texture.PARTICLE, this.sprites.get((Object)ConnectedBlockModel.Texture.BASE)).m_119204_(), new TextureAtlasSprite[]{this.sprites.get((Object)ConnectedBlockModel.Texture.TOP_LEFT).m_119204_(), this.sprites.get((Object)ConnectedBlockModel.Texture.TOP_RIGHT).m_119204_(), this.sprites.get((Object)ConnectedBlockModel.Texture.BOTTOM_LEFT).m_119204_(), this.sprites.get((Object)ConnectedBlockModel.Texture.BOTTOM_RIGHT).m_119204_()});
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource arg3, @NotNull ModelData modelData, @Nullable RenderType arg4) {
        EnumMap connections;
        ArrayList<BakedQuad> finalQuads = new ArrayList<BakedQuad>();
        if (state != null && state.m_61138_((Property)BlockStateProperties.f_61372_) && ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_() == direction) {
            finalQuads.addAll(this.facingModel.getQuads(state, direction, arg3, modelData, arg4));
        } else {
            finalQuads.addAll(this.baseModel.getQuads(state, direction, arg3, modelData, arg4));
        }
        if (direction != null && modelData.has(DATA) && (connections = (EnumMap)modelData.get(DATA)) != null) {
            EnumMap<ConnectedBlockModel.Texture, BakedModel> models = this.quads.get(direction);
            for (ConnectedBlockModel.Texture connection : (Set)connections.get(direction)) {
                finalQuads.addAll(models.get((Object)connection).getQuads(state, direction, arg3, modelData, arg4));
            }
        }
        return finalQuads;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        EnumMap<Direction, Set<ConnectedBlockModel.Texture>> connections = new EnumMap<Direction, Set<ConnectedBlockModel.Texture>>(Direction.class);
        for (Direction direction : Direction.values()) {
            connections.put(direction, this.model.getSprites(level, pos, direction));
        }
        return modelData.derive().with(DATA, connections).build();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.getParticleIcon(ModelData.EMPTY);
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private static BakedModel createFullBlock(TextureAtlasSprite sprite, ResourceLocation modelLocation) {
        BlockModel dummy = new BlockModel(null, List.of(), Map.of(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        EnumMap faces = Maps.newEnumMap(Direction.class);
        for (Direction direction2 : Direction.values()) {
            faces.put(direction2, FULL_FACE);
        }
        BlockElement element = new BlockElement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)faces, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(dummy, ItemOverrides.f_111734_, false).m_119528_(sprite);
        element.f_111310_.forEach((direction, face) -> builder.m_119530_(direction, new FaceBakery().m_111600_(element.f_111308_, element.f_111309_, face, sprite, direction, (ModelState)BlockModelRotation.X0_Y0, element.f_111311_, true, modelLocation)));
        return builder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("solid")));
    }

    private static EnumMap<Direction, EnumMap<ConnectedBlockModel.Texture, BakedModel>> buildFaces(ResourceLocation modelLocation, TextureAtlasSprite particle, TextureAtlasSprite[] cornerLocations) {
        EnumMap<Direction, EnumMap<ConnectedBlockModel.Texture, BakedModel>> map = new EnumMap<Direction, EnumMap<ConnectedBlockModel.Texture, BakedModel>>(Direction.class);
        for (Direction direction : Direction.values()) {
            map.put(direction, new EnumMap(ConnectedBlockModel.Texture.class));
        }
        for (ConnectedBlockModel.Texture texture : ConnectedBlockModel.Texture.BASELESS) {
            ForgeConnectedBlockModel.put(map, Direction.WEST, texture, ForgeConnectedBlockModel.bakedModel(new Vector3f(-0.01f, 0.0f, 0.0f), new Vector3f(-0.01f, 16.0f, 16.0f), Direction.WEST, texture, modelLocation, particle, cornerLocations));
            ForgeConnectedBlockModel.put(map, Direction.EAST, texture, ForgeConnectedBlockModel.bakedModel(new Vector3f(16.01f, 0.0f, 0.0f), new Vector3f(16.01f, 16.0f, 16.0f), Direction.EAST, texture, modelLocation, particle, cornerLocations));
            ForgeConnectedBlockModel.put(map, Direction.NORTH, texture, ForgeConnectedBlockModel.bakedModel(new Vector3f(0.0f, 0.0f, -0.01f), new Vector3f(16.0f, 16.0f, -0.01f), Direction.NORTH, texture, modelLocation, particle, cornerLocations));
            ForgeConnectedBlockModel.put(map, Direction.SOUTH, texture, ForgeConnectedBlockModel.bakedModel(new Vector3f(0.0f, 0.0f, 16.01f), new Vector3f(16.0f, 16.0f, 16.01f), Direction.SOUTH, texture, modelLocation, particle, cornerLocations));
            ForgeConnectedBlockModel.put(map, Direction.DOWN, texture, ForgeConnectedBlockModel.bakedModel(new Vector3f(0.0f, -0.01f, 0.0f), new Vector3f(16.0f, -0.01f, 16.0f), Direction.DOWN, texture.vFlip(), modelLocation, particle, cornerLocations));
            ForgeConnectedBlockModel.put(map, Direction.UP, texture, ForgeConnectedBlockModel.bakedModel(new Vector3f(0.0f, 16.01f, 0.0f), new Vector3f(16.0f, 16.01f, 16.0f), Direction.UP, texture, modelLocation, particle, cornerLocations));
        }
        return map;
    }

    private static BakedModel bakedModel(Vector3f from, Vector3f to, Direction direction, ConnectedBlockModel.Texture corner, ResourceLocation modelLocation, TextureAtlasSprite material, TextureAtlasSprite[] textures) {
        BlockModel dummy = new BlockModel(null, List.of(), Map.of(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        return new SimpleBakedModel.Builder(dummy, ItemOverrides.f_111734_, false).m_119528_(material).m_119530_(direction, new FaceBakery().m_111600_(from, to, FULL_FACE, textures[corner.ordinal() - 3], direction, (ModelState)BlockModelRotation.X0_Y0, null, true, modelLocation)).build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout")));
    }

    private static void put(EnumMap<Direction, EnumMap<ConnectedBlockModel.Texture, BakedModel>> map, Direction d, ConnectedBlockModel.Texture corner, BakedModel model) {
        map.get(d).put(corner, model);
    }

    public static void onBakingCompleted(ModelEvent.BakingCompleted event) {
        INSTANCES.forEach(ForgeConnectedBlockModel::lateInit);
    }
}

