/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.bakedmodel;

import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ConnectedBlockModel {
    private final Predicate<BlockState> connectionPredicate;

    public ConnectedBlockModel(Predicate<BlockState> connectionPredicate) {
        this.connectionPredicate = connectionPredicate;
    }

    public Set<Texture> getSprites(BlockAndTintGetter level, BlockPos pos, Direction direction) {
        HashSet<Texture> connections = new HashSet<Texture>();
        switch (direction) {
            case UP: 
            case DOWN: {
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.NORTH)))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.TOP_RIGHT);
                }
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.SOUTH)))) {
                    connections.add(Texture.BOTTOM_LEFT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                if (!(connections.contains((Object)Texture.TOP_LEFT) && connections.contains((Object)Texture.BOTTOM_LEFT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.WEST))))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.BOTTOM_LEFT);
                }
                if (!(connections.contains((Object)Texture.TOP_RIGHT) && connections.contains((Object)Texture.BOTTOM_RIGHT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.EAST))))) {
                    connections.add(Texture.TOP_RIGHT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                for (Texture connection : Texture.BASELESS) {
                    if (connections.contains((Object)connection) || !this.canConnect(level.m_8055_(connection.offset(pos, direction)))) continue;
                    connections.add(connection);
                }
                break;
            }
            case NORTH: {
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.UP)))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.TOP_RIGHT);
                }
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.DOWN)))) {
                    connections.add(Texture.BOTTOM_LEFT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                if (!(connections.contains((Object)Texture.TOP_LEFT) && connections.contains((Object)Texture.BOTTOM_LEFT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.EAST))))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.BOTTOM_LEFT);
                }
                if (!(connections.contains((Object)Texture.TOP_RIGHT) && connections.contains((Object)Texture.BOTTOM_RIGHT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.WEST))))) {
                    connections.add(Texture.TOP_RIGHT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                for (Texture connection : Texture.BASELESS) {
                    if (connections.contains((Object)connection) || !this.canConnect(level.m_8055_(connection.offset(pos, direction)))) continue;
                    connections.add(connection);
                }
                break;
            }
            case EAST: {
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.UP)))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.TOP_RIGHT);
                }
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.DOWN)))) {
                    connections.add(Texture.BOTTOM_LEFT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                if (!(connections.contains((Object)Texture.TOP_LEFT) && connections.contains((Object)Texture.BOTTOM_LEFT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.SOUTH))))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.BOTTOM_LEFT);
                }
                if (!(connections.contains((Object)Texture.TOP_RIGHT) && connections.contains((Object)Texture.BOTTOM_RIGHT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.NORTH))))) {
                    connections.add(Texture.TOP_RIGHT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                for (Texture connection : Texture.BASELESS) {
                    if (connections.contains((Object)connection) || !this.canConnect(level.m_8055_(connection.offset(pos, direction)))) continue;
                    connections.add(connection);
                }
                break;
            }
            case WEST: {
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.UP)))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.TOP_RIGHT);
                }
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.DOWN)))) {
                    connections.add(Texture.BOTTOM_LEFT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                if (!(connections.contains((Object)Texture.TOP_LEFT) && connections.contains((Object)Texture.BOTTOM_LEFT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.NORTH))))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.BOTTOM_LEFT);
                }
                if (!(connections.contains((Object)Texture.TOP_RIGHT) && connections.contains((Object)Texture.BOTTOM_RIGHT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.SOUTH))))) {
                    connections.add(Texture.TOP_RIGHT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                for (Texture connection : Texture.BASELESS) {
                    if (connections.contains((Object)connection) || !this.canConnect(level.m_8055_(connection.offset(pos, direction)))) continue;
                    connections.add(connection);
                }
                break;
            }
            case SOUTH: {
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.UP)))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.TOP_RIGHT);
                }
                if (this.canConnect(level.m_8055_(pos.m_121945_(Direction.DOWN)))) {
                    connections.add(Texture.BOTTOM_LEFT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                if (!(connections.contains((Object)Texture.TOP_LEFT) && connections.contains((Object)Texture.BOTTOM_LEFT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.WEST))))) {
                    connections.add(Texture.TOP_LEFT);
                    connections.add(Texture.BOTTOM_LEFT);
                }
                if (!(connections.contains((Object)Texture.TOP_RIGHT) && connections.contains((Object)Texture.BOTTOM_RIGHT) || !this.canConnect(level.m_8055_(pos.m_121945_(Direction.EAST))))) {
                    connections.add(Texture.TOP_RIGHT);
                    connections.add(Texture.BOTTOM_RIGHT);
                }
                for (Texture connection : Texture.BASELESS) {
                    if (connections.contains((Object)connection) || !this.canConnect(level.m_8055_(connection.offset(pos, direction)))) continue;
                    connections.add(connection);
                }
                break;
            }
        }
        return connections;
    }

    public boolean canConnect(BlockState state) {
        return this.connectionPredicate.test(state);
    }

    public static enum Texture {
        BASE,
        PARTICLE,
        FRONT,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        public static final Texture[] BASELESS;

        public BlockPos offset(BlockPos pos, Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP, Direction.DOWN -> {
                    switch (this) {
                        case TOP_LEFT: {
                            yield pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST);
                        }
                        case TOP_RIGHT: {
                            yield pos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST);
                        }
                        case BOTTOM_LEFT: {
                            yield pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST);
                        }
                        case BOTTOM_RIGHT: {
                            yield pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST);
                        }
                    }
                    yield pos;
                }
                case Direction.NORTH -> {
                    switch (this) {
                        case TOP_LEFT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.EAST);
                        }
                        case TOP_RIGHT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.WEST);
                        }
                        case BOTTOM_LEFT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.EAST);
                        }
                        case BOTTOM_RIGHT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.WEST);
                        }
                    }
                    yield pos;
                }
                case Direction.SOUTH -> {
                    switch (this) {
                        case TOP_LEFT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.WEST);
                        }
                        case TOP_RIGHT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.EAST);
                        }
                        case BOTTOM_LEFT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.WEST);
                        }
                        case BOTTOM_RIGHT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.EAST);
                        }
                    }
                    yield pos;
                }
                case Direction.WEST -> {
                    switch (this) {
                        case TOP_LEFT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.NORTH);
                        }
                        case TOP_RIGHT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.SOUTH);
                        }
                        case BOTTOM_LEFT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.NORTH);
                        }
                        case BOTTOM_RIGHT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.SOUTH);
                        }
                    }
                    yield pos;
                }
                case Direction.EAST -> {
                    switch (this) {
                        case TOP_LEFT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.SOUTH);
                        }
                        case TOP_RIGHT: {
                            yield pos.m_121945_(Direction.UP).m_121945_(Direction.NORTH);
                        }
                        case BOTTOM_LEFT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.SOUTH);
                        }
                        case BOTTOM_RIGHT: {
                            yield pos.m_121945_(Direction.DOWN).m_121945_(Direction.NORTH);
                        }
                    }
                    yield pos;
                }
            };
        }

        public Texture hFlip() {
            return switch (this) {
                case TOP_LEFT -> TOP_RIGHT;
                case TOP_RIGHT -> TOP_LEFT;
                case BOTTOM_LEFT -> BOTTOM_RIGHT;
                case BOTTOM_RIGHT -> BOTTOM_LEFT;
                default -> this;
            };
        }

        public Texture vFlip() {
            return switch (this) {
                case TOP_LEFT -> BOTTOM_LEFT;
                case TOP_RIGHT -> BOTTOM_RIGHT;
                case BOTTOM_LEFT -> TOP_LEFT;
                case BOTTOM_RIGHT -> TOP_RIGHT;
                default -> this;
            };
        }

        public static Optional<Texture> tryParse(String connection) {
            try {
                return Optional.of(Texture.valueOf(connection.toUpperCase(Locale.ROOT)));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }

        static {
            BASELESS = new Texture[]{TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT};
        }
    }
}

