/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.armor;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface ArmorModelProvider {
    public static final ArmorModelProvider DEFAULT = (entity, stack, slot, original) -> original;
    public static final Map<Item, ArmorModelProvider> PROVIDERS = new IdentityHashMap<Item, ArmorModelProvider>();

    @ApiStatus.Internal
    public static void register(Item item, ArmorModelProvider provider) {
        PROVIDERS.put(item, provider);
    }

    public static ArmorModelProvider get(Item item) {
        return PROVIDERS.getOrDefault(item, DEFAULT);
    }

    default public String getArmorTexture(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        return "minecraft:textures/models/armor/leather_layer_1.png";
    }

    @NotNull
    public HumanoidModel<?> getModel(LivingEntity var1, ItemStack var2, EquipmentSlot var3, HumanoidModel<?> var4);

    @NotNull
    default public Model getFinalModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
        HumanoidModel<?> replacement = this.getModel(entity, stack, slot, original);
        if (replacement != original) {
            ArmorModelProvider.copyPropertiesTo(original, replacement);
            return replacement;
        }
        return original;
    }

    public static <T extends LivingEntity> void copyPropertiesTo(HumanoidModel<T> original, HumanoidModel<?> replacement) {
        original.m_102872_(replacement);
        replacement.f_102808_.f_104207_ = original.f_102808_.f_104207_;
        replacement.f_102809_.f_104207_ = original.f_102809_.f_104207_;
        replacement.f_102810_.f_104207_ = original.f_102810_.f_104207_;
        replacement.f_102811_.f_104207_ = original.f_102811_.f_104207_;
        replacement.f_102812_.f_104207_ = original.f_102812_.f_104207_;
        replacement.f_102813_.f_104207_ = original.f_102813_.f_104207_;
        replacement.f_102814_.f_104207_ = original.f_102814_.f_104207_;
    }
}

