/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.SuperCandle;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.IncenseCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SuperCandleWick
extends Block
implements SimpleWaterloggedBlock,
BlockExtension {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape AABB = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final int NORMAL_LIGHT_LEVEL = 15;
    private static final int SOUL_LIGHT_LEVEL = 14;
    private final boolean isSoul;

    public SuperCandleWick(boolean isSoul) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76296_, (MaterialColor)MaterialColor.f_76365_).m_60910_().m_60953_(blockState -> ((Boolean)blockState.m_61143_((Property)LIT)).booleanValue() ? (isSoul ? 14 : 15) : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.isSoul = isSoul;
    }

    public boolean isSoul() {
        return this.isSoul;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos.m_7495_()).m_60734_() instanceof SuperCandle;
    }

    public void m_6861_(BlockState blockstate, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!this.m_7898_(blockstate, (LevelReader)level, pos)) {
            SuperCandleWick.extinguish(null, blockstate, (LevelAccessor)level, pos);
            level.m_46961_(pos, false);
        } else {
            super.m_6861_(blockstate, level, pos, block, fromPos, notify);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_204336_(BzTags.CANDLE_WICKS) || !newState.m_204336_(BzTags.CANDLE_WICKS)) {
            SuperCandleWick.setBelowLit((LevelAccessor)level, pos, false);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6044_(BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false && fluid.m_205067_(FluidTags.f_13131_) && fluid.m_76145_().m_76170_();
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_()) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                SuperCandleWick.extinguish(null, blockstate, level, pos);
            } else {
                level.m_7731_(pos, blockstate, 3);
            }
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entity instanceof Projectile) {
            Entity entity2;
            boolean litWick;
            Projectile projectile = (Projectile)entity;
            if (!level.f_46443_ && projectile.m_6060_() && SuperCandle.canBeLit(level, state, pos.m_7495_()) && (litWick = SuperCandleWick.setLit((LevelAccessor)level, level.m_8055_(pos), pos, true)) && (entity2 = projectile.m_19749_()) instanceof ServerPlayer) {
                IncenseCandleBlockEntity incenseCandleBlockEntity;
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                BlockEntity blockEntity = level.m_7702_(pos.m_7495_());
                if (blockEntity instanceof IncenseCandleBlockEntity && (incenseCandleBlockEntity = (IncenseCandleBlockEntity)blockEntity).getMobEffect() != null && incenseCandleBlockEntity.getMobEffect().m_8093_() && !incenseCandleBlockEntity.getMobEffect().m_19486_()) {
                    BzCriterias.PROJECTILE_LIGHT_INSTANT_INCENSE_CANDLE_TRIGGER.trigger(serverPlayer);
                }
            }
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !level.m_5776_()) {
            boolean entityInSpace;
            boolean isProjectile = entity instanceof Projectile;
            boolean bl = entityInSpace = isProjectile || Shapes.m_83157_((VoxelShape)AABB.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_()), (BooleanOp)BooleanOp.f_82689_);
            if (entityInSpace && (BzGeneralConfigs.superCandlesBurnsMobs || isProjectile) && !entity.m_5825_()) {
                entity.m_7311_(entity.m_20094_() + 1);
                if (entity.m_20094_() <= 0) {
                    entity.m_20254_(1);
                }
                entity.m_6469_(level.m_269111_().m_269387_(), 0.5f);
            }
        }
        super.m_7892_(state, level, pos, entity);
    }

    public static boolean isSoulBelowInRange(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122190_((Vec3i)blockPos);
        ChunkAccess chunkAccess = levelAccessor.m_46865_(blockPos);
        for (int i = 0; i < mutableBlockPos.m_123342_() - chunkAccess.m_141937_(); ++i) {
            BlockState currentState = chunkAccess.m_8055_((BlockPos)mutableBlockPos);
            if (currentState.m_204336_(BlockTags.f_13085_)) {
                return true;
            }
            if (!currentState.m_204336_(BzTags.CANDLE_BASES)) {
                return false;
            }
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        return false;
    }

    public static BlockPos getLitWickPositionAbove(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122190_((Vec3i)blockPos);
        ChunkAccess chunkAccess = levelAccessor.m_46865_(blockPos);
        for (int i = 0; i < chunkAccess.m_151558_() - mutableBlockPos.m_123342_(); ++i) {
            BlockState currentState = chunkAccess.m_8055_((BlockPos)mutableBlockPos);
            if (currentState.m_204336_(BzTags.CANDLE_WICKS)) {
                return mutableBlockPos.m_7949_();
            }
            if (!currentState.m_204336_(BzTags.CANDLE_BASES)) {
                return null;
            }
            mutableBlockPos.m_122173_(Direction.UP);
        }
        return null;
    }

    public static boolean setLit(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, boolean lit) {
        if (!(!(blockState.m_60734_() instanceof SuperCandleWick) || lit && ((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue())) {
            boolean litWick;
            boolean isBelowSoul = SuperCandleWick.isSoulBelowInRange(levelAccessor, blockPos.m_7495_());
            Block wickBlock = isBelowSoul && lit ? BzBlocks.SUPER_CANDLE_WICK_SOUL.get() : BzBlocks.SUPER_CANDLE_WICK.get();
            boolean bl = litWick = levelAccessor.m_7731_(blockPos, (BlockState)((BlockState)wickBlock.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WATERLOGGED))), 11) && lit;
            if (lit) {
                levelAccessor.m_5594_(null, blockPos, BzSounds.SUPER_CANDLE_WICK_LIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            SuperCandleWick.setBelowLit(levelAccessor, blockPos, lit);
            return litWick;
        }
        return false;
    }

    public static void setBelowLit(LevelAccessor levelAccessor, BlockPos blockPos, boolean lit) {
        BlockPos belowPos = blockPos.m_7495_();
        BlockState candleBase = levelAccessor.m_8055_(belowPos);
        if (candleBase.m_60734_() instanceof SuperCandle) {
            levelAccessor.m_7731_(belowPos, (BlockState)candleBase.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 11);
        }
    }

    public static void extinguish(Player player, BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        SuperCandleWick.setLit(levelAccessor, blockState, blockPos, false);
        if (blockState.m_60734_() instanceof SuperCandleWick) {
            levelAccessor.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.2, (double)blockPos.m_123343_() + 0.5, 0.0, (double)0.1f, 0.0);
        }
        levelAccessor.m_5594_(null, blockPos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
        levelAccessor.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            SuperCandleWick.addParticlesAndSound(level, new Vec3((double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.26 - 0.13), (double)pos.m_123342_() + 0.75 + random.m_188500_() * 0.15, (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.26 - 0.13)), random, this.isSoul);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.55, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        if (blockState.m_204336_(BzTags.CANDLE_WICKS) && ((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            if (this.isSoul) {
                return 3;
            }
            return 5;
        }
        return 0;
    }

    private static void addParticlesAndSound(Level level, Vec3 offset, RandomSource random, boolean isSoul) {
        float chance = random.m_188501_();
        if (chance < 0.5f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
            if (chance < 0.17f) {
                level.m_7785_(offset.f_82479_, offset.f_82480_ + 0.5, offset.f_82481_, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        if (chance < 0.2f) {
            if (isSoul) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, offset.f_82479_, offset.f_82480_ - 0.75, offset.f_82481_, 0.0, 0.0, 0.0);
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, offset.f_82479_, offset.f_82480_ - 0.75, offset.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return !state.m_61138_((Property)LIT) || (Boolean)state.m_61143_((Property)LIT) == false;
    }

    @Override
    public BlockPathTypes bz$getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, Mob mob) {
        if (state.m_61138_((Property)LIT) && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        return null;
    }

    public static void attemptCandleLighting(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockState currentState = levelAccessor.m_8055_(blockPos);
        if (currentState.m_204336_(BzTags.CANDLE_BASES)) {
            currentState = levelAccessor.m_8055_(blockPos.m_7494_());
        }
        if (currentState.m_60734_() instanceof SuperCandleWick && !((Boolean)currentState.m_61143_((Property)LIT)).booleanValue() && !((Boolean)currentState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            boolean isBelowSoul = SuperCandleWick.isSoulBelowInRange(levelAccessor, blockPos.m_7495_());
            Block wickBlock = isBelowSoul ? BzBlocks.SUPER_CANDLE_WICK_SOUL.get() : BzBlocks.SUPER_CANDLE_WICK.get();
            levelAccessor.m_7731_(blockPos, (BlockState)wickBlock.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
            levelAccessor.m_5594_(null, blockPos, BzSounds.SUPER_CANDLE_WICK_LIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            SuperCandleWick.setBelowLit(levelAccessor, blockPos, true);
        }
    }
}

